# DSS and R[¶](https://doc.dataiku.com/dss/latest/R/index.html#dss-and-r "Permalink to this headline")

DSS includes deep integration with R. In many parts of DSS, you can write R code:

* In recipes (both regular R, SparkR and Sparklyr)

* In Jupyter notebooks

* For Shiny webapps

* In plugins

* In API node, for custom prediction models or custom functions endpoints

Any R package may be used in DSS.

In addition, DSS features a complete R API, which has its own documentation.

The following highlights how a few specific R packages can be used in DSS. DSS features advanced integration with most of the packages described below.

DSS also has integration with RStudio

* Installing R packages

+ Installing in a specific code environment (recommended)

+ Installing in the root DSS environment (not recommended)

- Installing without Internet access

* Reusing R code

+ Sharing R code within a project

- Working with multiple source folders

+ Importing libraries from other projects

+ Sharing R code globally

- Permissions

+ Manual editing of the R code library folder

+ Packaging code as plugins

+ Packaging your R code as a package

* Using ggplot2

+ Installing ggplot2

+ Displaying charts in a Jupyter notebook

+ Displaying charts on a dashboard

- Refreshing charts on a dashboard

+ Using in Shiny

* Using Dygraphs

+ Installing dygraphs

+ Displaying charts in a Jupyter notebook

- Converting a date column to a time-series

+ Displaying charts on a dashboard

- Refreshing charts on a dashboard

+ Using in Shiny

* Using googleVis

+ Installing googleVis

+ Displaying charts in a Jupyter notebook

+ Displaying charts on a dashboard

- Refreshing charts on a dashboard

* Using ggvis

+ Installing ggvis

- Installing the ggvis package

- Installing the frontend dependencies

+ Displaying charts in a Jupyter notebook

+ Displaying charts on a dashboard

- Refreshing charts on a dashboard

* Installing STAN or Prophet

+ Common errors

+ Installing on RedHat 7 or Centos 7

* RStudio integration

+ RStudio Desktop

+ RStudio Server (running on a separate server)

- Embedding the RStudio Server UI in DSS

+ RStudio Server (running on the DSS server)

- Installing the R package

- Setup connectivity

- Create RStudio project
