# Authentication information[¶](https://doc.dataiku.com/dss/latest/R-api/authinfo.html#authentication-information "Permalink to this headline")

## Introduction[¶](https://doc.dataiku.com/dss/latest/R-api/authinfo.html#introduction "Permalink to this headline")

From any R code, it is possible to retrieve information about the user or API key currently running this code.

This can be used:

* From code running within a recipe or notebook, for the code to know who is running said code

* From code running with a plugin recipe, for the code to know who is running said code

Furthermore, the API provides the ability, from a set of HTTP headers, to identify the user represented by these headers. This can be used in the backend of a Shiny webapp, in order to securely identify which user is currently browsing the webapp.

## Code samples[¶](https://doc.dataiku.com/dss/latest/R-api/authinfo.html#code-samples "Permalink to this headline")

### Basic usage[¶](https://doc.dataiku.com/dss/latest/R-api/authinfo.html#basic-usage "Permalink to this headline")

§ library(dataiku)

§ auth\_info = dkuGetAuthInfo()

§ # auth\_info is list dict which contains at least a "authIdentifier" member

§ print(auth\_info$authIdentifier)

### Other samples[¶](https://doc.dataiku.com/dss/latest/R-api/authinfo.html#other-samples "Permalink to this headline")

* How to authenticate calls made from a Shiny webapp: https://github.com/dataiku/dss-code-samples/tree/master/\_old/visualization/shiny/authenticate-calls

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/R-api/authinfo.html#reference-documentation "Permalink to this headline")

See:

* https://doc.dataiku.com/dss/api/5.0/R/dataiku/reference/dkuGetAuthInfo.html

* https://doc.dataiku.com/dss/api/5.0/R/dataiku/reference/dkuGetAuthInfoFromBrowserHeaders.html

* https://doc.dataiku.com/dss/api/5.0/R/dataiku/reference/dkuGetAuthInfoFromRookRequest.html
