# Metrics and checks[¶](https://doc.dataiku.com/dss/latest/api/python/metrics.html#metrics-and-checks "Permalink to this headline")

Note

There are two main parts related to handling of metrics and checks in Dataiku’s Python APIs:

* `dataiku.core.metrics.ComputedMetrics` in the dataiku package. It was initially designed for usage within DSS

* `dataikuapi.dss.metrics.ComputedMetrics` in the dataikuapi package. It was initially designed for usage outside of DSS.

Both classes have fairly similar capabilities

For more details on the two packages, please see Python APIs

## dataiku package API[¶](https://doc.dataiku.com/dss/latest/api/python/metrics.html#dataiku-package-api "Permalink to this headline")

*class* `dataiku.core.metrics.``ComputedMetrics`(*raw*)

Handle to the metrics of a DSS object and their last computed value

`get_metric_by_id`(*metric\_id*)

Retrive the info for a given metric

* Parameters: **metric\_id** – unique identifier of the metric

`get_global_data`(*metric\_id*)

Get the global value point of a given metric, or throws.

For a partitioned dataset, the global value is the value of the metric computed on the whole dataset (coded as partition ‘ALL’).

* Parameters: **metric\_id** – unique identifier of the metric

`get_global_value`(*metric\_id*)

Get the global value of a given metric, or throws.

For a partitioned dataset, the global value is the value of the metric computed on the whole dataset (coded as partition ‘ALL’).

* Parameters: **metric\_id** – unique identifier of the metric

`get_partition_data`(*metric\_id*, *partition*)

Get the value point of a given metric for a given partition, or throws.

* Parameters: * **metric\_id** – unique identifier of the metric
* **partition** – partition identifier

`get_partition_value`(*metric\_id*, *partition*)

Get the value of a given metric for a given partition, or throws.

* Parameters: * **metric\_id** – unique identifier of the metric
* **partition** – partition identifier

`get_first_partition_data`(*metric\_id*)

Get a value point of a given metric, or throws. The first value encountered is returned.

* Parameters: **metric\_id** – unique identifier of the metric

`get_partition_data_for_version`(*metric\_id*, *version\_id*)

Get for a metric the first partition matching version\_id :param metric\_id: unique identifier of the metric :param version\_id: unique identifier of the version :return:

`get_all_ids`()

Get the identifiers of all metrics defined in this object

*static* `get_value_from_data`(*data*)

Retrieves the value from a metric point, cast in the appropriate type (str, int or float).

For other types, the value is not cast and left as a string.

* Parameters: **data** – a value point for a metric, retrieved with `dataiku.ComputedMetrics.get\_global\_data()` or `dataiku.ComputedMetrics.get\_partition\_data()`

*class* `dataiku.core.metrics.``MetricDataPoint`(*raw*)

A value of a metric, on a partition

`get_metric`()

Returns the metric as a JSON object

`get_metric_id`()

Returns the metric’s id

`get_partition`()

Returns the partition on which the value was computed

`get_value`()

Returns the value of the metric, as a string

`get_compute_time`()

Returns the time at which the value was computed

`get_type`()

Returns the type of the value

*class* `dataiku.core.metrics.``ComputedChecks`(*raw*)

Handle to the checks of a DSS object and their last computed value

`get_check_by_name`(*check\_name*)

Retrive the info for a given check

* Parameters: **check\_name** – unique identifier of the check

`get_global_data`(*check\_name*)

Get the global value point of a given check, or throws.

For a partitioned dataset, the global value is the value of the check computed on the whole dataset (coded as partition ‘ALL’).

* Parameters: **check\_name** – unique identifier of the check

`get_global_value`(*check\_name*)

Get the global value of a given check, or throws.

For a partitioned dataset, the global value is the value of the check computed on the whole dataset (coded as partition ‘ALL’).

* Parameters: **check\_name** – unique identifier of the check

`get_partition_data`(*check\_name*, *partition*)

Get the value point of a given check for a given partition, or throws.

* Parameters: * **check\_name** – unique identifier of the check
* **partition** – partition identifier

`get_partition_value`(*check\_name*, *partition*)

Get the value of a given check for a given partition, or throws.

* Parameters: * **check\_name** – unique identifier of the check
* **partition** – partition identifier

`get_first_partition_data`(*check\_name*)

Get a value point of a given check, or throws. The first value encountered is returned.

* Parameters: **check\_name** – unique identifier of the check

`get_all_names`()

Get the identifiers of all checks defined in this object

*static* `get_outcome_from_data`(*data*)

Retrieves the value from a check point, cast in the appropriate type (str, int or float).

For other types, the value is not cast and left as a string.

* Parameters: **data** – a value point for a check, retrieved with `dataiku.ComputedChecks.get\_global\_data()` or `dataiku.ComputedChecks.get\_partition\_data()`

*class* `dataiku.core.metrics.``CheckDataPoint`(*raw*)

A value of a check, on a partition

`get_check`()

Returns the check as a JSON object

`get_partition`()

Returns the partition on which the value was computed

`get_value`()

Returns the value of the check, as a string

`get_compute_time`()

Returns the time at which the value was computed

## dataikuapi package API[¶](https://doc.dataiku.com/dss/latest/api/python/metrics.html#dataikuapi-package-api "Permalink to this headline")

*class* `dataikuapi.dss.metrics.``ComputedMetrics`(*raw*)

`get_metric_by_id`(*id*)

`get_global_data`(*metric\_id*)

`get_global_value`(*metric\_id*)

`get_partition_data`(*metric\_id*, *partition*)

`get_partition_value`(*metric\_id*, *partition*)

`get_first_partition_data`(*metric\_id*)

`get_all_ids`()

*static* `get_value_from_data`(*data*)
