# Other administration tasks[¶](https://doc.dataiku.com/dss/latest/api/python/other-administration.html#other-administration-tasks "Permalink to this headline")

Here are some more global administration tasks that can be performed using the DSS Public API:

* Reading and writing general instance settings

* Managing user and group impersonation rules for User Isolation Framework

* Managing (creating / modifying) code environments

* Managing instance variables

* Listing long running tasks, getting their status, aborting them

* Listing running notebooks, getting their status, unloading them

* Managing global API keys

* Listing global DSS usages (projects, datasets, recipes, scenarios…)

* Managing personal API keys

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/api/python/other-administration.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.admin.``DSSGeneralSettings`(*client*)

The general settings of the DSS instance. Do not create this object directly, use `dataikuapi.DSSClient.get\_general\_settings()` instead.

`save`()

Save the changes that were made to the settings on the DSS instance Note: this call requires an API key with admin rights

`get_raw`()

Get the settings as a dictionary

`add_impersonation_rule`(*rule*, *is\_user\_rule=True*)

Add a rule to the impersonation settings

* Parameters: * **rule** – an impersonation rule, either a `dataikuapi.dss.admin.DSSUserImpersonationRule`
or a `dataikuapi.dss.admin.DSSGroupImpersonationRule`, or a plain dict
* **is\_user\_rule** – when the rule parameter is a dict, whether the rule is for users or groups

`get_impersonation_rules`(*dss\_user=None*, *dss\_group=None*, *unix\_user=None*, *hadoop\_user=None*, *project\_key=None*, *scope=None*, *rule\_type=None*, *is\_user=None*)

Retrieve the user or group impersonation rules that matches the parameters

* Parameters: * **dss\_user** – a DSS user or regular expression to match DSS user names
* **dss\_group** – a DSS group or regular expression to match DSS groups
* **unix\_user** – a name to match the target UNIX user
* **hadoop\_user** – a name to match the target Hadoop user
* **project\_key** – a project\_key
* **scope** – project-scoped (‘PROJECT’) or global (‘GLOBAL’)
* **type** – the rule user or group matching method (‘IDENTITY’, ‘SINGLE\_MAPPING’, ‘REGEXP\_RULE’)
* **is\_user** – True if only user-level rules should be considered, False for only group-level rules, None to consider both

`remove_impersonation_rules`(*dss\_user=None*, *dss\_group=None*, *unix\_user=None*, *hadoop\_user=None*, *project\_key=None*, *scope=None*, *rule\_type=None*, *is\_user=None*)

Remove the user or group impersonation rules that matches the parameters from the settings

* Parameters: * **dss\_user** – a DSS user or regular expression to match DSS user names
* **dss\_group** – a DSS group or regular expression to match DSS groups
* **unix\_user** – a name to match the target UNIX user
* **hadoop\_user** – a name to match the target Hadoop user
* **project\_key** – a project\_key
* **scope** – project-scoped (‘PROJECT’) or global (‘GLOBAL’)
* **type** – the rule user or group matching method (‘IDENTITY’, ‘SINGLE\_MAPPING’, ‘REGEXP\_RULE’)
* **is\_user** – True if only user-level rules should be considered, False for only group-level rules, None to consider both

`push_container_exec_base_images`()

Push the container exec base images to their repository

*class* `dataikuapi.dss.admin.``DSSUserImpersonationRule`(*raw=None*)

Helper to build user-level rule items for the impersonation settings

`scope_global`()

Make the rule apply to all projects

`scope_project`(*project\_key*)

Make the rule apply to a given project

* Args:: project\_key : the project this rule applies to

`user_identity`()

Make the rule map each DSS user to a UNIX user of the same name

`user_single`(*dss\_user*, *unix\_user*, *hadoop\_user=None*)

Make the rule map a given DSS user to a given UNIX user

* Args:: dss\_user : a DSS user
unix\_user : a UNIX user
hadoop\_user : a Hadoop user (optional, defaults to unix\_user)

`user_regexp`(*regexp*, *unix\_user*, *hadoop\_user=None*)

Make the rule map a DSS users matching a given regular expression to a given UNIX user

* Args:: regexp : a regular expression to match DSS user names
unix\_user : a UNIX user
hadoop\_user : a Hadoop user (optional, defaults to unix\_user)

*class* `dataikuapi.dss.admin.``DSSGroupImpersonationRule`(*raw=None*)

Helper to build group-level rule items for the impersonation settings

`group_identity`()

Make the rule map each DSS user to a UNIX user of the same name

`group_single`(*dss\_group*, *unix\_user*, *hadoop\_user=None*)

Make the rule map a given DSS user to a given UNIX user

* Args:: dss\_group : a DSS group
unix\_user : a UNIX user
hadoop\_user : a Hadoop user (optional, defaults to unix\_user)

`group_regexp`(*regexp*, *unix\_user*, *hadoop\_user=None*)

Make the rule map a DSS users matching a given regular expression to a given UNIX user

* Args:: regexp : a regular expression to match DSS groups
unix\_user : a UNIX user
hadoop\_user : a Hadoop user (optional, defaults to unix\_user)

*class* `dataikuapi.dss.admin.``DSSInstanceVariables`(*client*, *variables*)

Dict containing the instance variables. The variables can be modified directly in the dict and persisted using its `save()` method.

Do not create this object directly, use `dataikuapi.DSSClient.get\_global\_variables()` instead.

`save`()

Save the changes made to the instance variables.

Note: this call requires an API key with admin rights.

*class* `dataikuapi.dss.future.``DSSFuture`(*client*, *job\_id*, *state=None*, *result\_wrapper=<function DSSFuture.<lambda>>*)

A future on the DSS instance

*static* `from_resp`(*client*, *resp*, *result\_wrapper=<function DSSFuture.<lambda>>*)

Creates a DSSFuture from a parsed JSON response

*classmethod* `get_result_wait_if_needed`(*client*, *ret*)

`abort`()

Abort the future

`get_state`()

Get the status of the future, and its result if it’s ready

`peek_state`()

Get the status of the future, and its result if it’s ready

`get_result`()

Get the future result if it’s ready, raises an Exception otherwise

`has_result`()

Checks whether the future has a result ready

`wait_for_result`()

Wait and get the future result

*class* `dataikuapi.dss.jupyternotebook.``DSSJupyterNotebook`(*client*, *project\_key*, *notebook\_name*)

`unload`(*session\_id=None*)

Stop this Jupyter notebook and release its resources

`get_sessions`(*as\_objects=False*)

Get the list of running sessions of this Jupyter notebook

* Parameters: **as\_objects** (*boolean*) – if True, each returned item will be a `dataikuapi.dss.notebook.DSSNotebookSession`

* Return type: list of `dataikuapi.dss.notebook.DSSNotebookSession` or list of dict

`get_content`()

Get the content of this Jupyter notebook (metadata, cells, nbformat)

`delete`()

Delete this Jupyter notebook and stop all of its active sessions.

`get_object_discussions`()

Get a handle to manage discussions on the notebook

* Returns: the handle to manage discussions

* Return type: `dataikuapi.discussion.DSSObjectDiscussions`

*class* `dataikuapi.dss.jupyternotebook.``DSSJupyterNotebookListItem`(*client*, *data*)

An item in a list of Jupyter notebooks. Do not instantiate this class, use `dataikuapi.dss.project.DSSProject.list\_jupyter\_notebooks()`

`to_notebook`()

Gets the `DSSJupyterNotebook` corresponding to this notebook

*property* `name`

*property* `language`

*property* `kernel_spec`

*class* `dataikuapi.dss.jupyternotebook.``DSSNotebookSession`(*client*, *session*)

Metadata associated to the session of a Jupyter Notebook. Do not create this directly, use `DSSJupyterNotebook.get\_sessions()`

`unload`()

Stop this Jupyter notebook and release its resources

*class* `dataikuapi.dss.jupyternotebook.``DSSNotebookContent`(*client*, *project\_key*, *notebook\_name*, *content*)

Content of a Jupyter Notebook. Do not create this directly, use `DSSJupyterNotebook.get\_content()`

`get_raw`()

Get the content of this Jupyter notebook (metadata, cells, nbformat) :rtype: a dict containing the full content of a notebook

`get_metadata`()

Get the metadata associated to this Jupyter notebook :rtype: dict with metadata

`get_cells`()

Get the cells associated to this Jupyter notebook :rtype: list of cells

`save`()

Save the content of this Jupyter notebook

*class* `dataikuapi.dss.notebook.``DSSNotebook`(*client*, *project\_key*, *notebook\_name*, *state=None*)

Deprecated. Use DSSJupyterNotebook A Python/R/Scala notebook on the DSS instance

`unload`(*session\_id=None*)

Deprecated. Use DSSJupyterNotebook Stop this Jupyter notebook and release its resources

`get_state`()

Deprecated. Use DSSJupyterNotebook Get the metadata associated to this Jupyter notebook

`get_sessions`()

Deprecated. Use DSSJupyterNotebook Get the list of running sessions of this Jupyter notebook

`get_object_discussions`()

Deprecated. Use DSSJupyterNotebook Get a handle to manage discussions on the notebook

* Returns: the handle to manage discussions

* Return type: `dataikuapi.discussion.DSSObjectDiscussions`

*class* `dataikuapi.dss.admin.``DSSGlobalApiKey`(*client*, *key*)

A global API key on the DSS instance

`delete`()

Delete the api key

Note: this call requires an API key with admin rights

`get_definition`()

Get the API key’s definition

Note: this call requires an API key with admin rights

* Returns:: the code env definition, as a JSON object

`set_definition`(*definition*)

Set the API key’s definition.

Note: this call requires an API key with admin rights

* Args:: definition: the definition for the API key, as a JSON object.

*class* `dataikuapi.dss.admin.``DSSPersonalApiKey`(*client*, *id\_*)

A personal API key on the DSS instance. Do not create this object directly, use `dataikuapi.DSSClient.get\_personal\_api\_key()` instead.

`get_definition`()

Get the API key’s definition

* Returns: the personal API key definition, as a JSON object

`delete`()

Delete the API key

*class* `dataikuapi.dss.admin.``DSSPersonalApiKeyListItem`(*client*, *data*)

An item in a list of personal API key.  Do not create this object directly, use `dataikuapi.DSSClient.list\_personal\_api\_keys()` or `dataikuapi.DSSClient.list\_all\_personal\_api\_keys()` instead.

`to_personal_api_key`()

Gets the `DSSPersonalApiKey` corresponding to this item

*property* `id`

*property* `user`

*property* `key`

*property* `label`

*property* `description`

*property* `created_on`

*property* `created_by`

*class* `dataikuapi.dss.admin.``DSSGlobalUsageSummary`(*data*)

The summary of the usage of the DSS instance. Do not create this object directly, use `dataikuapi.dss.DSSClient.get\_global\_usage\_summary()` instead.

*property* `raw`

*property* `projects_count`

*property* `total_datasets_count`

*property* `total_recipes_count`

*property* `total_jupyter_notebooks_count`

*property* `total_sql_notebooks_count`

*property* `total_scenarios_count`

*property* `total_active_with_trigger_scenarios_count`
