# API Designer & Deployer[¶](https://doc.dataiku.com/dss/latest/api/python/api-services.html#api-designer-deployer "Permalink to this headline")

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/api/python/api-services.html#reference-documentation "Permalink to this headline")

### API Designer[¶](https://doc.dataiku.com/dss/latest/api/python/api-services.html#module-dataikuapi.dss.apiservice "Permalink to this headline")

*class* `dataikuapi.dss.apiservice.``DSSAPIServiceSettings`(*client*, *project\_key*, *service\_id*, *settings*)

The settings of an API Service in the API Designer

Do not create this directly, use `DSSAPIService.get\_settings()`

`get_raw`()

Gets the raw settings of this API Service. This returns a reference to the raw settings, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`add_prediction_endpoint`(*endpoint\_id*, *saved\_model\_id*)

Adds a new “visual prediction” endpoint to this API service

* Parameters: * **endpoint\_id** (*str*) – Identifier of the new endpoint to create
* **saved\_model\_id** (*str*) – Identifier of the saved model (deployed to Flow) to use

`add_clustering_endpoint`(*endpoint\_id*, *saved\_model\_id*)

Adds a new “visual clustering” endpoint to this API service

* Parameters: * **endpoint\_id** (*str*) – Identifier of the new endpoint to create
* **saved\_model\_id** (*str*) – Identifier of the saved model (deployed to Flow) to use

`add_forecasting_endpoint`(*endpoint\_id*, *saved\_model\_id*)

Adds a new “visual time series forecasting” endpoint to this API service

* Parameters: * **endpoint\_id** (*str*) – Identifier of the new endpoint to create
* **saved\_model\_id** (*str*) – Identifier of the saved model (deployed to Flow) to use

`save`()

Saves back these settings to the API Service

*class* `dataikuapi.dss.apiservice.``DSSAPIService`(*client*, *project\_key*, *service\_id*)

An API Service from the API Designer on the DSS instance

Do not create this directly, use `dataikuapi.dss.project.DSSProject.get\_api\_service()`

`get_settings`()

Gets the settings of this API Service

`list_packages`()

List the versions of this API service

* Returns: a list of dictionaries, with one item per version.
Each dictionary contains at least a ‘id’ field which is the version identifier

* Return type: list of dict

`create_package`(*package\_id*)

Create a new version of this API service

* Parameters: **package\_id** (*str*) – Identifier of the new version to create

`delete_package`(*package\_id*)

Delete a version of this API service

`download_package_stream`(*package\_id*)

Download a package archive that can be deployed in a DSS API Node, as a binary stream.

Warning: this stream will monopolize the DSSClient until closed.

`download_package_to_file`(*package\_id*, *path*)

Download a package archive that can be deployed in a DSS API Node, into the given output file.

`publish_package`(*package\_id*, *published\_service\_id=None*)

Publish a package on the API Deployer.

* Parameters: * **package\_id** (*string*) – The identifier of the package
* **published\_service\_id** (*string*) – The identifier of the API service on the API Deployer where the package will be published.
A new published API service will be created if none matches the identifier.
If the parameter is not set, the identifier from the current `DSSAPIService` is used.

### API Deployer[¶](https://doc.dataiku.com/dss/latest/api/python/api-services.html#api-deployer "Permalink to this headline")

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployer`(*client*)

Handle to interact with the API Deployer.

Do not create this directly, use `dataikuapi.dss.DSSClient.get\_apideployer()`

`list_deployments`(*as\_objects=True*)

Lists deployments on the API Deployer

* Parameters: **as\_objects** (*boolean*) – if True, returns a list of `DSSAPIDeployerDeployment`, else returns a list of dict.
Each dict contains at least a field “id” indicating the identifier of this deployment

* Returns: a list - see as\_objects for more information

* Return type: list

`get_deployment`(*deployment\_id*)

Returns a handle to interact with a single deployment, as a `DSSAPIDeployerDeployment`

* Parameters: **deployment\_id** (*str*) – Identifier of the deployment to get

* Return type: `DSSAPIDeployerDeployment`

`create_deployment`(*deployment\_id*, *service\_id*, *infra\_id*, *version*, *ignore\_warnings=False*)

Creates a deployment and returns the handle to interact with it. The returned deployment is not yet started and you need to call `start\_update()`

* Parameters: * **deployment\_id** (*str*) – Identifier of the deployment to create
* **service\_id** (*str*) – Identifier of the API Service to target
* **infra\_id** (*str*) – Identifier of the deployment infrastructure to use
* **version\_id** (*str*) – Identifier of the API Service version to deploy
* **ignore\_warnings** (*boolean*) – ignore warnings concerning the governance status of the model version(s) to deploy

* Return type: `DSSAPIDeployerDeployment`

`list_stages`()

Lists infrastructure stages of the API Deployer

* Return type: list of dict. Each dict contains a field “id” for the stage identifier and “desc” for its description.

* Return type: list

`list_infras`(*as\_objects=True*)

Lists deployment infrastructures on the API Deployer

* Parameters: **as\_objects** (*boolean*) – if True, returns a list of `DSSAPIDeployerInfra`, else returns a list of dict.
Each dict contains at least a field “id” indicating the identifier of this infra

* Returns: a list - see as\_objects for more information

* Return type: list

`create_infra`(*infra\_id*, *stage*, *type*, *govern\_check\_policy='NO\_CHECK'*)

Creates a new infrastructure on the API Deployer and returns the handle to interact with it.

* Parameters: * **infra\_id** (*str*) – Unique Identifier of the infra to create
* **stage** (*str*) – Infrastructure stage. Stages are configurable on each API Deployer
* **type** (*str*) – STATIC or KUBERNETES
* **govern\_check\_policy** (*str*) – PREVENT, WARN, or NO\_CHECK depending if the deployer will check wether the saved model versions deployed on this infrastructure has to be managed and approved in Dataiku Govern

* Return type: `DSSAPIDeployerInfra`

`get_infra`(*infra\_id*)

Returns a handle to interact with a single deployment infra, as a `DSSAPIDeployerInfra`

* Parameters: **infra\_id** (*str*) – Identifier of the infra to get

* Return type: `DSSAPIDeployerInfra`

`list_services`(*as\_objects=True*)

Lists API services on the API Deployer

* Parameters: **as\_objects** (*boolean*) – if True, returns a list of `DSSAPIDeployerService`, else returns a list of dict.
Each dict contains at least a field “id” indicating the identifier of this Service

* Returns: a list - see as\_objects for more information

* Return type: list

`create_service`(*service\_id*)

Creates a new API Service on the API Deployer and returns the handle to interact with it.

* Parameters: **service\_id** (*str*) – Identifier of the API Service to create

* Return type: `DSSAPIDeployerService`

`get_service`(*service\_id*)

Returns a handle to interact with a single service, as a `DSSAPIDeployerService`

* Parameters: **service\_id** (*str*) – Identifier of the API service to get

* Return type: `DSSAPIDeployerService`

#### Infrastructures[¶](https://doc.dataiku.com/dss/latest/api/python/api-services.html#infrastructures "Permalink to this headline")

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployerInfra`(*client*, *infra\_id*)

An API Deployer infrastructure.

Do not create this directly, use `get\_infra()`

*property* `id`

`get_status`()

Returns status information about this infrastructure

* Return type: `dataikuapi.dss.apideployer.DSSAPIDeployerInfraStatus`

`get_settings`()

Gets the settings of this infra. If you want to modify the settings, you need to call `save()` on the returned  object

* Returns: a `dataikuapi.dss.apideployer.DSSAPIDeployerInfraSettings`

`delete`()

Deletes this infra You may only delete an infra if it has no deployments on it anymore.

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployerInfraSettings`(*client*, *infra\_id*, *settings*)

The settings of an API Deployer infrastructure

Do not create this directly, use `get\_settings()`

`get_type`()

Gets the type of this infra, either STATIC or K8S

`add_apinode`(*url*, *api\_key*, *graphite\_prefix=None*)

Adds an API node to the list of nodes of this infra.

Only applicable to STATIC infrastructures

`remove_apinode`(*node\_url*)

Removes a node from the list of nodes of this infra. Only applicable to STATIC infrastructures

* Parameters: **node\_url** (*str*) – URL of the node to remove

`get_raw`()

Gets the raw settings of this infra. This returns a reference to the raw settings, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`save`()

Saves back these settings to the infra

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployerInfraStatus`(*client*, *infra\_id*, *light\_status*)

The status of an API Deployer infrastructure.

Do not create this directly, use `get\_status()`

`get_deployments`()

Returns the deployments that are deployed on this infrastructure

* Returns: a list of deployments

* Return type: list of `dataikuapi.dss.apideployer.DSSAPIDeployerDeployment`

`get_raw`()

Gets the raw status information. This returns a dictionary with various information about the infrastructure

* Return type: dict

#### API Services[¶](https://doc.dataiku.com/dss/latest/api/python/api-services.html#api-services "Permalink to this headline")

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployerService`(*client*, *service\_id*)

An API service on the API Deployer

Do not create this directly, use `get\_service()`

*property* `id`

`get_status`()

Returns status information about this service. This is used mostly to get information about which versions are available and which deployments are exposing this service

* Return type: dataikuapi.dss.apideployer.DSSAPIDeployerServiceStatus

`import_version`(*fp*)

Imports a new version for an API service from a file-like object pointing  to a version package Zip file

* Parameters: **fp** (*string*) – A file-like object pointing to a version package Zip file

`get_settings`()

Gets the settings of this service. If you want to modify the settings, you need to call `save()` on the returned  object.

The main things that can be modified in a service settings are permissions

* Returns: a `dataikuapi.dss.apideployer.DSSAPIDeployerServiceSettings`

`delete_version`(*version*)

Deletes a version from this service

* Parameters: **version** (*string*) – The version to delete

`delete`()

Deletes this service

You may only delete a service if it has no deployments on it anymore.

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployerServiceSettings`(*client*, *service\_id*, *settings*)

The settings of an API Deployer Service.

Do not create this directly, use `get\_settings()`

`get_raw`()

Gets the raw settings of this deployment. This returns a reference to the raw settings, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`save`()

Saves back these settings to the API service

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployerServiceStatus`(*client*, *service\_id*, *light\_status*)

The status of an API Deployer Service.

Do not create this directly, use `get\_status()`

`get_deployments`(*infra\_id=None*)

Returns the deployments that have been created from this published project

* Parameters: **infra\_id** (*str*) – Identifier of an infra, allows to only keep in the returned list the deployments on this infra.

If not set, the list contains all the deployments using this published project, across every infra of the Project Deployer.

* Returns: a list of deployments

* Return type: list of `dataikuapi.dss.apideployer.DSSAPIDeployerDeployment`

`get_versions`()

Returns the versions of this service that have been published on the API Service

Each version is a dict that contains at least a “id” field, which is the version identifier

* Returns: a list of versions, each as a dict containing a “id” field

* Return type: list of dicts

`get_raw`()

Gets the raw status information. This returns a dictionary with various information about the service,

* Return type: dict

#### Deployments[¶](https://doc.dataiku.com/dss/latest/api/python/api-services.html#deployments "Permalink to this headline")

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployerDeployment`(*client*, *deployment\_id*)

A Deployment on the API Deployer

Do not create this directly, use `get\_deployment()`

*property* `id`

`get_status`()

Returns status information about this deployment

* Return type: dataikuapi.dss.apideployer.DSSAPIDeployerDeploymentStatus

`get_governance_status`(*version=''*)

Returns the governance status about this deployment if applicable It covers all the embedded model versions

* Parameters: **version** (*str*) – (Optional) The specific package version of the published service to get status from. If empty, consider all the versions used in the deployment generation mapping.

* Return type: dict InforMessages containing the governance status

`get_settings`()

Gets the settings of this deployment. If you want to modify the settings, you need to call `save()` on the returned  object

* Returns: a `dataikuapi.dss.apideployer.DSSAPIDeployerDeploymentSettings`

`start_update`()

Starts an asynchronous update of this deployment to try to match the actual state to the current settings

* Returns: a `dataikuapi.dss.future.DSSFuture` tracking the progress of the update. Call 
`wait\_for\_result()` on the returned object
to wait for completion (or failure)

`delete`(*disable\_first=False*)

Deletes this deployment. The disable\_first flag automatically disables the deployment before its deletion.

* Parameters: **disable\_first** (*boolean*) – If True, automatically disables this deployment before deleting it.

If False, will raise an Exception if this deployment is enabled.

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployerDeploymentSettings`(*client*, *deployment\_id*, *settings*)

The settings of an API Deployer deployment.

Do not create this directly, use `get\_settings()`

`get_raw`()

Gets the raw settings of this deployment. This returns a reference to the raw settings, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`set_enabled`(*enabled*)

Enables or disables this deployment

`set_single_version`(*version*)

Sets this deployment to target a single version of the API service

* Parameters: **version** (*str*) – Identifier of the version to set

`save`(*ignore\_warnings=False*)

Saves back these settings to the deployment

* Parameters: **ignore\_warnings** (*boolean*) – ignore warnings concerning the governance status of the model version(s) to deploy

*class* `dataikuapi.dss.apideployer.``DSSAPIDeployerDeploymentStatus`(*client*, *deployment\_id*, *light\_status*, *heavy\_status*)

The status of an API Deployer deployment.

Do not create this directly, use `get\_status()`

`get_light`()

Gets the ‘light’ (summary) status. This returns a dictionary with various information about the deployment, but not the actual health of the deployment

* Return type: dict

`get_heavy`()

Gets the ‘heavy’ (full) status. This returns a dictionary with various information about the deployment

* Return type: dict

`get_service_urls`()

Returns service-level URLs for this deployment (ie without the enpdoint-specific suffix)

`get_health`()

Returns the health of this deployment as a string

* Returns: HEALTHY if the deployment is working properly, various other status otherwise

* Return type: string

`get_health_messages`()

Returns messages about the health of this deployment
