# Fleet Manager Virtual Networks[¶](https://doc.dataiku.com/dss/latest/api/python/fleetmanager/virtualnetworks.html#fleet-manager-virtual-networks "Permalink to this headline")

A virtual network allows instances to communicate with each other.

## Create a new virtual network[¶](https://doc.dataiku.com/dss/latest/api/python/fleetmanager/virtualnetworks.html#create-a-new-virtual-network "Permalink to this headline")

§ import dataikuapi

§ key\_id = "<my key id>"

§ key\_secret = "<my key secret>"

§ # <Cloud vendor> is either AWS, Azure or GCP

§ client = dataikuapi.FMClient<Cloud vendor>("https://localhost", key\_id, key\_secret)

§ creator = client.new\_virtual\_network\_creator("MyNetwork")

§ # set the properties of your network

§ ...

§ network = creator.create()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/api/python/fleetmanager/virtualnetworks.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.fm.virtualnetworks.``FMVirtualNetwork`(*client*, *vn\_data*)

`save`()

Update this virtual network.

`delete`()

Delete this virtual network.

* Returns: the Future object representing the deletion process

* Return type: `dataikuapi.fm.future.FMFuture`

`set_fleet_management`(*enable*, *event\_server=None*, *deployer\_management='NO\_MANAGED\_DEPLOYER'*, *govern\_server=None*)

When enabled, all instances in this virtual network know each other and can centrally manage deployer and logs centralization

* Parameters: * **enable** (*boolean*) – Enable or not the Fleet Management
* **event\_server** (*str*) – Optional, Node name of the node that should act as the centralized event server for logs concentration. Audit logs of all design, deployer and automation nodes will automatically be sent there.
* **deployer\_management** (*str*) – Optional, Accepts:
- “NO\_MANAGED\_DEPLOYER”: Do not manage the deployer. This is the default mode.
- “CENTRAL\_DEPLOYER”: Central deployer. Recommended if you have more than one design node or may have more than one design node in the future.
- “EACH\_DESIGN\_NODE”: Deployer from design. Recommended if you have a single design node and want a simpler setup.
* **govern\_server** (*str*) – Optional, node name of the node that should act as the centralized Govern server.

`set_https_strategy`(*https\_strategy*)

Set the HTTPS strategy for this virtual network

* Parameters: **https\_strategy** (`dataikuapi.fm.virtualnetworks.FMHTTPSStrategy`) – the strategy to set

*class* `dataikuapi.fm.virtualnetworks.``FMVirtualNetworkCreator`(*client*, *label*)

`with_internet_access_mode`(*internet\_access\_mode*)

Set the Internet access mode

* Parameters: **internet\_access\_mode** (*str*) – The internet access mode of the instances created in this virtual network.
Accepts “YES”, “NO”, “EGRESS\_ONLY”.
Defaults to “YES”

`with_default_values`()

Set the VPC and Subnet to their default values: the vpc and subnet of the FM instance

*class* `dataikuapi.fm.virtualnetworks.``FMAWSVirtualNetwork`(*client*, *vn\_data*)

`set_dns_strategy`(*assign\_domain\_name*, *aws\_private\_ip\_zone53\_id=None*, *aws\_public\_ip\_zone53\_id=None*)

Set the DNS strategy for this virtual network

* Parameters: * **assign\_domain\_name** (*boolean*) – If false, don’t assign domain names, use ip\_only
* **aws\_private\_ip\_zone53\_id** (*str*) – Optional, AWS Only, the ID of the AWS Route53 Zone to use for private ip
* **aws\_public\_ip\_zone53\_id** (*str*) – Optional, AWS Only, the ID of the AWS Route53 Zone to use for public ip

*class* `dataikuapi.fm.virtualnetworks.``FMAWSVirtualNetworkCreator`(*client*, *label*)

`with_vpc`(*aws\_vpc\_id*, *aws\_subnet\_id*)

Setup the VPC and Subnet to be used by the virtual network

* Parameters: * **aws\_vpc\_id** (*str*) – ID of the VPC to use
* **aws\_subnet\_id** (*str*) – ID of the subnet to use

`with_auto_create_security_groups`()

Automatically create the AWS Security Groups when creating this virtual network

`with_aws_security_groups`(*\*aws\_security\_groups*)

Use pre-created AWS Security Groups

* Parameters: **aws\_security\_groups** (*str*) – Up to 5 security group ids to assign to the instances created in this virtual network

`create`()

Create a new virtual network

* Returns: a newly created network

* Return type: `dataikuapi.fm.virtualnetworks.FMAWSVirtualNetwork`

*class* `dataikuapi.fm.virtualnetworks.``FMAzureVirtualNetwork`(*client*, *vn\_data*)

`set_dns_strategy`(*assign\_domain\_name*, *azure\_dns\_zone\_id=None*)

Set the DNS strategy for this virtual network

* Parameters: * **assign\_domain\_name** (*boolean*) – If false, don’t assign domain names, use ip\_only
* **azure\_dns\_zone\_id** (*str*) – Optional, Azure Only, the ID of the Azure DNS zone to use

*class* `dataikuapi.fm.virtualnetworks.``FMAzureVirtualNetworkCreator`(*client*, *label*)

`with_azure_virtual_network`(*azure\_vn\_id*, *azure\_subnet\_id*)

Setup the Azure Virtual Network and Subnet to be used by the virtual network

* Parameters: * **azure\_vn\_id** (*str*) – Resource ID of the Azure Virtual Network to use
* **azure\_subnet\_id** (*str*) – Resource ID of the subnet to use

`with_auto_update_security_groups`(*auto\_update\_security\_groups=True*)

Auto update the security groups of the Azure Virtual Network

* Parameters: **auto\_update\_security\_groups** (*boolean*) – Optional, Auto update the subnet security group. Defaults to True

`create`()

Create a new virtual network

* Returns: a newly created network

* Return type: `dataikuapi.fm.virtualnetworks.FMAzureVirtualNetwork`

*class* `dataikuapi.fm.virtualnetworks.``FMGCPVirtualNetwork`(*client*, *vn\_data*)

`set_assign_public_ip`(*public\_ip=True*)

Sets whether the instances on this network will have a publicly accessible IP

* Parameters: **public\_ip** (*bool*) – if False, the instances will not be accessible from outside GCP

`set_location_for_created_resources`(*project\_id=None*, *zone=None*)

Set the location in GCP of the instances created using this virtual network

* Parameters: * **project\_id** (*str*) – Optional, the project in which instances should be created. If empty string, then the project 
of the FM instance is used
* **zone** (*str*) – Optional, the zone in which instances should be created. If empty string, then the zone 
of the FM instance is used

`set_dns_strategy`(*assign\_domain\_name*, *private\_ip\_zone\_id=None*, *public\_ip\_zone\_id=None*)

Set the DNS strategy for this virtual network

* Parameters: * **assign\_domain\_name** (*boolean*) – If false, don’t assign domain names, use ip\_only
* **private\_ip\_zone\_id** (*str*) – Optional, the ID of the Cloud DNS Zone to use for private ip
* **public\_ip\_zone\_id** (*str*) – Optional, the ID of the Cloud DNS Zone to use for public ip

*class* `dataikuapi.fm.virtualnetworks.``FMGCPVirtualNetworkCreator`(*client*, *label*)

`with_vpc`(*project\_id*, *network*, *subnetwork*)

Setup the VPC which the virtual network will use

* Parameters: * **project\_id** (*str*) – ID of the project in which the network is defined
* **network** (*str*) – name of the network
* **subnetwork** (*str*) – name of the subnetwork

`with_network_tags`(*\*network\_tags*)

Use network tags on the instances created in the virtual network

* Parameters: **network\_tags** (*str*) – network tags to assign to the instances created in this virtual network.

`create`()

Create the virtual network

* Returns: a newly created network

* Return type: `dataikuapi.fm.virtualnetworks.FMGCPVirtualNetwork`

*class* `dataikuapi.fm.virtualnetworks.``FMHTTPSStrategy`(*data*, *https\_strategy*, *http\_redirect=False*)

*static* `disable`()

Use HTTP only

*static* `self_signed`(*http\_redirect*)

Use self-signed certificates

* Parameters: **http\_redirect** (*bool*) – If true, HTTP is redirected to HTTPS. If false, HTTP is disabled. Defaults to false

*static* `custom_cert`(*http\_redirect*)

Use a custom certificate for each instance

* Parameters: **http\_redirect** (*bool*) – If true, HTTP is redirected to HTTPS. If false, HTTP is disabled. Defaults to false

*static* `lets_encrypt`(*contact\_mail*)

Use Let’s Encrypt to generate https certificates

* Parameters: **contact\_mail** (*str*) – The contact email provided to Let’s Encrypt
