# Authentication information and impersonation[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-authinfo.html#authentication-information-and-impersonation "Permalink to this headline")

## Introduction[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-authinfo.html#introduction "Permalink to this headline")

From any Python code, it is possible to retrieve information about the user or API key currently running this code.

This can be used:

* From code running outside of Dataiku Govern, simply to retrieve details of the current API key

Furthermore, the API provides the ability, from a set of HTTP headers, to identify the user represented by these headers.

## Code samples[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-authinfo.html#code-samples "Permalink to this headline")

### Getting your own login information[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-authinfo.html#getting-your-own-login-information "Permalink to this headline")

§ auth\_info = client.get\_auth\_info()

§ # auth\_info is a dict which contains at least a "authIdentifier" field, which is the login for a user

§ print("User running this code is %s" % auth\_info["authIdentifier"])

### Impersonating another user[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-authinfo.html#impersonating-another-user "Permalink to this headline")

As a Dataiku Govern administrator, it can be useful to be able to perform API calls on behalf of another user.

§ user = client.get\_user("the\_user\_to\_impersonate")

§ client\_as\_user = user.get\_client\_as()

§ # All calls done using `client\_as\_user` will appear as being performed by `the\_user\_to\_impersonate` and will inherit

§ # its permissions

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-authinfo.html#reference-documentation "Permalink to this headline")

`GovernClient.``get_auth_info`()

Returns various information about the user currently authenticated using this instance of the API client.

This method returns a dict that may contain the following keys (may also contain others):

* authIdentifier: login for a user, id for an API key

* groups: list of group names (if context is a user)

* Returns: a dict

* Return type: dict
