# Project folders[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#project-folders "Permalink to this headline")

You can interact with project folders through the API.

* Basic operations

* Navigating within project folders

* Finding the folder of a project

* Creating entities

* Moving entities

* Managing project folders

+ Deleting a project folder

+ Modifying settings

* Reference documentation

## Basic operations[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#basic-operations "Permalink to this headline")

The ROOT project folder can be retrieved with the get\_root\_project\_folder method.

§ root\_folder = client.get\_root\_project\_folder()

Alternatively any project folder can be retrieved with its ID with the get\_project\_folder method.

§ prj\_folder = client.get\_project\_folder(prj\_folder\_id)

Getting basic attributes:

§ # Getting the id of a project folder (for "get\_project\_folder")

§ id = prj\_folder.id

§ # Getting the name of a project folder:

§ name = prj\_folder.name

§ # Getting the "virtual path" of a project folder (NB: for information purpose only, does not hold special significance)

§ path = prj\_folder.get\_path()

## Navigating within project folders[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#navigating-within-project-folders "Permalink to this headline")

In order to navigate from a project folder, its parent and children can be retrieved.

§ parent = prj\_folder.get\_parent()

§ children = prj\_folder.list\_child\_folders()

This will list all its projects.

§ project\_key\_list = prj\_folder.list\_project\_keys()

§ project\_list = prj\_folder.list\_projects()

## Finding the folder of a project[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#finding-the-folder-of-a-project "Permalink to this headline")

From a project, you can find its project folder

§ project = client.get\_project("MYPROJECT")

§ folder = project.get\_project\_folder()

§ print("Project is in folder %s (path %s)" % (folder.name, folder.get\_path()))

## Creating entities[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#creating-entities "Permalink to this headline")

To create a child project folder, use the create\_sub\_folder method.

§ # Creating a new project folder

§ newborn\_child = prj\_folder.create\_sub\_folder(project\_folder\_name)

§ # Creating a project directly into a project folder

§ new\_project = prj\_folder.create\_project(project\_key, project\_name, owner)

## Moving entities[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#moving-entities "Permalink to this headline")

To move a project folder to another location (into another project folder), use the move\_to method.

§ prj\_folder.move\_to(new\_parent)

§ prj\_folder.move\_project\_to(project\_key, new\_parent)

You can also move a project directly

§ project.move\_to\_folder(target\_folder)

## Managing project folders[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#managing-project-folders "Permalink to this headline")

### Deleting a project folder[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#deleting-a-project-folder "Permalink to this headline")

§ prj\_folder.delete()

### Modifying settings[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#modifying-settings "Permalink to this headline")

§ pf\_settings = prj\_folder.get\_settings()

§ pf\_settings.set\_name(new\_name)

§ pf\_settings.set\_owner(new\_owner)

§ pf\_permissions = pf\_settings.get\_permissions()

§ pf\_permissions.append(new\_permission\_item)

§ pf\_settings.save()

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/api/python/project-folders.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.projectfolder.``DSSProjectFolder`(*client*, *data*)

A handle to interact with a project folder on the DSS instance.

Do not create this class directly, instead use `dataikuapi.DSSClient.get\_project\_folder()` or `dataikuapi.DSSClient.get\_root\_project\_folder()`

*property* `id`

Get this project folder’s id :returns str: the id of this project folder

*property* `project_folder_id`

deprecated, use id instead

*property* `name`

Get this project folder’s name or None if it is the root project folder :returns str: the name of this project folders or None for the root project folder

`get_name`()

See name

`get_path`()

Get this project folder’s path from the orot, in the form of /name/name/name :return str: the path of this project folder

`get_parent`()

Get this project folder’s parent or None if it is the root project folder

* Returns: A `dataikuapi.dss.projectfolders.DSSProjectFolder` to interact with its parent or None for the root project folder

`list_child_folders`()

List the child project folders inside this project folder :returns list: A list of `dataikuapi.dss.projectfolders.DSSProjectFolder` to interact with its sub-folders

`list_project_keys`()

List the project keys of the projects that are stored in this project folder :returns list: A list of project keys

`list_projects`()

List the projects that are stored in this project folder :returns list: A list of `dataikuapi.dss.project.DSSProject` to interact with its projects

`delete`()

Delete the project folder Note: it must be empty (cannot contain any sub-project folders or projects), you must move or remove all its content before deleting it

This call requires an API key with admin rights

`get_settings`()

* Returns: A `dataikuapi.dss.projectfolder.DSSProjectFolderSettings` to interact with this project folder settings

`create_sub_folder`(*name*)

Create a sub-folder into the current project folder

* Parameters: **name** (*str*) – the name of the project folder to create

* Returns: A `dataikuapi.dss.projectfolder.DSSProjectFolder` to interact with the newly created project folder

`create_project`(*project\_key*, *name*, *owner*, *description=None*, *settings=None*)

Creates a new project within this project folder, and return a project handle to interact with it.

Note: this call requires an API key with admin rights or the rights to create a project

* Parameters: * **project\_key** (*str*) – the identifier to use for the project. Must be globally unique
* **name** (*str*) – the display name for the project.
* **owner** (*str*) – the login of the owner of the project.
* **description** (*str*) – a description for the project.
* **settings** (*dict*) – Initial settings for the project (can be modified later). The exact possible settings are not documented.

* Returns: A class:dataikuapi.dss.project.DSSProject project handle to interact with this project

`move_to`(*destination*)

Move this project folder into another project folder (aka. destination)

* Parameters: **destination** (A `dataikuapi.dss.projectfolders.DSSProjectFolder`) – the project folder to put this project folder into

`move_project_to`(*project\_key*, *destination*)

Move a project within this project folder into another project folder (aka. destination)

* Parameters: * **project\_key** (*str*) – the project key associated with the project to move
* **destination** (A `dataikuapi.dss.projectfolders.DSSProjectFolder`) – the project folder to put this project into

*class* `dataikuapi.dss.projectfolder.``DSSProjectFolderSettings`(*client*, *project\_folder\_id*, *settings*)

A handle to interact with project folder settings

Do not create this class directly, instead use `dataikuapi.dss.projectfolder.DSSProjectFolder.get\_settings()`

`get_raw`()

Gets all settings as a raw dictionary. This returns a reference to the raw retrieved settings, not a copy, so changes made to the returned object will be reflected when saving.

* Return type: dict

`get_name`()

Get the name of the project folder

* Returns str: the current name of the project folder

`set_name`(*name*)

Set the name of the project folder

* Parameters: **name** (*str*) – the new name of the project folder

`get_owner`()

Get the login of the owner of the project folder

* Returns str: the current login owner of the project folder

`set_owner`(*owner*)

Set the owner of the project folder

* Parameters: **owner** (*str*) – the new owner login of the project folder

`get_permissions`()

Get the permissions of the project folder. This returns a reference to the retrieved permissions, not a copy, so changes made to the returned list will be reflected when saving.

* Return list: the current permissions of the project folder

`save`()

Saves back the settings to the project folder
