# Projects[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#projects "Permalink to this headline")

* Basic operations

* Creating, listing and getting handles to project items

* Modifying project settings

* Deleting

* Exporting

* Importing

* Duplicating

* Reference documentation

+ dataikuapi package API

+ dataiku package API

## Basic operations[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#basic-operations "Permalink to this headline")

The list of projects in the DSS instance can be retrieved with the list\_project\_keys method.

§ client = DSSClient(host, apiKey)

§ dss\_projects = client.list\_project\_keys()

§ print(dss\_projects)

outputs

§ ['IMPALA', 'MYSQL', 'PARTITIONED', 'PLUGINS']

Projects can be created:

§ new\_project = client.create\_project('TEST\_PROJECT', 'test project', 'tester', description='a simple description')

§ print(client.list\_project\_keys()

outputs

§ ['IMPALA', 'MYSQL', 'PARTITIONED', 'PLUGINS', 'TEST\_PROJECT']

Or an existing project can be used for later manipulation:

§ project = client.get\_project(ProjectKey)

## Creating, listing and getting handles to project items[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#creating-listing-and-getting-handles-to-project-items "Permalink to this headline")

Through various method on the `DSSProject` class, you can:

* Create most types of project items (datasets, recipes, managed folders, …)

* List project items

* Get structured handles to interact with each type of project item

## Modifying project settings[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#modifying-project-settings "Permalink to this headline")

Two parts of the project’s settings can be modified directly: the metadata and the permissions. In both cases, it is advised to first retrieve the current settings state with the get\_metadata and get\_permissions call, modify the returned object, and then set it back on the DSS instance.

§ project = client.get\_project(ProjectKey)

§ project\_metadata = project.get\_metadata()

§ project\_metadata['tags'] = ['tag1','tag2']

§ project.set\_metadata(project\_metadata)

§ project\_permissions = project.get\_permissions()

§ project\_permissions['permissions'].append({'group':'data\_scientists','readProjectContent': True, 'readDashboards': True})

§ project.set\_permissions(project\_permissions)

Available permissions to be set:

§ {

§ 'group': u'data\_team',

§ 'admin': False,

§ 'exportDatasetsData': True,

§ 'manageAdditionalDashboardUsers': False,

§ 'manageDashboardAuthorizations': False,

§ 'manageExposedElements': False,

§ 'moderateDashboards': False,

§ 'readDashboards': True,

§ 'readProjectContent': True,

§ 'runScenarios': False,

§ 'writeDashboards': False,

§ 'writeProjectContent': False,

§ 'shareToWorkspaces': False

§ }

## Deleting[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#deleting "Permalink to this headline")

Projects can also be deleted:

§ project = client.get\_project('TEST\_PROJECT')

§ project.delete()

## Exporting[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#exporting "Permalink to this headline")

Project export is available through the python API in two forms: either as a stream, or exported directly to a file. The data is sent zipped.

§ project = client.get\_project('TEST\_PROJECT')

§ project.export\_to\_file('exported\_project.zip')

§ with project.get\_export\_stream() as s:

§ ...

## Importing[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#importing "Permalink to this headline")

Project can be imported directly from a zip file:

§ with open("myproject.zip", "rb") as f:

§ client.prepare\_project\_import(f).execute()

## Duplicating[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#duplicating "Permalink to this headline")

Projects can be duplicated:

§ project = client.get\_project('TEST\_PROJECT')

§ project.duplicate('COPY\_TEST\_PROJECT', 'Copy of the Test Project')

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#reference-documentation "Permalink to this headline")

### dataikuapi package API[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#dataikuapi-package-api "Permalink to this headline")

*class* `dataikuapi.dss.project.``DSSProject`(*client*, *project\_key*)

A handle to interact with a project on the DSS instance.

Important

Do not create this class directly, instead use `dataikuapi.DSSClient.get\_project()`

`get_summary`()

Returns a summary of the project. The summary is a read-only view of some of the state of the project. You cannot edit the resulting dict and use it to update the project state on DSS, you must use the other more specific methods of this `dataikuapi.dss.project.DSSProject` object

* Returns: a dict containing a summary of the project. Each dict contains at least a **projectKey** field

* Return type: dict

`get_project_folder`()

Get the folder containing this project

* Return type: `dataikuapi.dss.projectfolder.DSSProjectFolder`

`move_to_folder`(*folder*)

Moves this project to a project folder

* Parameters: **folder** (`dataikuapi.dss.projectfolder.DSSProjectFolder`) – destination folder

`delete`(*clear\_managed\_datasets=False*, *clear\_output\_managed\_folders=False*, *clear\_job\_and\_scenario\_logs=True*, *\*\*kwargs*)

Delete the project

Attention

This call requires an API key with admin rights

* Parameters: * **clear\_managed\_datasets** (*bool*) – Should the data of managed datasets be cleared (defaults to **False**)
* **clear\_output\_managed\_folders** (*bool*) – Should the data of managed folders used as outputs of recipes be cleared (defaults to **False**)
* **clear\_job\_and\_scenario\_logs** (*bool*) – Should the job and scenario logs be cleared (defaults to **True**)

`get_export_stream`(*options=None*)

Return a stream of the exported project

Warning

You need to close the stream after download. Failure to do so will result in the DSSClient becoming unusable.

* Parameters: **options** (*dict*) – Dictionary of export options (defaults to **{}**).
The following options are available:
> 
> * **exportUploads** (boolean): Exports the data of Uploaded datasets (default to **False**)
> * **exportManagedFS** (boolean): Exports the data of managed Filesystem datasets (default to **False**)
> * **exportAnalysisModels** (boolean): Exports the models trained in analysis (default to **False**)
> * **exportSavedModels** (boolean): Exports the models trained in saved models (default to **False**)
> * **exportManagedFolders** (boolean): Exports the data of managed folders (default to **False**)
> * **exportAllInputDatasets** (boolean): Exports the data of all input datasets (default to **False**)
> * **exportAllDatasets** (boolean): Exports the data of all datasets (default to **False**)
> * **exportAllInputManagedFolders** (boolean): Exports the data of all input managed folders (default to **False**)
> * **exportGitRepository** (boolean): Exports the Git repository history (default to **False**)
> * **exportInsightsData** (boolean): Exports the data of static insights (default to **False**)
> 
> 
>

* Returns: a stream of the export archive

* Return type: file-like object

`export_to_file`(*path*, *options=None*)

Export the project to a file

* Parameters: * **path** (*str*) – the path of the file in which the exported project should be saved
* **options** (*dict*) – Dictionary of export options (defaults to **{}**).
The following options are available:
> 
> 
> 	+ **exportUploads** (boolean): Exports the data of Uploaded datasets (default to **False**)
> 	+ **exportManagedFS** (boolean): Exports the data of managed Filesystem datasets (default to **False**)
> 	+ **exportAnalysisModels** (boolean): Exports the models trained in analysis (default to **False**)
> 	+ **exportSavedModels** (boolean): Exports the models trained in saved models (default to **False**)
> 	+ **exportModelEvaluationStores** (boolean): Exports the evaluation stores (default to **False**)
> 	+ **exportManagedFolders** (boolean): Exports the data of managed folders (default to **False**)
> 	+ **exportAllInputDatasets** (boolean): Exports the data of all input datasets (default to **False**)
> 	+ **exportAllDatasets** (boolean): Exports the data of all datasets (default to **False**)
> 	+ **exportAllInputManagedFolders** (boolean): Exports the data of all input managed folders (default to **False**)
> 	+ **exportGitRepository** (boolean): Exports the Git repository history (default to **False**)
> 	+ **exportInsightsData** (boolean): Exports the data of static insights (default to **False**)
>

`duplicate`(*target\_project\_key*, *target\_project\_name*, *duplication\_mode='MINIMAL'*, *export\_analysis\_models=True*, *export\_saved\_models=True*, *export\_git\_repository=True*, *export\_insights\_data=True*, *remapping=None*, *target\_project\_folder=None*)

Duplicate the project

* Parameters: * **target\_project\_key** (*str*) – The key of the new project
* **target\_project\_name** (*str*) – The name of the new project
* **duplication\_mode** (*str*) – can be one of the following values: MINIMAL, SHARING, FULL, NONE (defaults to **MINIMAL**)
* **export\_analysis\_models** (*bool*) – (defaults to **True**)
* **export\_saved\_models** (*bool*) – (defaults to **True**)
* **export\_git\_repository** (*bool*) – (defaults to **True**)
* **export\_insights\_data** (*bool*) – (defaults to **True**)
* **remapping** (*dict*) – dict of connections to be remapped for the new project (defaults to **{}**)
* **target\_project\_folder** (A `dataikuapi.dss.projectfolder.DSSProjectFolder`) – the project folder where to put the duplicated project (defaults to **None**)

* Returns: A dict containing the original and duplicated project’s keys

* Return type: dict

`get_metadata`()

Get the metadata attached to this project. The metadata contains label, description checklists, tags and custom metadata of the project.

Note

For more information on available metadata, please see https://doc.dataiku.com/dss/api/6.0/rest/

* Returns: the project metadata.

* Return type: dict

`set_metadata`(*metadata*)

Set the metadata on this project.

Usage example:

§ project\_metadata = project.get\_metadata()

§ project\_metadata['tags'] = ['tag1','tag2']

§ project.set\_metadata(project\_metadata)

* Parameters: **metadata** (*dict*) – the new state of the metadata for the project. You should only set a metadata object that has been retrieved using the `get\_metadata()` call.

`get_settings`()

Gets the settings of this project. This does not contain permissions. See `get\_permissions()`

* Returns: a handle to read, modify and save the settings

* Return type: `dataikuapi.dss.project.DSSProjectSettings`

`get_permissions`()

Get the permissions attached to this project

* Returns: A dict containing the owner and the permissions, as a list of pairs of group name and permission type

* Return type: dict

`set_permissions`(*permissions*)

Sets the permissions on this project

Usage example:

§ project\_permissions = project.get\_permissions()

§ project\_permissions['permissions'].append({'group':'data\_scientists',

§ 'readProjectContent': True,

§ 'readDashboards': True})

§ project.set\_permissions(project\_permissions)

* Parameters: **permissions** (*dict*) – a permissions object with the same structure as the one returned by `get\_permissions()` call

`get_interest`()

Get the interest of this project. The interest means the number of watchers and the number of stars.

* Returns: a dict object containing the interest of the project with two fields:
* **starCount**: number of stars for this project
* **watchCount**: number of users watching this project

* Return type: dict

`get_timeline`(*item\_count=100*)

Get the timeline of this project. The timeline consists of information about the creation of this project (by whom, and when), the last modification of this project (by whom and when), a list of contributors, and a list of modifications. This list of modifications contains a maximum of **item\_count** elements (default to 100). If **item\_count** is greater than the real number of modification, **item\_count** is adjusted.

* Parameters: **item\_count** (*int*) – maximum number of modifications to retrieve in the items list

* Returns: a timeline where the top-level fields are :
* **allContributors**: all contributors who have been involved in this project
* **items**: a history of the modifications of the project
* **createdBy**: who created this project
* **createdOn**: when the project was created
* **lastModifiedBy**: who modified this project for the last time
* **lastModifiedOn**: when this modification took place

* Return type: dict

`list_datasets`(*as\_type='listitems'*)

List the datasets in this project.

* Parameters: **as\_type** (*str*) – How to return the list. Supported values are “listitems” and “objects” (defaults to **listitems**).

* Returns: The list of the datasets. If “as\_type” is “listitems”,
each one as a `dataikuapi.dss.dataset.DSSDatasetListItem`. If “as\_type” is “objects”,
each one as a `dataikuapi.dss.dataset.DSSDataset`

* Return type: list

`get_dataset`(*dataset\_name*)

Get a handle to interact with a specific dataset

* Parameters: **dataset\_name** (*str*) – the name of the desired dataset

* Returns: A dataset handle

* Return type: `dataikuapi.dss.dataset.DSSDataset`

`create_dataset`(*dataset\_name*, *type*, *params=None*, *formatType=None*, *formatParams=None*)

Create a new dataset in the project, and return a handle to interact with it.

The precise structure of **params** and **formatParams** depends on the specific dataset type and dataset format type. To know which fields exist for a given dataset type and format type, create a dataset from the UI, and use `get\_dataset()` to retrieve the configuration of the dataset and inspect it. Then reproduce a similar structure in the `create\_dataset()` call.

Not all settings of a dataset can be set at creation time (for example partitioning). After creation, you’ll have the ability to modify the dataset

* Parameters: * **dataset\_name** (*str*) – the name of the dataset to create. Must not already exist
* **type** (*str*) – the type of the dataset
* **params** (*dict*) – the parameters for the type, as a python dict (defaults to **{}**)
* **formatType** (*str*) – an optional format to create the dataset with (only for file-oriented datasets)
* **formatParams** (*dict*) – the parameters to the format, as a python dict (only for file-oriented datasets, default to **{}**)

* Returns: A dataset handle

* Return type: `dataikuapi.dss.dataset.DSSDataset`

`create_upload_dataset`(*dataset\_name*, *connection=None*)

Create a new dataset of type ‘UploadedFiles’ in the project, and return a handle to interact with it.

* Parameters: * **dataset\_name** (*str*) – the name of the dataset to create. Must not already exist
* **connection** (*str*) – the name of the upload connection (defaults to **None**)

* Returns: A dataset handle

* Return type: `dataikuapi.dss.dataset.DSSDataset`

`create_filesystem_dataset`(*dataset\_name*, *connection*, *path\_in\_connection*)

Create a new filesystem dataset in the project, and return a handle to interact with it.

* Parameters: * **dataset\_name** (*str*) – the name of the dataset to create. Must not already exist
* **connection** (*str*) – the name of the connection
* **path\_in\_connection** (*str*) – the path of the dataset in the connection

* Returns: A dataset handle

* Return type: `dataikuapi.dss.dataset.DSSDataset`

`create_s3_dataset`(*dataset\_name*, *connection*, *path\_in\_connection*, *bucket=None*)

Creates a new external S3 dataset in the project and returns a `dataikuapi.dss.dataset.DSSDataset` to interact with it.

The created dataset does not have its format and schema initialized, it is recommended to use `autodetect\_settings()` on the returned object

* Parameters: * **dataset\_name** (*str*) – the name of the dataset to create. Must not already exist
* **connection** (*str*) – the name of the connection
* **path\_in\_connection** (*str*) – the path of the dataset in the connection
* **bucket** (*str*) – the name of the s3 bucket (defaults to **None**)

* Returns: A dataset handle

* Return type: `dataikuapi.dss.dataset.DSSDataset`

`create_fslike_dataset`(*dataset\_name*, *dataset\_type*, *connection*, *path\_in\_connection*, *extra\_params=None*)

Create a new file-based dataset in the project, and return a handle to interact with it.

* Parameters: * **dataset\_name** (*str*) – the name of the dataset to create. Must not already exist
* **dataset\_type** (*str*) – the type of the dataset
* **connection** (*str*) – the name of the connection
* **path\_in\_connection** (*str*) – the path of the dataset in the connection
* **extra\_params** (*dict*) – a python dict of extra parameters (defaults to **None**)

* Returns: A dataset handle

* Return type: `dataikuapi.dss.dataset.DSSDataset`

`create_sql_table_dataset`(*dataset\_name*, *type*, *connection*, *table*, *schema*)

Create a new SQL table dataset in the project, and return a handle to interact with it.

* Parameters: * **dataset\_name** (*str*) – the name of the dataset to create. Must not already exist
* **type** (*str*) – the type of the dataset
* **connection** (*str*) – the name of the connection
* **table** (*str*) – the name of the table in the connection
* **schema** (*str*) – the schema of the table

* Returns: A dataset handle

* Return type: `dataikuapi.dss.dataset.DSSDataset`

`new_managed_dataset_creation_helper`(*dataset\_name*)

Caution

Deprecated. Please use `new\_managed\_dataset()`

`new_managed_dataset`(*dataset\_name*)

Initializes the creation of a new managed dataset. Returns a `dataikuapi.dss.dataset.DSSManagedDatasetCreationHelper` or one of its subclasses to complete the creation of the managed dataset.

Usage example:

§ builder = project.new\_managed\_dataset("my\_dataset")

§ builder.with\_store\_into("target\_connection")

§ dataset = builder.create()

* Parameters: **dataset\_name** (*str*) – Name of the dataset to create

* Returns: An object to create the managed dataset

* Return type: `dataikuapi.dss.dataset.DSSManagedDatasetCreationHelper`

`list_streaming_endpoints`(*as\_type='listitems'*)

List the streaming endpoints in this project.

* Parameters: **as\_type** (*str*) – How to return the list. Supported values are “listitems” and “objects”
(defaults to **listitems**).

* Returns: The list of the streaming endpoints. If “as\_type” is “listitems”, each one as a
`dataikuapi.dss.streaming\_endpoint.DSSStreamingEndpointListItem`. If “as\_type” is “objects”,
each one as a `dataikuapi.dss.streaming\_endpoint.DSSStreamingEndpoint`

* Return type: list

`get_streaming_endpoint`(*streaming\_endpoint\_name*)

Get a handle to interact with a specific streaming endpoint

* Parameters: **streaming\_endpoint\_name** (*str*) – the name of the desired streaming endpoint

* Returns: A streaming endpoint handle

* Return type: `dataikuapi.dss.streaming\_endpoint.DSSStreamingEndpoint`

`create_streaming_endpoint`(*streaming\_endpoint\_name*, *type*, *params=None*)

Create a new streaming endpoint in the project, and return a handle to interact with it.

The precise structure of **params** depends on the specific streaming endpoint type. To know which fields exist for a given streaming endpoint type, create a streaming endpoint from the UI, and use `get\_streaming\_endpoint()` to retrieve the configuration of the streaming endpoint and inspect it. Then reproduce a similar structure in the `create\_streaming\_endpoint()` call.

Not all settings of a streaming endpoint can be set at creation time (for example partitioning). After creation, you’ll have the ability to modify the streaming endpoint.

* Parameters: * **streaming\_endpoint\_name** (*str*) – the name for the new streaming endpoint
* **type** (*str*) – the type of the streaming endpoint
* **params** (*dict*) – the parameters for the type, as a python dict (defaults to **{}**)

* Returns: A streaming endpoint handle

* Return type: `dataikuapi.dss.streaming\_endpoint.DSSStreamingEndpoint`

`create_kafka_streaming_endpoint`(*streaming\_endpoint\_name*, *connection=None*, *topic=None*)

Create a new kafka streaming endpoint in the project, and return a handle to interact with it.

* Parameters: * **streaming\_endpoint\_name** (*str*) – the name for the new streaming endpoint
* **connection** (*str*) – the name of the kafka connection (defaults to **None**)
* **topic** (*str*) – the name of the kafka topic (defaults to **None**)

* Returns: A streaming endpoint handle

* Return type: `dataikuapi.dss.streaming\_endpoint.DSSStreamingEndpoint`

`create_httpsse_streaming_endpoint`(*streaming\_endpoint\_name*, *url=None*)

Create a new https streaming endpoint in the project, and return a handle to interact with it.

* Parameters: * **streaming\_endpoint\_name** (*str*) – the name for the new streaming endpoint
* **url** (*str*) – the url of the endpoint (defaults to **None**)

* Returns: A streaming endpoint handle

* Return type: `dataikuapi.dss.streaming\_endpoint.DSSStreamingEndpoint`

`new_managed_streaming_endpoint`(*streaming\_endpoint\_name*, *streaming\_endpoint\_type=None*)

Initializes the creation of a new streaming endpoint. Returns a `dataikuapi.dss.streaming\_endpoint.DSSManagedStreamingEndpointCreationHelper` to complete the creation of the streaming endpoint

* Parameters: * **streaming\_endpoint\_name** (*str*) – Name of the new streaming endpoint - must be unique in the project
* **streaming\_endpoint\_type** (*str*) – Type of the new streaming endpoint (optional if it can be inferred from a
connection type)

* Returns: An object to create the streaming endpoint

* Return type: `DSSManagedStreamingEndpointCreationHelper`

`create_prediction_ml_task`(*input\_dataset*, *target\_variable*, *ml\_backend\_type='PY\_MEMORY'*, *guess\_policy='DEFAULT'*, *prediction\_type=None*, *wait\_guess\_complete=True*)

Creates a new prediction task in a new visual analysis lab for a dataset.

* Parameters: * **input\_dataset** (*str*) – the dataset to use for training/testing the model
* **target\_variable** (*str*) – the variable to predict
* **ml\_backend\_type** (*str*) – ML backend to use, one of PY\_MEMORY, MLLIB or H2O (defaults to **PY\_MEMORY**)
* **guess\_policy** (*str*) – Policy to use for setting the default parameters. Valid values are: DEFAULT,
SIMPLE\_FORMULA, DECISION\_TREE, EXPLANATORY and PERFORMANCE (defaults to **DEFAULT**)
* **prediction\_type** (*str*) – The type of prediction problem this is. If not provided the prediction type will be
guessed. Valid values are: BINARY\_CLASSIFICATION, REGRESSION, MULTICLASS (defaults to **None**)
* **wait\_guess\_complete** (*boolean*) – if False, the returned ML task will be in ‘guessing’ state, i.e. analyzing
the input dataset to determine feature handling and algorithms (defaults to **True**). You should wait for
the guessing to be completed by calling **wait\_guess\_complete** on the returned object before doing anything
else (in particular calling **train** or **get\_settings**)

* Returns: A ML task handle of type ‘PREDICTION’

* Return type: `dataikuapi.dss.ml.DSSMLTask`

`create_clustering_ml_task`(*input\_dataset*, *ml\_backend\_type='PY\_MEMORY'*, *guess\_policy='KMEANS'*, *wait\_guess\_complete=True*)

Creates a new clustering task in a new visual analysis lab for a dataset.

The returned ML task will be in ‘guessing’ state, i.e. analyzing the input dataset to determine feature handling and algorithms.

You should wait for the guessing to be completed by calling **wait\_guess\_complete** on the returned object before doing anything else (in particular calling **train** or **get\_settings**)

* Parameters: * **ml\_backend\_type** (*str*) – ML backend to use, one of PY\_MEMORY, MLLIB or H2O (defaults to **PY\_MEMORY**)
* **guess\_policy** (*str*) – Policy to use for setting the default parameters. Valid values are: KMEANS and
ANOMALY\_DETECTION (defaults to **KMEANS**)
* **wait\_guess\_complete** (*boolean*) – if False, the returned ML task will be in ‘guessing’ state, i.e. analyzing
the input dataset to determine feature handling and algorithms (defaults to **True**). You should wait for
the guessing to be completed by calling **wait\_guess\_complete** on the returned object before doing anything
else (in particular calling **train** or **get\_settings**)

* Returns: A ML task handle of type ‘CLUSTERING’

* Return type: `dataikuapi.dss.ml.DSSMLTask`

`create_timeseries_forecasting_ml_task`(*input\_dataset*, *target\_variable*, *time\_variable*, *timeseries\_identifiers=None*, *guess\_policy='TIMESERIES\_DEFAULT'*, *wait\_guess\_complete=True*)

Creates a new time series forecasting task in a new visual analysis lab for a dataset.

* Parameters: * **input\_dataset** (*string*) – The dataset to use for training/testing the model
* **target\_variable** (*string*) – The variable to forecast
* **time\_variable** (*string*) – Column to be used as time variable. Should be a Date (parsed) column.
* **timeseries\_identifiers** (*list*) – List of columns to be used as time series identifiers (when the dataset has multiple series)
* **guess\_policy** (*string*) – Policy to use for setting the default parameters.
Valid values are: TIMESERIES\_DEFAULT, TIMESERIES\_STATISTICAL, and TIMESERIES\_DEEP\_LEARNING
* **wait\_guess\_complete** (*boolean*) – If False, the returned ML task will be in ‘guessing’ state, i.e. analyzing the input dataset to determine feature handling and algorithms.
You should wait for the guessing to be completed by calling
`wait\_guess\_complete` on the returned object before doing anything
else (in particular calling `train` or `get\_settings`)

:return :class dataiku.dss.ml.DSSMLTask

`list_ml_tasks`()

List the ML tasks in this project

* Returns: the list of the ML tasks summaries, each one as a python dict

* Return type: list

`get_ml_task`(*analysis\_id*, *mltask\_id*)

Get a handle to interact with a specific ML task

* Parameters: * **analysis\_id** (*str*) – the identifier of the visual analysis containing the desired ML task
* **mltask\_id** (*str*) – the identifier of the desired ML task

* Returns: A ML task handle

* Return type: `dataikuapi.dss.ml.DSSMLTask`

`list_mltask_queues`()

List non-empty ML task queues in this project

* Returns: an iterable listing of MLTask queues (each a dict)

* Return type: `dataikuapi.dss.ml.DSSMLTaskQueues`

`create_analysis`(*input\_dataset*)

Creates a new visual analysis lab for a dataset.

* Parameters: **input\_dataset** (*str*) – the dataset to use for the analysis

* Returns: A visual analysis handle

* Return type: `dataikuapi.dss.analysis.DSSAnalysis`

`list_analyses`()

List the visual analyses in this project

* Returns: the list of the visual analyses summaries, each one as a python dict

* Return type: list

`get_analysis`(*analysis\_id*)

Get a handle to interact with a specific visual analysis

* Parameters: **analysis\_id** (*str*) – the identifier of the desired visual analysis

* Returns: A visual analysis handle

* Return type: `dataikuapi.dss.analysis.DSSAnalysis`

`list_saved_models`()

List the saved models in this project

* Returns: the list of the saved models, each one as a python dict

* Return type: list

`get_saved_model`(*sm\_id*)

Get a handle to interact with a specific saved model

* Parameters: **sm\_id** (*str*) – the identifier of the desired saved model

* Returns: A saved model handle

* Return type: `dataikuapi.dss.savedmodel.DSSSavedModel`

`create_mlflow_pyfunc_model`(*name*, *prediction\_type=None*)

Creates a new external saved model for storing and managing MLFlow models

* Parameters: * **name** (*str*) – Human readable name for the new saved model in the flow
* **prediction\_type** (*str*) – Optional (but needed for most operations). One of BINARY\_CLASSIFICATION, MULTICLASS
or REGRESSION

* Returns: The created saved model handle

* Return type: `dataikuapi.dss.savedmodel.DSSSavedModel`

`create_proxy_model`(*name*, *prediction\_type=None*)

EXPERIMENTAL. Creates a new external saved model that can contain proxy model as versions.

This is an experimental API, subject to change. :param string name: Human readable name for the new saved model in the flow :param string prediction\_type: Optional (but needed for most operations). One of BINARY\_CLASSIFICATION, MULTICLASS or REGRESSION

`list_managed_folders`()

List the managed folders in this project

* Returns: the list of the managed folders, each one as a python dict

* Return type: list

`get_managed_folder`(*odb\_id*)

Get a handle to interact with a specific managed folder

* Parameters: **odb\_id** (*str*) – the identifier of the desired managed folder

* Returns: A managed folder handle

* Return type: `dataikuapi.dss.managedfolder.DSSManagedFolder`

`create_managed_folder`(*name*, *folder\_type=None*, *connection\_name='filesystem\_folders'*)

Create a new managed folder in the project, and return a handle to interact with it

* Parameters: * **name** (*str*) – the name of the managed folder
* **folder\_type** (*str*) – type of storage (defaults to **None**)
* **connection\_name** (*str*) – the connection name (defaults to **filesystem\_folders**)

* Returns: A managed folder handle

* Return type: `dataikuapi.dss.managedfolder.DSSManagedFolder`

`list_model_evaluation_stores`()

List the model evaluation stores in this project.

* Returns: The list of the model evaluation stores

* Return type: list of `dataikuapi.dss.modelevaluationstore.DSSModelEvaluationStore`

`get_model_evaluation_store`(*mes\_id*)

Get a handle to interact with a specific model evaluation store

* Parameters: **mes\_id** (*str*) – the id of the desired model evaluation store

* Returns: A model evaluation store handle

* Return type: `dataikuapi.dss.modelevaluationstore.DSSModelEvaluationStore`

`create_model_evaluation_store`(*name*)

Create a new model evaluation store in the project, and return a handle to interact with it.

* Parameters: **name** (*str*) – the name for the new model evaluation store

* Returns: A model evaluation store handle

* Return type: `dataikuapi.dss.modelevaluationstore.DSSModelEvaluationStore`

`list_model_comparisons`()

List the model comparisons in this project.

* Returns: The list of the model comparisons

* Return type: list

`get_model_comparison`(*mec\_id*)

Get a handle to interact with a specific model comparison

* Parameters: **mec\_id** (*str*) – the id of the desired model comparison

* Returns: A model comparison handle

* Return type: `dataikuapi.dss.modelcomparison.DSSModelComparison`

`create_model_comparison`(*name*, *prediction\_type*)

Create a new model comparison in the project, and return a handle to interact with it.

* Parameters: * **name** (*str*) – the name for the new model comparison
* **prediction\_type** (*str*) – one of BINARY\_CLASSIFICATION, REGRESSION, MULTICLASS, and TIMESERIES\_FORECAST

* Returns: A new model comparison handle

* Return type: `dataikuapi.dss.modelcomparison.DSSModelComparison`

`list_jobs`()

List the jobs in this project

* Returns: a list of the jobs, each one as a python dict, containing both the definition and the state

* Return type: list

`get_job`(*id*)

Get a handler to interact with a specific job

* Parameters: **id** (*str*) – the id of the desired job

* Returns: A job handle

* Return type: `dataikuapi.dss.job.DSSJob`

`start_job`(*definition*)

Create a new job, and return a handle to interact with it

* Parameters: **definition** (*dict*) – The definition should contain:
* the type of job (RECURSIVE\_BUILD, NON\_RECURSIVE\_FORCED\_BUILD, RECURSIVE\_FORCED\_BUILD, RECURSIVE\_MISSING\_ONLY\_BUILD)
* a list of outputs to build from the available types: (DATASET, MANAGED\_FOLDER, SAVED\_MODEL, STREAMING\_ENDPOINT)
* (Optional) a refreshHiveMetastore field (True or False) to specify whether to re-synchronize the Hive metastore for recomputed HDFS datasets.

* Returns: A job handle

* Return type: `dataikuapi.dss.job.DSSJob`

`start_job_and_wait`(*definition*, *no\_fail=False*)

Starts a new job and waits for it to complete.

* Parameters: * **definition** (*dict*) – The definition should contain:
	+ the type of job (RECURSIVE\_BUILD, NON\_RECURSIVE\_FORCED\_BUILD, RECURSIVE\_FORCED\_BUILD, RECURSIVE\_MISSING\_ONLY\_BUILD)
	+ a list of outputs to build from the available types: (DATASET, MANAGED\_FOLDER, SAVED\_MODEL, STREAMING\_ENDPOINT)
	+ (Optional) a refreshHiveMetastore field (True or False) to specify whether to re-synchronize the Hive metastore for recomputed HDFS datasets.
* **no\_fail** (*bool*) – if true, the function won’t fail even if the job fails or aborts (defaults to **False**)

* Returns: the final status of the job

* Return type: str

`new_job`(*job\_type='NON\_RECURSIVE\_FORCED\_BUILD'*)

Create a job to be run. You need to add outputs to the job (i.e. what you want to build) before running it.

§ job\_builder = project.new\_job()

§ job\_builder.with\_output("mydataset")

§ complete\_job = job\_builder.start\_and\_wait()

§ print("Job %s done" % complete\_job.id)

* Parameters: **job\_type** (*str*) – the type of job (RECURSIVE\_BUILD, NON\_RECURSIVE\_FORCED\_BUILD, RECURSIVE\_FORCED\_BUILD,
RECURSIVE\_MISSING\_ONLY\_BUILD) (defaults to NON\_RECURSIVE\_FORCED\_BUILD)

* Returns: A job handle

* Return type: `dataikuapi.dss.project.JobDefinitionBuilder`

`new_job_definition_builder`(*job\_type='NON\_RECURSIVE\_FORCED\_BUILD'*)

Caution

Deprecated. Please use `new\_job()`

`list_jupyter_notebooks`(*active=False*, *as\_type='object'*)

List the jupyter notebooks of a project.

* Parameters: * **active** (*bool*) – if True, only return currently running jupyter notebooks (defaults to **active**).
* **as\_type** (*bool*) – How to return the list. Supported values are “listitems” and “object” (defaults to
**object**).

* Returns: The list of the notebooks. If “as\_type” is “listitems”, each one as a
`dataikuapi.dss.jupyternotebook.DSSJupyterNotebookListItem`, if “as\_type” is “objects”, each one as a
`dataikuapi.dss.jupyternotebook.DSSJupyterNotebook`

* Return type: list of `dataikuapi.dss.jupyternotebook.DSSJupyterNotebook` or list of
`dataikuapi.dss.jupyternotebook.DSSJupyterNotebookListItem`

`get_jupyter_notebook`(*notebook\_name*)

Get a handle to interact with a specific jupyter notebook

* Parameters: **notebook\_name** (*str*) – The name of the jupyter notebook to retrieve

* Returns: A handle to interact with this jupyter notebook

* Return type: `dataikuapi.dss.jupyternotebook.DSSJupyterNotebook` jupyter notebook handle

`create_jupyter_notebook`(*notebook\_name*, *notebook\_content*)

Create a new jupyter notebook and get a handle to interact with it

* Parameters: * **notebook\_name** (*str*) – the name of the notebook to create
* **notebook\_content** (*dict*) – the data of the notebook to create, as a dict.
The data will be converted to a JSON string internally.
Use `DSSJupyterNotebook.get\_content()` on a similar existing **DSSJupyterNotebook** object in order
to get a sample definition object.

* Returns: A handle to interact with the newly created jupyter notebook

* Return type: `dataikuapi.dss.jupyternotebook.DSSJupyterNotebook` jupyter notebook handle

`list_continuous_activities`(*as\_objects=True*)

List the continuous activities in this project

* Parameters: **as\_objects** (*bool*) – if True, returns a list of
`dataikuapi.dss.continuousactivity.DSSContinuousActivity` objects, else returns a list of python
dicts (defaults to **True**)

* Returns: a list of the continuous activities, each one as a python dict, containing both the definition and
the state

* Return type: list

`get_continuous_activity`(*recipe\_id*)

Get a handler to interact with a specific continuous activities

* Parameters: **recipe\_id** (*str*) – the identifier of the recipe controlled by the continuous activity

* Returns: A job handle

* Return type: `dataikuapi.dss.continuousactivity.DSSContinuousActivity`

`get_variables`()

Gets the variables of this project.

* Returns: a dictionary containing two dictionaries : “standard” and “local”.
“standard” are regular variables, exported with bundles.
“local” variables are not part of the bundles for this project

* Return type: dict

`set_variables`(*obj*)

Sets the variables of this project.

Warning

If executed from a python recipe, the changes made by set\_variables will not be “seen” in that recipe. Use the internal API dataiku.get\_custom\_variables() instead if this behavior is needed

* Parameters: **obj** (*dict*) – must be a modified version of the object returned by get\_variables

`update_variables`(*variables*, *type='standard'*)

Updates a set of variables for this project

* Parameters: * **dict** (*variables*) – a dict of variable name -> value to set. Keys of the dict must be strings.
Values in the dict can be strings, numbers, booleans, lists or dicts
* **str** (*type*) – Can be “standard” to update regular variables or “local” to update local-only
variables that are not part of bundles for this project (defaults to **standard**)

`list_api_services`()

List the API services in this project

* Returns: the list of API services, each one as a python dict

* Return type: list

`create_api_service`(*service\_id*)

Create a new API service, and returns a handle to interact with it. The newly-created service does not have any endpoint.

* Parameters: **service\_id** (*str*) – the ID of the API service to create

* Returns: A API Service handle

* Return type: `dataikuapi.dss.apiservice.DSSAPIService`

`get_api_service`(*service\_id*)

Get a handle to interact with a specific API Service from the API Designer

* Parameters: **service\_id** (*str*) – The identifier of the API Designer API Service to retrieve

* Returns: A handle to interact with this API Service

* Return type: `dataikuapi.dss.apiservice.DSSAPIService`

`list_exported_bundles`()

List all the bundles created in this project on the Design Node.

* Returns: A dictionary of all bundles for a project on the Design node.

* Return type: dict

`export_bundle`(*bundle\_id*)

Creates a new project bundle on the Design node

* Parameters: **bundle\_id** (*str*) – bundle id tag

`get_exported_bundle_archive_stream`(*bundle\_id*)

Download a bundle archive that can be deployed in a DSS automation Node, as a binary stream.

Warning

The stream must be closed after use. Use a **with** statement to handle closing the stream at the end of the block by default. For example:

§ with project.get\_exported\_bundle\_archive\_stream('v1') as fp:

§ # use fp

§ # or explicitly close the stream after use

§ fp = project.get\_exported\_bundle\_archive\_stream('v1')

§ # use fp, then close

§ fp.close()

* Parameters: **bundle\_id** (*str*) – the identifier of the bundle

`download_exported_bundle_archive_to_file`(*bundle\_id*, *path*)

Download a bundle archive that can be deployed in a DSS automation Node into the given output file.

* Parameters: * **bundle\_id** (*str*) – the identifier of the bundle
* **path** (*str*) – if “-“, will write to /dev/stdout

`publish_bundle`(*bundle\_id*, *published\_project\_key=None*)

Publish a bundle on the Project Deployer.

* Parameters: * **bundle\_id** (*str*) – The identifier of the bundle
* **published\_project\_key** (*str*) – The key of the project on the Project Deployer where the bundle will be
published.A new published project will be created if none matches the key.
If the parameter is not set, the key from the current `DSSProject` is used.

* Returns: a dict with info on the bundle state once published. It contains the keys “publishedOn” for the
publish date, “publishedBy” for the user who published the bundle, and “publishedProjectKey” for the key of
the Project Deployer project used.

* Return type: dict

`list_imported_bundles`()

List all the bundles imported for this project, on the Automation node.

* Returns: a dict containing bundle imports for a project, on the Automation node.

* Return type: dict

`import_bundle_from_archive`(*archive\_path*)

Imports a bundle from a zip archive path on the Automation node.

* Parameters: **archive\_path** (*str*) – A full path to a zip archive, for example /home/dataiku/my-bundle-v1.zip

`import_bundle_from_stream`(*fp*)

Imports a bundle from a file stream, on the Automation node.

Usage example:

§ project = client.get\_project('MY\_PROJECT')

§ with open('/home/dataiku/my-bundle-v1.zip', 'rb') as f:

§ project.import\_bundle\_from\_stream(f)

* Parameters: **fp** (*file-like*) – file handler.

`activate_bundle`(*bundle\_id*, *scenarios\_to\_enable=None*)

Activates a bundle in this project.

* Parameters: * **bundle\_id** (*str*) – The ID of the bundle to activate
* **scenarios\_to\_enable** (*dict*) – An optional dict of scenarios to enable or disable upon bundle activation. The
format of the dict should be scenario IDs as keys with values of True or False (defaults to **{}**).

* Returns: A report containing any error or warning messages that occurred during bundle activation

* Return type: dict

`preload_bundle`(*bundle\_id*)

Preloads a bundle that has been imported on the Automation node

* Parameters: **bundle\_id** (*str*) – the bundle\_id for an existing imported bundle

`list_scenarios`(*as\_type='listitems'*)

List the scenarios in this project.

* Parameters: **as\_type** (*str*) – How to return the list. Supported values are “listitems” and “objects”
(defaults to **listitems**).

* Returns: The list of the datasets. If “rtype” is “listitems”, each one as a
`dataikuapi.dss.scenario.DSSScenarioListItem`.
If “rtype” is “objects”, each one as a `dataikuapi.dss.scenario.DSSScenario`

* Return type: list

`get_scenario`(*scenario\_id*)

Get a handle to interact with a specific scenario

* Parameters: **str** – scenario\_id: the ID of the desired scenario

* Returns: A scenario handle

* Return type: `dataikuapi.dss.scenario.DSSScenario`

`create_scenario`(*scenario\_name*, *type*, *definition=None*)

Create a new scenario in the project, and return a handle to interact with it

* Parameters: * **scenario\_name** (*str*) – The name for the new scenario. This does not need to be unique
(although this is strongly recommended)
* **type** (*str*) – The type of the scenario. MUst be one of ‘step\_based’ or ‘custom\_python’
* **definition** (*dict*) – the JSON definition of the scenario. Use **get\_definition(with\_status=False)** on an
existing **DSSScenario** object in order to get a sample definition object
(defaults to **{‘params’: {}}**)

* Returns: a `dataikuapi.dss.scenario.DSSScenario` handle to interact with the newly-created scenario

`list_recipes`(*as\_type='listitems'*)

List the recipes in this project

* Parameters: **as\_type** (*str*) – How to return the list. Supported values are “listitems” and “objects”
(defaults to **listitems**).

* Returns: The list of the recipes. If “as\_type” is “listitems”, each one as a
`dataikuapi.dss.recipe.DSSRecipeListItem`. If “as\_type” is “objects”, each one as a
`dataikuapi.dss.recipe.DSSRecipe`

* Return type: list

`get_recipe`(*recipe\_name*)

Gets a `dataikuapi.dss.recipe.DSSRecipe` handle to interact with a recipe

* Parameters: **recipe\_name** (*str*) – The name of the recipe

* Returns: A recipe handle

* Return type: `dataikuapi.dss.recipe.DSSRecipe`

`create_recipe`(*recipe\_proto*, *creation\_settings*)

Create a new recipe in the project, and return a handle to interact with it. We strongly recommend that you use the creator helpers instead of calling this directly.

Some recipe types require additional parameters in creation\_settings:

* ‘grouping’ : a ‘groupKey’ column name

* ‘python’, ‘sql\_query’, ‘hive’, ‘impala’ : the code of the recipe as a ‘payload’ string

* Parameters: * **recipe\_proto** (*dict*) – a prototype for the recipe object. Must contain at least ‘type’ and ‘name’
* **creation\_settings** (*dict*) – recipe-specific creation settings

* Returns: A recipe handle

* Return type: `dataikuapi.dss.recipe.DSSRecipe`

`new_recipe`(*type*, *name=None*)

Initializes the creation of a new recipe. Returns a `dataikuapi.dss.recipe.DSSRecipeCreator` or one of its subclasses to complete the creation of the recipe.

Usage example:

§ grouping\_recipe\_builder = project.new\_recipe("grouping")

§ grouping\_recipe\_builder.with\_input("dataset\_to\_group\_on")

§ # Create a new managed dataset for the output in the "filesystem\_managed" connection

§ grouping\_recipe\_builder.with\_new\_output("grouped\_dataset", "filesystem\_managed")

§ grouping\_recipe\_builder.with\_group\_key("column")

§ recipe = grouping\_recipe\_builder.build()

§ # After the recipe is created, you can edit its settings

§ recipe\_settings = recipe.get\_settings()

§ recipe\_settings.set\_column\_aggregations("value", sum=True)

§ recipe\_settings.save()

§ # And you may need to apply new schemas to the outputs

§ recipe.compute\_schema\_updates().apply()

* Parameters: * **type** (*str*) – Type of the recipe
* **name** (*str*) – Optional, base name for the new recipe.

* Returns: A new DSS Recipe Creator handle

* Return type: `dataikuapi.dss.recipe.DSSRecipeCreator`

`get_flow`()

* Returns: A Flow handle

* Return type: A `dataikuapi.dss.flow.DSSProjectFlow`

`sync_datasets_acls`()

Resync permissions on HDFS datasets in this project

Attention

This call requires an API key with admin rights

* Returns: a handle to the task of resynchronizing the permissions

* Return type: `dataikuapi.dss.future.DSSFuture`

`list_running_notebooks`(*as\_objects=True*)

Caution

Deprecated. Use `DSSProject.list\_jupyter\_notebooks()`

List the currently-running notebooks

* Returns: list of notebooks. Each object contains at least a ‘name’ field

* Return type: list

`get_tags`()

List the tags of this project.

* Returns: a dictionary containing the tags with a color

* Return type: dict

`set_tags`(*tags=None*)

Set the tags of this project. :param dict tags: must be a modified version of the object returned by list\_tags (defaults to **{}**)

`list_macros`(*as\_objects=False*)

List the macros accessible in this project

* Parameters: **as\_objects** – if True, return the macros as `dataikuapi.dss.macro.DSSMacro`
macro handles instead of a list of python dicts (defaults to **False**)

* Returns: the list of the macros

* Return type: list

`get_macro`(*runnable\_type*)

Get a handle to interact with a specific macro

* Parameters: **runnable\_type** (*str*) – the identifier of a macro

* Returns: A macro handle

* Return type: `dataikuapi.dss.macro.DSSMacro`

`get_wiki`()

Get the wiki

* Returns: the wiki associated to the project

* Return type: `dataikuapi.dss.wiki.DSSWiki`

`get_object_discussions`()

Get a handle to manage discussions on the project

* Returns: the handle to manage discussions

* Return type: `dataikuapi.dss.discussion.DSSObjectDiscussions`

`init_tables_import`()

Start an operation to import Hive or SQL tables as datasets into this project

* Returns: a `dataikuapi.dss.project.TablesImportDefinition` to add tables to import

* Return type: `dataikuapi.dss.project.TablesImportDefinition`

`list_sql_schemas`(*connection\_name*)

Lists schemas from which tables can be imported in a SQL connection

* Parameters: **connection\_name** (*str*) – name of the SQL connection

* Returns: an array of schemas names

* Return type: list

`list_hive_databases`()

Lists Hive databases from which tables can be imported

* Returns: an array of databases names

* Return type: list

`list_sql_tables`(*connection\_name*, *schema\_name=None*)

Lists tables to import in a SQL connection

* Parameters: * **connection\_name** (*str*) – name of the SQL connection
* **schema\_name** (*str*) – Optional, name of the schema in the SQL connection in which to list tables.

* Returns: an array of tables

* Return type: list

`list_hive_tables`(*hive\_database*)

Lists tables to import in a Hive database

* Parameters: **hive\_database** (*str*) – name of the Hive database

* Returns: an array of tables

* Return type: list

`list_elasticsearch_indices_or_aliases`(*connection\_name*)

`get_app_manifest`()

Gets the manifest of the application if the project is an app template or an app instance, fails otherwise.

* Returns: the manifest of the application associated to the project

* Return type: `dataikuapi.dss.app.DSSAppManifest`

`setup_mlflow`(*managed\_folder*, *host=None*)

Set up the dss-plugin for MLflow

* Parameters: * **managed\_folder** (*object*) – the managed folder where MLflow artifacts should be stored. Can be either
a managed folder id as a string, a `dataikuapi.dss.managedfolder.DSSManagedFolder`, or
a `dataiku.Folder`
* **host** (*str*) – setup a custom host if the backend used is not DSS (defaults to **None**).

`get_mlflow_extension`()

Get a handle to interact with the extension of MLflow provided by DSS

* Returns: A Mlflow Extension handle

* Return type: `dataikuapi.dss.mlflow.DSSMLflowExtension`

`list_code_studios`(*as\_type='listitems'*)

List the code studio objects in this project

* Parameters: **as\_type** (*str*) – How to return the list. Supported values are “listitems” and “objects”
(defaults to **listitems**).

* Returns: the list of the code studio objects, each one as a python dict

* Return type: list

`get_code_studio`(*code\_studio\_id*)

Get a handle to interact with a specific code studio object

* Parameters: **code\_studio\_id** (*str*) – the identifier of the desired code studio object

* Returns: A code studio object handle

* Return type: `dataikuapi.dss.codestudio.DSSCodeStudioObject`

`create_code_studio`(*name*, *template\_id*)

Create a new code studio object in the project, and return a handle to interact with it

* Parameters: * **name** (*str*) – the name of the code studio object
* **template\_id** (*str*) – the identifier of a code studio template

* Returns: A code studio object handle

* Return type: `dataikuapi.dss.codestudio.DSSCodeStudioObject`

`get_library`()

Get a handle to manage the project library

* Returns: A `dataikuapi.dss.projectlibrary.DSSLibrary` handle

* Return type: `dataikuapi.dss.projectlibrary.DSSLibrary`

`list_webapps`(*as\_type='listitems'*)

List the webapp heads of this project

* Parameters: **as\_type** (*str*) – How to return the list. Supported values are “listitems” and “objects”.

* Returns: The list of the webapps. If “as\_type” is “listitems”, each one as a `scenario.DSSWebAppListItem`.
If “as\_type” is “objects”, each one as a `scenario.DSSWebApp`

* Return type: list

`get_webapp`(*webapp\_id*)

Get a handle to interact with a specific webapp :param webapp\_id: the identifier of a webapp :returns: A `dataikuapi.dss.webapp.DSSWebApp` webapp handle

### dataiku package API[¶](https://doc.dataiku.com/dss/latest/api/python/projects.html#dataiku-package-api "Permalink to this headline")

*class* `dataiku.``Project`(*project\_key=None*)

This is a handle to interact with the current project

Note: this class is also available as `dataiku.Project`

`get_last_metric_values`()

Get the set of last values of the metrics on this project, as a `dataiku.ComputedMetrics` object

`get_metric_history`(*metric\_lookup*)

Get the set of all values a given metric took on this project :param metric\_lookup: metric name or unique identifier

`save_external_metric_values`(*values\_dict*)

Save metrics on this project. The metrics are saved with the type “external”

* Parameters: **values\_dict** – the values to save, as a dict. The keys of the dict are used as metric names

`get_last_check_values`()

Get the set of last values of the checks on this project, as a `dataiku.ComputedChecks` object

`get_check_history`(*check\_lookup*)

Get the set of all values a given check took on this project :param check\_lookup: check name or unique identifier

`set_variables`(*variables*)

Set all variables of the current project

* Parameters: **variables** (*dict*) – must be a modified version of the object returned by get\_variables

`get_variables`()

Get project variables :param bool typed: typed true to try to cast the variable into its original type (eg. int rather than string)

* Returns:: A dictionary containing two dictionaries : “standard” and “local”. “standard” are regular variables, exported with bundles.
“local” variables are not part of the bundles for this project

`save_external_check_values`(*values\_dict*)

Save checks on this project. The checks are saved with the type “external”

* Parameters: **values\_dict** – the values to save, as a dict. The keys of the dict are used as check names
