# Health monitoring[¶](https://doc.dataiku.com/dss/latest/apinode/operations/health-monitoring.html#health-monitoring "Permalink to this headline")

* Global isAlive probe

+ isAlive API

+ Forcing the node as not alive

* Monitoring the status of services

## Global isAlive probe[¶](https://doc.dataiku.com/dss/latest/apinode/operations/health-monitoring.html#global-isalive-probe "Permalink to this headline")

The API node features a global “isAlive” probe that can be used by a load balancer to query the status of the server.

The global isAlive probe does not actually perform validation that the individual services on the API node are properly running.

### isAlive API[¶](https://doc.dataiku.com/dss/latest/apinode/operations/health-monitoring.html#isalive-api "Permalink to this headline")

The isAlive probe is available on the `/isAlive/` HTTP mount point. This URI returns:

* An HTTP success code (2xx) if the probe considers the node as alive

* An HTTP server error code (5xx) if the probe considers the node as not alive

### Forcing the node as not alive[¶](https://doc.dataiku.com/dss/latest/apinode/operations/health-monitoring.html#forcing-the-node-as-not-alive "Permalink to this headline")

You can force the isAlive probe to indicate that the node is not alive, without actually interrupting the traffic. This will lead the load balancer to redirect the traffic to other nodes, and is generally used for rolling upgrades scenarii.

To force the node as not alive:

* Create a file called `apinode-not-alive.txt` in the API node data directory

To get back to normal:

* Remove the file `apinode-not-alive.txt` from the API node data directory

## Monitoring the status of services[¶](https://doc.dataiku.com/dss/latest/apinode/operations/health-monitoring.html#monitoring-the-status-of-services "Permalink to this headline")

To monitor the precise status of service, we recommend that you perform a regular prediction query, which will actually exercice the whole chain.
