# API Node & API Deployer: Real-time APIs[¶](https://doc.dataiku.com/dss/latest/apinode/index.html#api-node-api-deployer-real-time-apis "Permalink to this headline")

Production deployments in DSS are managed from a central place: the Deployer. The Deployer is usually deployed as a dedicated node in your DSS cluster, but may also be run locally on a Design or Automation node. See how to install the Deployer on your environment.

The Deployer has two separate but similar components, the Project Deployer and the API Deployer, that handle the deployment of projects and API services respectively. This section focuses on the latter. To know more about the Project Deployer, please refer to Production deployments and bundles.

In DSS Design and Automation nodes, you can create API services and deploy them to one or several API nodes, which are individual servers that do the actual job of answering REST API calls. The API Deployer allows you to:

* Define “API infrastructures”, each pointing to either already-installed API node(s) or a Kubernetes cluster

* Deploy your API services on an infrastructure (i.e. to all the API nodes in the infrastructure)

* Monitor the health and status of your deployed APIs

* Introduction

+ Exposing predictive models

+ Exposing arbitrary Python and R functions

+ Exposing SQL queries

+ Performing lookups in datasets

+ Querying the API nodes

+ Designing APIs

+ Managing services and API nodes

* Concepts

+ API Node

+ API Deployer

+ API Designer

+ API Service

+ Endpoint

+ Version

+ Deployment Infrastructure

+ Deployment

+ Package

* Installing API nodes

* Setting up the API Deployer and deployment infrastructures

+ Create your first infrastructure

* First API (with API Deployer)

+ Create the model

+ Create the API Service

+ (Optional) Add test queries

+ Push a version to the API Deployer

+ Deploy your version

+ Perform real queries

+ Next steps

* First API (without API Deployer)

+ Create the model

+ Create the API Service

+ (Optional) Add test queries

+ Create a version and transfer the package

+ Create the service in the API node

+ Perform a test query

+ Perform real queries

+ Next steps

* Types of Endpoints

+ Exposing a Visual Model

+ Exposing a Python prediction model

+ Exposing a R prediction model

+ Exposing a MLflow model

+ Exposing a Python function

+ Exposing a R function

+ Exposing a SQL query

+ Exposing a lookup in a dataset

* Enriching prediction queries

+ Use case

+ Configuration

+ Deployment options

* Security

+ Security for API Node administration API

+ Permissions for API Deployer

+ Authorization

+ Without API Deployer

+ With API Deployer

+ How to setup JWT/OAuth2 authorization method

+ Send requests to an API protected with JWT/OAuth2

* Managing versions of your endpoint

+ Updating and activating enpoint versions

+ Running multiple versions at once

+ Monitoring version activation

* Deploying on Kubernetes

+ Setting up

+ Deployment on Google Kubernetes Engine

+ Deployment on Azure AKS

+ Deployment on AWS EKS

+ Deployment on Minikube

+ Managing SQL connections

* APINode APIs reference

+ API node user API

+ API node administration API

+ Endpoint APIs

* Operations reference

+ Using the apinode-admin tool

+ High availability and scalability

+ Logging and auditing

+ Health monitoring
