# Custom options and environment[¶](https://doc.dataiku.com/dss/latest/code-envs/custom-options.html#custom-options-and-environment "Permalink to this headline")

In many cases, it may be needed to customize options passed to the various system commands used in the management of the code environment system (`virtualenv`, `pip`, `R` and `conda`)

One of the main use cases for doing so is if your DSS server does not have outgoing Internet access. In that case, you will not be able to install packages from the main repositories, and will need to pass additional arguments for custom repositories.

Custom options for virtualenv, pip, R and conda can be configured in Administration > Settings > Misc. These settings can only be configured by the DSS administrator.

These options can also be overriden on a per-code-environment basis by unchecking “Inherit global settings” in the “General > Extra options” configuration section for the code environment.

## Examples[¶](https://doc.dataiku.com/dss/latest/code-envs/custom-options.html#examples "Permalink to this headline")

The options for pip, virtualenv, R and conda can be found in the relevant documentation.

* For pip, the relevant custom options can be found in the pip install documentation.

* For virtualenv, the relevant custom options can be found in the virtualenv documentation

* For conda, you can customize the conda create and conda install options.

* For R, you can customize the CRAN mirror URL

You can apply regular pip, virtualenv or conda install flags to a code environment by adding the respective option flags. The syntax for all options is an entry line for the option, followed by a separate entry line for the option value.

### Adding a trusted host for pip installs[¶](https://doc.dataiku.com/dss/latest/code-envs/custom-options.html#adding-a-trusted-host-for-pip-installs "Permalink to this headline")

Trust the following hosts even without valid HTTPS. This will run the equivalent of `pip install --trusted-host pypi.python.org --trusted-host file.pythonhosted.org [...]`

§ --trusted-host

§ pypi.python.org

§ --trusted-host

§ file.pythonhosted.org

### Adding a proxy for pip installs[¶](https://doc.dataiku.com/dss/latest/code-envs/custom-options.html#adding-a-proxy-for-pip-installs "Permalink to this headline")

Apply a proxy to your pip installations. This will run the equivalent of `pip install --proxy [user:passwd@]proxy.server:port [...]`

§ --proxy

§ [user:[email protected]]proxy.server:port

### Point to a custom python package repository for pip installs[¶](https://doc.dataiku.com/dss/latest/code-envs/custom-options.html#point-to-a-custom-python-package-repository-for-pip-installs "Permalink to this headline")

Use an alternative python package repository for pip installs (not PyPI). This will run the equivalent of `pip install --index-url http://index.example.com/simple/ [...]`

§ --index-url

§ http://index.example.com/simple/

### Install from a local directory without scanning remote package indexes[¶](https://doc.dataiku.com/dss/latest/code-envs/custom-options.html#install-from-a-local-directory-without-scanning-remote-package-indexes "Permalink to this headline")

If you are installing packages on a system with limited connectivity, you can set pip not to scan remote package indexes when installing a package, and provide a local path to install from. This will run the equivalent of `pip install --no-index --find-links /full/path/to/package-folder/ [...]`

§ --no-index

§ --find-links

§ /full/path/to/package-folder/

### Add a conda channel for packages install[¶](https://doc.dataiku.com/dss/latest/code-envs/custom-options.html#add-a-conda-channel-for-packages-install "Permalink to this headline")

Adds an additional channel to search for packages. Runs the equivalent of `conda install --channel conda-forge [...]`

§ --channel

§ conda-forge
