# Filtering a dashboard using a query parameter in the URL[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#filtering-a-dashboard-using-a-query-parameter-in-the-url "Permalink to this headline")

If a dashboard contains a filter tile, it can be pre-filtered by defining the filters default state in Edit mode.

However, in View mode changes are not kept. To share or bookmark a dashboard pre-filtered from the View mode, you can add a query string parameter to the dashboard URL and share or bookmark it.

## Generating a URL from a filters tile[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#generating-a-url-from-a-filters-tile "Permalink to this headline")

The fastest and easiest way to create a ready-to-use dashboard URL with a filters query parameter is to open the dashboard, edit the filters to match the expected state, and click on the “Copy as URL in clipboard” button.

Once the URL is ready, you will get a notification and it will be available in your clipboard so you can paste it wherever you want.

Note

Opening a generated URL with a filters query parameter ensures that the insights in the dashboard are filtered as they were at generation time. The values available in the filter facets can be restricted to what’s shown without the possibility to extend the selection. To be able to select more values, open a filter settings menu and switch to “All values in sample” mode.

## Filters query parameter syntax[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#filters-query-parameter-syntax "Permalink to this headline")

You will see below that the filters query parameter value uses a syntax that can be understood and written by humans. However, it contains special characters that browsers will fail to parse. Once your filter query parameter value is ready, do not forget to encode it before appending it to the dashboard URL (many tools can be found online to encode a URL).

For example: .. code-block:

§ https://mydssinstance.com/projects/MYPROJECT/dashboards/42?filters=foo:"bar"

becomes .. code-block:

§ https://mydssinstance.com/projects/MYPROJECT/dashboards/42?filters=foo%3A%22bar%22

### Value types[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#value-types "Permalink to this headline")

#### Column name[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#column-name "Permalink to this headline")

Column names are at the left part of a filter description, they can be wrapped in an operator and they are always followed by a colon that separates the Column name from the filter values. If the column contains colons, they must be escaped by prefixing them with a backslash. For example `Weight: maximum`` become ``Weight\: maximum``.

#### String[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#string "Permalink to this headline")

A String is wrapped in double quotes. Double quotes and backslashes within the string content must be escaped by prefixing them with a backslash. For example `"Hello", \ he says` becomes `"\"Hello\", \\ he says"`.

#### ISO Date[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#iso-date "Permalink to this headline")

An ISO Date is defined by the ISO 8601 norm and doesn’t need any special formatting. For example, a valid ISO Date is `2023-01-01T00:00:00.000Z`.

#### Number[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#number "Permalink to this headline")

A Number is either an integer or a rational number and doesn’t need any special formatting. Please note that filters created from a numerical column but treated as alphanumerical ones use Strings, so `42` becomes `"42"`.

### Alphanumerical filter[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#alphanumerical-filter "Permalink to this headline")

Alphanumerical filter value is a list of Strings separated by commas (`,`). Alphanumerical filter value can be negated using the `not` values operator.

An alphanumerical filter can be applied to a textual column or a numerical column.

To filter on a column named City so as to include only Paris and New York: .. code-block:

§ ?filters=City:"Paris","New York"

Note

When using this syntax, the filter is in “Exclude other values” mode.

To filter on a column named City so as to exclude Paris and New York: .. code-block:

§ ?filters=City:not("Paris","New York")

Note

When using this syntax, the filter is in “Include other values” mode.

### Numerical range filter[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#numerical-range-filter "Permalink to this headline")

Numerical range filter value is two Numbers separated by a comma (`,`). Numerical range filters can be applied to numerical columns only. Numerical range filters use the `range` column operator.

To filter on a column named Age so as to restrict the values from 24 to 42: .. code-block:

§ ?filters=range(Age):24,42

To filter on a column named Age so as to restrict the values to at least 24: .. code-block:

§ ?filters=range(Age):24

To filter on a column named Age so as to restrict the values to at most 42: .. code-block:

§ ?filters=range(Age):,42

To filter on a column named Age so as to include all values: .. code-block:

§ ?filters=range(Age):

### Date range filter[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#date-range-filter "Permalink to this headline")

Date range filter value is two ISO Dates separated by a comma (`,`). Date range filters can be applied to date columns only.

To filter on a column named Birthday so as to restrict the values from a date to another: .. code-block:

§ ?filters=Birthday:2022-01-01T00:00:00.000Z,2023-01-01T00:00:00.000Z

To filter on a column named Birthday so as to restrict the values from a date: .. code-block:

§ ?filters=Birthday:2022-01-01T00:00:00.000Z

To filter on a column named Birthday so as to restrict the values until a date: .. code-block:

§ ?filters=Birthday:,2023-01-01T00:00:00.000Z

To filter on a column named Birthday so as to include all values: .. code-block:

§ ?filters=Birthday:

### Date part filter[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#date-part-filter "Permalink to this headline")

Date range filter value is a list of Strings separated by commas (`,`). Date range filter value can be negated using the `not` values operator. Date range filters can be applied to date columns only. Date range filters use a date part column operator.

Available date parts are:

* `year`

+ values are numerical years, e.g. `"2023"`.

* `quarterofyear`

+ values are numerical quarter of years from 1 to 4, e.g. `"1"`.

* `monthofyear`

+ values are numerical monthes of the year from 1 to 12, e.g. `"1"`.

* `weekofyear`

+ values are numerical weeks of the year from 1 to 53, e.g. `"1"`.

* `dayofyear`

+ values are numerical days of the year from 1 to 366, e.g. `"1"`.

* `dayofweek`

+ values are capitalized day names, e.g. `"Monday"`.

* `hourofday`

+ values are numerical hour of days from 0 to 23, e.g. `"0"`.

Example of a date part filter on a column Birthday to include dates from the years 2022 and 2023: .. code-block:

§ ?filters=year(Birthday):"2022","2023"

Example of a date part filter on a column Birthday to exclude dates from the years 2022 and 2023: .. code-block:

§ ?filters=year(Birthday):not("2022","2023")

### Multiple filters at once[¶](https://doc.dataiku.com/dss/latest/dashboards/url-filters-query-param.html#multiple-filters-at-once "Permalink to this headline")

If you need multiple filter facets in your URL, separate them with semicolons (`;`).

Example of mutiple filter facets: .. code-block:

§ ?filters=City:"Paris","New York";filters=range(Age):24;year(Birthday):not("2022","2023")

Once encoded and appended to the URL: .. code-block:

§ https://mydssinstance.com/projects/MYPROJECT/dashboards/42?filters=City%3A%22Paris%22%2C%22New%20York%22%3Bfilters%3Drange%28Age%29%3A24%3Byear%28Birthday%29%3Anot%28%222022%22%2C%222023%22%29
