# The REST API[¶](https://doc.dataiku.com/dss/latest/governance/publicapi/rest.html#the-rest-api "Permalink to this headline")

At its core, the Dataiku Govern public API is a REST HTTP API. The reference HTTP documentation of the Dataiku Govern REST API can be found here: https://doc.dataiku.com/dss/api/11/govern.

The API base URL is: http://dss\_host:dss\_port/public/api/

## Request and response formats[¶](https://doc.dataiku.com/dss/latest/governance/publicapi/rest.html#request-and-response-formats "Permalink to this headline")

For POST and PUT requests, the request body must be JSON, with the Content-Type header set to application/json.

For almost all requests, the response will be JSON.

Whether a request succeeded is indicated by the HTTP status code. A 2xx status code indicates success, whereas a 4xx or 5xx status code indicates failure. When a request fails, the response body is still JSON and contains additional information about the error.

## Authentication[¶](https://doc.dataiku.com/dss/latest/governance/publicapi/rest.html#authentication "Permalink to this headline")

Authentication on the REST API is done via the use of API keys. API keys can be managed through the Dataiku Govern administration UI.

The API key must be sent using HTTP Basic Authorization:

* Use the API key as username

* The password can remain blank

## Authorization[¶](https://doc.dataiku.com/dss/latest/governance/publicapi/rest.html#authorization "Permalink to this headline")

Each API key has access rights and scopes. Dataiku Govern has a simple UI to edit API key permissions.

For more information about API keys, see Public API Keys

## Methods reference[¶](https://doc.dataiku.com/dss/latest/governance/publicapi/rest.html#methods-reference "Permalink to this headline")

The reference documentation of the API is available at https://doc.dataiku.com/dss/api/11/govern

The API base URL is: http://dss\_host:dss\_port/public/api/
