# Govern Projects, Models and Bundles[¶](https://doc.dataiku.com/dss/latest/governance/projects-models-governance.html#govern-projects-models-and-bundles "Permalink to this headline")

* Governable Items

+ Projects

+ Models

+ Model Versions

+ Bundles

* Overview and Workflows

* Project Qualification

* Customized Overview and Workflows

## Governable Items[¶](https://doc.dataiku.com/dss/latest/governance/projects-models-governance.html#governable-items "Permalink to this headline")

After connecting Dataiku Govern to your existing Dataiku instances, Govern will automatically provide a view of all your projects and saved models. You can use a dedicated page called “Governable Items” to choose which of these items to “Govern” - this means choosing which items to manage with the predefined governance plans (to track their status, centralize progress reports, etc.).

You can use the “Hide” button to remove anything from the Governable Items page that you don’t intend to govern (and you can use the “Visibility” filter to find previously-hidden items that you decide to govern).

### Projects[¶](https://doc.dataiku.com/dss/latest/governance/projects-models-governance.html#projects "Permalink to this headline")

You can choose to govern Projects. Any projects you choose not to govern will continue to function in the rest of Dataiku as usual, but will not have the additional layer of Governance information in Govern.

### Models[¶](https://doc.dataiku.com/dss/latest/governance/projects-models-governance.html#models "Permalink to this headline")

Models can only be governed if their parent Project is also governed. So if you choose to govern a Model that is part of an ungoverned Project, the “Governable items” page will alert you and will automatically govern the parent Project as well as the selected Model.

If you decide to govern a Model, then all Saved Model Versions within that Model will automatically be governed as well

### Model Versions[¶](https://doc.dataiku.com/dss/latest/governance/projects-models-governance.html#model-versions "Permalink to this headline")

They do not appear in the “Governable items” but are automatically governed when you choose to govern the parent Model.

### Bundles[¶](https://doc.dataiku.com/dss/latest/governance/projects-models-governance.html#bundles "Permalink to this headline")

They do not appear in the “Governable items”. Bundles can be governed from the dedicated Bundle Registry tab. You can either choose to govern directly a bundle or govern all its existing bundles when governing a project. Once a project has been governed, all new bundles of this project will automatically be governed when created.

## Overview and Workflows[¶](https://doc.dataiku.com/dss/latest/governance/projects-models-governance.html#overview-and-workflows "Permalink to this headline")

Dataiku Govern provides you with tools to manage and track the status of your AI projects and models.

You will be able to attach extra contextual information and predefined workflows to projects, models, model versions and bundles that are being worked on your Dataiku instances. The workflows can be followed and continually filled-out to track the progress of the projects or models.

More specifically:

The extra contextual information might include specifying the person responsible for a specific project, adding in notes on the latest update on progress, or attaching documentation for a project or a model version. In Dataiku Govern you fill in this extra contextual information on the Overview page of a Governed project, model or model version.

The workflows involve updating the status of a project or model version (e.g., whether something is being explored, being worked on or is completed). In Dataiku Govern, a workflow has a sequential series of steps to track progress of the item (for example, “In Progress”, “Under Review”, etc.). Each step also can have its own fields to post updates, attach relevant documents, etc. You fill in this information on the workflow page of a governed project or a governed model version. Models do not have workflows.

## Project Qualification[¶](https://doc.dataiku.com/dss/latest/governance/projects-models-governance.html#project-qualification "Permalink to this headline")

A common challenge when dealing with multiple projects is thinking about how to qualify the projects in order to prioritize work. The Project Qualification step in the project workflow aims to define the level of value, risk and feasibility of each project.

The risk and value metrics can then be compared across governed projects.

## Customized Overview and Workflows[¶](https://doc.dataiku.com/dss/latest/governance/projects-models-governance.html#customized-overview-and-workflows "Permalink to this headline")

While not included by default, Dataiku Govern was built to support extensive customization, providing more flexibility for clients with complex governance requirements for which the predefined templates aren’t sufficient. For example, you may want to customize the number of steps in each workflow, the fields for team members to fill in on the overview pages or on each workflow step, etc. User roles/permissions can also be tailored based on your needs - for example to allow some users to be able to see only some models, projects, etc., or even to allow some users to only see certain fields on a given project.

Customization is available as a dedicated service through the Dataiku Solutions team and is charged separately. Reach out to Dataiku to learn more.
