# Sign-off Scenario[¶](https://doc.dataiku.com/dss/latest/governance/sign-off.html#sign-off-scenario "Permalink to this headline")

* Configure in Dataiku

* Reviewers

* Review Process

* Email Notifications

Dataiku Govern allows you to require stakeholder sign-off on model versions and on bundles before they are deployed to production on certain infrastructures.

## Configure in Dataiku[¶](https://doc.dataiku.com/dss/latest/governance/sign-off.html#configure-in-dataiku "Permalink to this headline")

Note

The following information applies to both deployment of model versions on an API node and deployment of bundles on an Automation node.

Once Dataiku Deploy is linked with the Dataiku Govern instance, the governance policy has to be defined for each infrastructure. From the settings, you can choose between 3 levels of governance policy that will apply for all deployments:

Prevent the deployment of unapproved packages

Warn and ask for confirmation before deploying unapproved packages

Always deploy without checking

You can retrieve the information in the Govern Policy setting of your infrastructure.

A Governance status section is visible for each model version of saved models in their summary page, letting you know at which stage of the Governance workflow process your model is.

Similarly, in the bundle summary section, there is a governance status section:

If you try to deploy a model version or a bundle on an infrastructure that is under the “Prevent…” policy, you will get an error asking you to complete the approval process before deployment. If the policy is set to “Warn…”, you will receive a warning asking you if you really want to continue the deployment.

## Reviewers[¶](https://doc.dataiku.com/dss/latest/governance/sign-off.html#reviewers "Permalink to this headline")

In the Govern process, Sign-off is broken down into “Feedback” and “Final Approval” (we will use the word “reviewers” to describe anyone in either group).

There are multiple answer slots for Feedback, but only one for the Final Approval (the slots can be assigned to either Roles or individuals)

Feedback is optional - it is intended to give the Final Approver more information for their approval decision (and to give useful feedback to the creator of the model version or of the bundle)

Feedback can come from IT & Operations teams, Risk & Compliance teams and Business teams

The Final Approval answer is what is checked by Dataiku when deploying a model version or a bundle (to block deployment or give a warning, depending on the infrastructure settings). This means that it is possible to skip the Feedback section and just have the Final Approver sign off.

Reviewers can be reused in the same sign-off process (e.g. someone could be asked for both “Feedback” and “Final Approver”).

Reviewers are defined at the governed project level in “Sign-off reviewers and approvers” and will be the same for all model versions and bundles attached to this project.

## Review Process[¶](https://doc.dataiku.com/dss/latest/governance/sign-off.html#review-process "Permalink to this headline")

First, a user requests a review of a model version or a bundle by using the button in the workflow tab (under the “review“ step). The user can choose to send emails to the reviewers notifying them that their review has been requested.

Each reviewer can approve, raise a minor issue or raise a major issue about the object being reviewed (the model version or the bundle), but only the final approver has the final call and can approve/reject/abandon it.

If necessary, each reviewer can delegate their review to another user. It is a convenient way to ask someone else to give a review. In the same way, the final approver can delegate their approval to another user.

If the model version or the bundle is approved, its status is updated and it can be deployed on production.

If the model version or the bundle is abandoned or rejected, the workflow is locked and deployment is not possible.

## Email Notifications[¶](https://doc.dataiku.com/dss/latest/governance/sign-off.html#email-notifications "Permalink to this headline")

Govern will notify you when an important status change happens on a sign-off that you are part of, for example if someone requests an approval from you.

Please note that this feature needs be configured by your administrator first, see Setting up email notifications.
