# Single Sign-On[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#single-sign-on "Permalink to this headline")

Single sign-on (SSO) refers to the ability for users to log in just one time with one set of credentials to get access to all corporate apps, websites, and data for which they have permission.

By setting up SSO in FM, your users will be able to access FM using their corporate credentials.

SSO solves key problems for the business by providing:

* Greater security and compliance.

* Improved usability and user satisfaction.

Delegating the FM authentication to your corporate identity provider using SSO allows you to enable a stronger authentication journey to FM, with multi-factor authentication (MFA) for example.

FM supports the following SSO protocols:

* OpenID connect

* SAML

## Users database[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#users-database "Permalink to this headline")

Since FM users all have the same privileges, we recommend that you simply map all your login users to the admin user.

If you choose not to map to the same user, you must create FM user accounts for each SSO user. When creating these users, select “Local (no auth, for SSO only)” as the source type. Since users won’t enter passwords in SSO mode, only a login and display name are required.

## OpenID Connect[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#openid-connect "Permalink to this headline")

### About OIDC[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#about-oidc "Permalink to this headline")

#### Glossary[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#glossary "Permalink to this headline")

* **OIDC** : **O**pen**ID** **C**onnect

* **IDP** : An **Id**entity **P**rovider is a system entity that creates, maintains, and manages identity information for principals and also provides authentication services to relying applications within a federation or distributed network

* **End-user** : The end user is the entity for whom we are requesting identity information. In our case, it is the FM user that need to login to access FM.

* **OIDC Client** : Also called Relying party **RP** in the OIDC specification, the OIDC client is the application that relies on the IDP to authenticate the end user. In our case, it is FM.

* **ID Token**: Similar to a ID card or passport, it contains many required attributes or claims about the user. This token is then used by FM to map the claims to a corresponding FM user. Digitally signed, the ID token can be verified by the intended recipients (FM).

* **Claim** : In FM context, claims are name/value pairs that contain information about a user.

* **Scope** : In the context of OIDC, scope references a set of claims the OIDC client needs. Example: email

* **Authorization code** : During the OIDC protocol, the authorization code is generated by the IDP and sent to the end-user, which passes it to the OIDC client. It is then used by the OIDC client, who sends the authorization code to the IDP, and receives in exchange an ID token. Using an intermediate authorization code allows the IDP to mandate the OIDC client to authenticate itself in order to retrieve the ID token.

* **Confidential client** : An OIDC client with the capacity to exchange the authorization code for an ID token in a secured back channel. This is the case of FM.

* **Public client** : An OIDC client not able to store secret securely and needs to exchange the authorization code for an ID token in a public channel. FM is not a public client.

* **PKCE** : **P**roof **K**ey for **C**ode **E**xchange is an extension of the OIDC protocol, to allow public clients to exchange the authorization code in a public channel.

#### Compatibility[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#compatibility "Permalink to this headline")

FM OIDC integration has been successfully tested against the following OIDC identity providers:

* OKTA

* Azure Active Directory

* Google G.Suite

* Keycloak

#### OIDC features supported by FM[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#oidc-features-supported-by-dku-app "Permalink to this headline")

* authorization code grant flow

* simple string claims in the ID token

* non encrypted or signed authentication requests

* ID token signed with RSA or EC

* FM behind a proxy

* response mode supported: query or fragment

* token endpoint auth method supported: client secret basic or client secret POST

* confidential OIDC client only (PKCE not supported)

#### How OIDC looks like with FM[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#how-oidc-looks-like-with-dku-app "Permalink to this headline")

Once configured for OIDC SSO, FM acts as an OIDC client, which delegates user authentication to an identity provider.

When the end user tries to access FM and is not authenticated yet, FM will redirect him to the IDP. The URL used will be the authorization endpoint of the IDP, which some specific GET parameters specific to the FM setup.

The IDP will validate the GET parameters and will present a login page to the user. The authentication journey now depends on your IDP capabilities. Sometimes, when already logged-in on the IDP side, the login page is skipped and the user may not see the redirection to the IDP.

The IDP has authenticated the end user and will redirect the user to FM with an authorization code. Depending of your OIDC client setup in your IDP, the code may be passed through via the query parameters or the fragment.

The front-end of FM will parse and send the parameters, including the authorization code, to the FM backend.

The FM backend will exchange this authorization code for an access token, by calling the token endpoint with the credentials you previously have configured in FM SSO settings. If successful, the IDP will return an ID token corresponding the end user.

FM uses the ID token to map the end user to a FM user. The mapping setup is part of the SSO configuration of OIDC.

FM creates a user session corresponding to the FM user. At this point, OIDC is completed and the user session is agnostic of the authentication protocol used.

### Setup OIDC in FM[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#setup-oidc-in-fm "Permalink to this headline")

To set up OIDC integration, you need:

* to register a new OIDC Client (sometimes called an ‘application’) for FM in your identity provider,

* to configure FM with the parameters of the identity provider as well as the parameters corresponding to the OIDC client created earlier,

* to configure which of the user attributes returned by the IDP is to be used as the FM username, and optionally configure rewrite rules to extract the FM username from the chosen user attribute.

These steps are individually detailed below.

#### Registering a service provider entry for FM on the identity provider.[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#registering-a-service-provider-entry-for-dku-app-on-the-identity-provider "Permalink to this headline")

The exact steps for this depend on the identity provider platform which you plan to connect to, and should be performed by your IDP administrator. This entry may also be called an “OIDC application”. You will sometimes be asked to select the type of application, which would be in our case a web application.

You will typically need:

* to setup the OIDC client to use the authorization code grant flow,

* a client ID,

* a client secret,

Note

The OIDC client needed by FM is a confidential client (opposite of public client). Meaning FM is able to protect the client secret, by exchanging the authorization code (and using the secret in the request) from the backend.

* setup the redirect URI BASE\_URL/login/openid-redirect-uri/,

Note

This URL must be configured as BASE\_URL/login/openid-redirect-uri/, where BASE\_URL is the URL through which FM users access this FM instance.

For example, if FM is accessed at https://dataiku.mycompany.corp/, the OIDC redirect uri must be defined as https://dataiku.mycompany.corp/login/openid-redirect-uri/.

Note that some identity providers require the redirect URI to use the HTTPS scheme.

* associate some OIDC scopes to the OIDC client. Some IDPs refer to these as permissions, like user.read. You will need to setup the scope openid as well as some identity claims.

You must ensure that FM is able to access and retrieve all the user attributes needed to identify the corresponding user in FM.

Note

FM will need to map to an existing user from one of the user claims. It’s important that you allow FM to retrieve a claim that is easily mappable to the username. A good candidate is email, of which you can strip the part after ‘@’ to compose a unique identifier for usernames.

#### Configuring FM for OIDC authentication.[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#configuring-dku-app-for-oidc-authentication "Permalink to this headline")

OIDC configuration is in the Settings > Login (LDAP, SSO) & Security > SSO screen.

Select “Enable”, choose protocol “OIDC”.

##### IDP configuration[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#idp-configuration "Permalink to this headline")

Contact your IDP administrator to retrieve this information or check your IDP documentation.

The easiest way to setup the IDP configuration is using the well-known endpoint: The OIDC standard defines an endpoint, called well-known, to discover the IDP configuration. FM lets you enter the well-known endpoint of your IDP and fetch the rest of the configuration for you. If you don’t know the well-known endpoint, you can still enter the other configurations manually, the well-known input being optional.

* **Well-known URL**: Optional, defines the well-known endpoint, which is a URI ending with /.well-known/openid-configuration. Click Fetch IDP configuration to auto-complete the rest of the IDP configuration.

* **Issuer**: The issuer is a URI to identify the IDP. It is used in particular to verify that the ID token was signed by the right IDP. Per specification, the issuer is a URI, for which you can append the path /.well-known/openid-configuration to get the IDP well-known endpoint.

Note

Tips: If you have an example of a valid ID token, you can read its content with jwt.io and find the issuer value behind the iss claim. You can then build up the well-known URI by appending /.well-known/openid-configuration to it.

* **Authorization endpoint**: The authorization endpoint is used to redirect the user to the IDP for the authentication.

* **Token endpoint**: The token endpoint is used by FM to exchange the authorization code with an ID token. This endpoint will be called from the backend of FM. If FM is behind a proxy, please make sure FM is able to call this endpoint.

* **JWKs URI**: The JWKs URI is a way for the IDP to specify all its public keys. This is used by FM to verify the signature of the ID token.

Examples of well-known endpoints:

* **Google**: https://accounts.google.com/.well-known/openid-configuration

* **Azure**: https://login.microsoftonline.com/common/v2.0/.well-known/openid-configuration

* **Okta**: https://common.okta.com/.well-known/openid-configuration

* **Keycloak**: https://your-keycloak-instance/auth/realms/your-realm/.well-known/openid-configuration

Note

In some case, the well-known can be the same for everyone, like for google. In other scenario, the IDP will generate a dedicated one for your application, like Okta or Azure for which it is configured by tenant.

##### OIDC Client configuration[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#oidc-client-configuration "Permalink to this headline")

In the previous section, you created an OIDC client. Use this client to complete the following section:

* **Token endpoint auth method**: This is the authentication method that FM will use to specify the credentials during the token exchange. Most of the time, when supporting client secret, the IDP will allow either of the two methods. Leave this field by default if you are unsure, as it will most likely work.

* **Client ID**: the client ID generated by the IDP. In the IDP portal, it could be named application id. Refer to your IDP documentation for more details on how to retrieve your client ID.

* **Client secret**: The client secret your IDP generated for this client. Sometimes, it is not generated by default by your IDP (like Azure). In this case, look for a section ‘secrets’ in your IDP setup for the OIDC client.

* **Scope**: Specify the scope that FM needs to use during the login flow. As a minima, it should contain openid. The scope contains a list of scopes separated by spaces.

Note

The scope is essential for doing the mapping with the username, as it defines the user claims the IDP needs to send back to FM. We recommend to add either email or/and profile, two common scopes supported by most IDPs. Most IDPs will mandate that you add some dedicated permissions before associating those scopes to your OIDC client. See your IDP documentation for more details.

Note

The list of scopes supported by your IDP is listed in the well-known, under the attribute claims\_supported. Even if they are supported, you will still need to authorise the OIDC client to use those scopes, via your IDP portal.

##### Examples of scopes by IDPs[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#examples-of-scopes-by-idps "Permalink to this headline")

For Google, Azure, Okta and Keycloak, the simplest scope is email, which will return two claims - email and email\_verified. Set in Identifier claim key the claim email.

Azure, Okta and Keycloak also support another claim called preferred\_username, which is returned as part of the profile scope.

Resources:

* Google documentation

* Azure documentation

* Okta documentation

* Keycloak documentation (search for principal-attribute in the page)

#### Mapping to the FM user[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#mapping-to-the-dku-app-user "Permalink to this headline")

When FM successfully retrieves the ID token from the IDP, it needs to map it to a user in FM. The ID token will contain user claims that depend on the scope you defined earlier. The following two fields will help FM map the ID token to a FM user:

* **Identifier claim key**: Depending on the scope you configured, the IDP will return different user claims. Define here the one you want to use to map to the corresponding username in FM. One easy way that works for most IDP, is to use the email and then strip the part after the ‘@’.

* **Login remapping rules**: Map a claim received from the IDP to your username format. Example: stripping the part after ‘@’ in an email. You may not need this field if your IDP is returning a user claim that matches exactly the username (it’s the case of keycloak if you use the preferred\_username claim for example).

Warning

The Login remapping rules are evaluated in order. If you have multiple rules and their regexes overlap (ie ^(.\*)@mycompany.corp$ and ^(.\*)$), make sure the most specific one is defined first.

Note

Example of mapping if you choose the email as identifier claim: ^(.\*)@mycompany.corp$ -> $1

Note

FM logs all the claims received from the IDP in the backend log file, which may help configuring the Identifier claim key and the mapping for it.

### Testing OIDC SSO[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#testing-oidc-sso "Permalink to this headline")

* Configure OIDC integration as described above

* Access the FM URL from another browser or an anonymous window

* You should be redirected to the IDP for authentication, then back to the FM redirect URL, then to the FM homepage

* If login fails, check the logs for more information

Important

Once SSO has been enabled, if you access the root FM URL, SSO login will be attempted. If SSO login fails, you will only see an error.

You can still use the regular login/password login by going to the `/login/` URL on FM. This allows you to still log in using a local account if SSO login is dysfunctional.

## SAML[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#saml "Permalink to this headline")

### About SAML[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#about-saml "Permalink to this headline")

#### Compatibility[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#id1 "Permalink to this headline")

FM has been successfully tested against the following SAML identity providers:

* OKTA

* PingFederate PingIdentity (see note below)

* Azure Active Directory

* Google G.Suite

* Microsoft Active Directory Federation Service (tested against Windows 2012 R2)

* Auth0

* Keycloak

Note

For AD FS, it is mandatory to configure at least one claim mapping rule which maps to “Name ID”, even if another attribute is used as the FM login attribute.

FM does not support SAML encryption.

### Setup SAML in FM[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#setup-saml-in-fm "Permalink to this headline")

To set up SAML integration, you need:

* to register a new service provider entry on your SAML identity provider, for this FM instance.

This entry is identified by a unique “entity ID”, and is bound to the SAML login URL for this FM instance.

* to configure FM with the IdP parameters, so that FM can redirect non logged-in users to the IdP for authentication, and

can authentify the IdP response

* optionally, to configure which of the user attributes returned by the IdP is to be used as the FM username, or configure

rewrite rules to extract the FM username from the chosen IdP attribute

These steps are individually detailed below.

#### Registering a service provider entry for FM on the identity provider.[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#id2 "Permalink to this headline")

The exact steps for this depend on the identity provider platform which you plan to connect to, and should be performed by your IdP administrator. This entry may also be called a “SAML application”.

You will typically need:

* an “Entity ID” which uniquely represents this FM instance on the IdP (sometimes also called “Application ID URI”).

This entity ID is allocated by the IdP, or chosen by the IdP admin.

* the SAML login URL for FM (“Assertion Consumer Service Endpoint”, which may also be called “Redirect URI”, “Callback URL”, or “ACS URL”).

This URL *must* be configured as

§ BASE_URL/api/saml-callback

where `BASE\_URL` is the URL through which FM users access this FM instance.

For example, if FM is accessed at https://fm.mycompany.corp, the SAML callback URL must be defined as

§ https://fm.mycompany.corp/api/saml-callback

Note that some SAML identity providers require the callback URL to use the HTTPS scheme.

As an additional step, you may also have to authorize your users to access this new SAML application at the IdP level.

Finally, you will need to retrieve the “IdP Metadata” XML document from the identity provider, which is required to configure FM (also called “Federation metadata document”).

#### Configuring FM for SAML authentication.[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#configuring-dku-app-for-saml-authentication "Permalink to this headline")

SAML configuration is in the “Settings / Login (LDAP, SSO) & Security / SSO” screen.

Select “Enable”, choose protocol “SAML” and fill up the associated configuration fields:

* IdP Metadata XML : the XML document describing the IdP connection parameters, which you should have retrieved from the IdP.

It should contain a <EntityDescriptor> record itself containing a <IDPSSODescriptor> record.

* SP entity ID : the entity ID (or application ID) which you have configured on the IdP in the step above

* SP ACS URL : the redirect URL (or callback URL) which you have configured on the IdP in the step above

Warning

You need to restart FM after any modification to the SAML configuration parameters.

##### Optional: configuring signed requests[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#optional-configuring-signed-requests "Permalink to this headline")

If your IdP requires it (this is generally not the case) you can configure FM to digitally sign SAML requests so that the IdP can authentify them.

For this, you need to provide a file containing a RSA or DSA keypair (private key plus associated certificate), which FM will use for signing, and provide the associated certificate to the IdP so that it can verify the signatures.

This file must be in the standard PKCS#12 format, and installed on the FM host. It can be generated using standard tools, as follows:

§ # Generate a PKCS12 file containing a self-signed RSA key and certificate with the "keytool" java command:

§ keytool -keystore <FILENAME>.p12 -storetype pkcs12 -storepass <PASSWORD> -genkeypair -keyalg RSA -dname "CN=DSS" -validity 3650

§ # Generate a PKCS12 file containing a self-signed RSA key and certificate with the openssl suite:

§ openssl req -x509 -newkey rsa:2048 -nodes -keyout <FILENAME>.key -subj "/CN=DSS" -days 3650 -out <FILENAME>.crt

§ openssl pkcs12 -export -out <FILENAME>.p12 -in <FILENAME>.crt -inkey <FILENAME>.key -passout pass:<PASSWORD>

You then need to complete the FM configuration as follows:

* check the “Sign requests” box

* Keystore file : absolute path to the PKCS#12 file generated above

* Keystore password : PKCS#12 file password

* Key alias in keystore : optional name of the key to use, in case the PKCS#12 file contains multiple entries

#### Choosing the login attribute[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#choosing-the-login-attribute "Permalink to this headline")

Upon successful authentication at the IdP level, the IdP sends to FM an assertion, which contains all attributes of the logged in user. Each attribute is named. You need to indicate which of the attributes contains the user’s login, that FM will use.

Note that FM logs all attributes received from the SAML server in the backend log file, which may help configuring this field.

If this field is left empty, FM will use the default SAML “name ID” attribute.

#### Login remapping rules[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#login-remapping-rules "Permalink to this headline")

Optionally, you can define one or several rewriting rules to transform the selected SAML attribute into the intended FM username. These rules are standard search-and-replace Java regular expressions, where `(...)` can be used to capture a substring in the input, and `$1`, `$2`… mark the place where to insert these captured substrings in the output. Rules are evaluated in order, each one working on the output of the previous one.

A standard use case for such rewriting rules would be to strip the domain part from email-address-like attributes. For example, configuring the following rule:

§ ([^@]*)@mydomain.com     ->     $1

would rewrite a SAML attribute `first.last@mydomain.com` into `first.last`, and do nothing on SAML attribute `first.last@otherdomain.com` (as the left-hand part of the rule would not match).

Warning

The Login remapping rules are evaluated in order. If you have multiple rules and their regexes overlap (ie ^(.\*)@mycompany.corp$ and ^(.\*)$), make sure the most specific one is defined first.

#### Testing SAML SSO[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-azure/sso.html#testing-saml-sso "Permalink to this headline")

* Configure SAML integration as described above

* Restart FM

* Access the FM URL from another browser or an anonymous window

* You should be redirected to the IDP for authentication, then back to the FM redirect URL, then to the FM homepage

* If login fails, check the logs for more information

Note

Once SSO has been enabled, if you access the root FM URL, SSO login will be attempted. If SSO login fails, you will only see an error.

You can still use the regular login/password login by going to the `/login/` URL on FM. This allows you to still log in using a local account if SSO login is dysfunctional.

If the SAML configuration is invalid (in particular if the IdP metadata XML is malformed) FM will not restart. You will need to manually disable SAML in the general-settings.json configuration file as described below.
