# Installing a Govern node[¶](https://doc.dataiku.com/dss/latest/installation/custom/govern-node.html#installing-a-govern-node "Permalink to this headline")

* Database requirements

* Installation

* Post-installation steps

You need to manually install a Govern node if you plan to use Dataiku governance capabilities. See Governance for more information.

The process of installing a Govern instance is very similar to a regular DSS installation, except for the database requirement below. Requirements and Installing a new DSS instance thus remain mostly valid.

## Database requirements[¶](https://doc.dataiku.com/dss/latest/installation/custom/govern-node.html#database-requirements "Permalink to this headline")

Govern is based on a Postgresql 12+ database for the storage of data. A dedicated database and user need to be created on the Postgresql instance for Govern:

§ CREATE USER <govern\_user> WITH ENCRYPTED PASSWORD '<govern\_pwd>';

§ CREATE DATABASE <govern\_db> OWNER <govern\_user>;

Where `<govern\_user>`, `<govern\_pwd>` and `<govern\_db>` are the values of your choice.

## Installation[¶](https://doc.dataiku.com/dss/latest/installation/custom/govern-node.html#installation "Permalink to this headline")

Unpack the kit, just like for a design node.

Then from the user account which will be used to run Dataiku Govern, enter the following command:

§ dataiku-dss-VERSION/installer.sh -t govern -d DATA_DIR -p PORT -l LICENSE_FILE

Where:

* `DATA\_DIR` is the location of the data directory that you want to use. If the directory already exists, it must be empty.

* `PORT` is the base TCP port to be used for Govern.

* `LICENSE\_FILE` is the path to your DSS license file.

In short, all installation steps are the same as for a design node, you simply need to add `-t govern` to the `installer.sh` command-line.

Note

Using Govern requires a specific DSS license. Please contact Dataiku for more information.

Dependencies handling, enabling startup at boot time, and starting the govern node, work exactly as for the design node.

## Post-installation steps[¶](https://doc.dataiku.com/dss/latest/installation/custom/govern-node.html#post-installation-steps "Permalink to this headline")

Before starting Govern, the Postgresql database connection needs to be setup in the settings. Edit `DATA\_DIR/config/dip.properties` and add the connection setting there:

§ psql.jdbc.url=jdbc:postgresql://<psql_host>:<psql_port>/<govern_db>?defaultSchema=<govern_schema>

§ psql.jdbc.user=<govern_user>

§ psql.jdbc.password=<govern_pwd>

Where `<govern\_user>`, `<govern\_pwd>` and `<govern\_db>` should be replaced with the value used previously to create the user and database for Govern. In case there’s a specific schema to be used for govern, it can be specified with `?defaultSchema=<govern\_schema>`. This is optional, and this part may be removed from the URL if default schema configured in the database is to be used. `<psql\_host>` and `<psql\_port>` should point to a runnning PostgreSQL server.

Finally, for bootstrapping the initial configuration of govern, issue the following command (only first time after kit installation):

§ DATA_DIR/bin/govern-admin init-db

Govern can then be started with the standard command:

§ DATA_DIR/bin/dss start
