# Deploying MLflow models[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/deploying.html#deploying-mlflow-models "Permalink to this headline")

If your experiment tracking run logs a MLflow model (using the log\_model function), it can be deployed directly from the UI.

* Deploying a model

* Pre-defining the information for deployment

* Deploying through the API

## Deploying a model[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/deploying.html#deploying-a-model "Permalink to this headline")

A model logged during an experiment tracking run may be deployed through the “Run details” screen, by clicking on the “Deploy” button in the models list.

A regression or classification model deployed through the GUI is always evaluated on a dataset in order to provide a performance analysis. This is the same as models trained in DSS. To deploy a model without evaluating it, either set the prediction type to “Other” or use the API.

Note

The classes must be specified in the same order as learned by the model. If not, for a multi-class model for example, when the model outputs the probabilities, they will be in the wrong order.

The original experiment id and run id are automatically recorded when adding an MLflow model as a new version of a saved model.

## Pre-defining the information for deployment[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/deploying.html#pre-defining-the-information-for-deployment "Permalink to this headline")

A lot of information that is not part of the MLflow model is required in order to deploy the MLflow model as a visual model in DSS. However, most of it can be pre-defined when the run is created, using a Dataiku extension to the MLflow API. This is especially handy when the model has many classes.

§ import dataiku

§ import mlflow

§ project = dataiku.api\_client().get\_default\_project()

§ managed\_folder = project.get\_managed\_folder('A\_MANAGED\_FOLDER\_ID')

§ mlflow\_extension = project.get\_mlflow\_extension()

§ with project.setup\_mlflow(managed\_folder=managed\_folder) as mlflow:

§ mlflow.set\_experiment("my\_experiment")

§ with mlflow.start\_run(run\_name="my\_run") as run:

§ # ...your MLflow code...

§ # setting information to make the deployment of a model trained in this run easier through the GUI

§ mlflow\_extension.set\_run\_inference\_info(run.\_info.run\_id, "MULTICLASS", [...list of classes...],

§ "code\_environment\_name", "target\_name")

These predefined parameters can be changed and overriden at deployment time except the model type.

## Deploying through the API[¶](https://doc.dataiku.com/dss/latest/mlops/experiment-tracking/deploying.html#deploying-through-the-api "Permalink to this headline")

A model can be deployed from an experiment tracking run using `dataikuapi.dss.mlflow.DSSMLflowExtension.deploy\_run\_model()`. Depending on the prediction type, the model will be evaluated during the deployment.

Most parameters are optional since `dataikuapi.dss.mlflow.DSSMLflowExtension.deploy\_run\_model()` will use by default what was set with `dataikuapi.dss.mlflow.DSSMLflowExtension.set\_run\_inference\_info()`.

§ mlflow\_ext.set\_run\_inference\_info(run.id, "BINARY\_CLASSIFICATION", list\_of\_classes, code\_env\_name, target\_column\_name)

§ mlflow\_extension.deploy\_run\_model(run.id, sm\_id, evaluation\_dataset)

Note

A model logged using the `mlflow.log\_model` API is a MLflow model. As such, it can be also be imported using `dataikuapi.dss.savedmodel.DSSSavedModel.import\_mlflow\_version\_from\_path()` or `dataikuapi.dss.savedmodel.DSSSavedModel.import\_mlflow\_version\_from\_managed\_folder()`. See Importing MLflow models.
