# MLflow Models[¶](https://doc.dataiku.com/dss/latest/mlops/mlflow-models/index.html#mlflow-models "Permalink to this headline")

MLflow is an open-source platform for managing the machine learning lifecycle.

MLflow offers a standard format for packaging trained machine learning models: MLflow Models.

You can import MLflow models in DSS, as DSS saved models. This allows you to benefit from all of the ML management capabilities of DSS on your existing MLflow models:

* Scoring datasets using a scoring recipe

* Deploying the model in a bundle on an automation node. See Production deployments and bundles

* Deploying the model for real-time scoring, using the API node

* Managing multiple versions of the models

* Evaluating the performance of a classification or regression model on a labeled dataset, including all results screens

* Comparing multiple models or multiple versions of the model, using Model Comparisons

* Analyzing performance and evaluating models on other datasets

* Analyzing drift on the MLflow model

* Governing the MLflow model using the Govern Node

Warning

**Experimental**: MLflow import is Experimental

* Importing MLflow models

* Using MLflow models in DSS

* Training MLflow models

* Limitations and supported versions
