# Visual recipes[¶](https://doc.dataiku.com/dss/latest/other_recipes/index.html#visual-recipes "Permalink to this headline")

In the Flow, recipes are used to create new datasets by performing transformations on existing datasets. The main way to perform transformations is to use the DSS “visual recipes”, which cover a variety of common analytic use cases, like aggregations or joins.

By using visual recipes, you don’t need to write any code to perform the standard analytic transformations.

Visual recipes are not the only way to perform transformations in the Flow. You can also use code recipes, for example with SQL or HiveQL queries, or with Python or R. These code recipes offer you complete freedom for analytic cases which are not covered by DSS visual recipes.

* Prepare: Cleanse, Normalize, and Enrich

* Sync: copying datasets

+ Schema handling

- Schema mismatch

+ Partitioning handling

+ Engines

* Grouping: aggregating data

+ Engines

* Window: analytics functions

+ Engines

+ Notes

* Distinct: get unique rows

+ Engines

* Join: joining datasets

+ Building a simple join

- Adding output datasets for unmatched rows

+ Filtering

+ Columns in the output

+ Engines

+ Database-specific notes

- Vertica

* Fuzzy join: joining two datasets

+ Fuzzy join prepare recipe processor

+ Building a simple join

+ Join conditions

+ Available distances

- Text columns

- Numeric columns

- Geopoint columns

+ Additional settings

- Output matching details

- Debug mode

+ Columns in the output

+ Engines

* Geo join: joining datasets based on geospatial features

+ Building a Geo join recipe in the flow

- Geometry storage types in DSS

- Compose join through matching conditions

+ Detailed recipe configuration steps

- Pre-filters

* geoContains() formula

- Join clause selection and matching conditions

- Geospatial matching operators

- Selected columns

- Post-Filtering

- Selected engine

- Enabling PostGIS extension in DSS

- Spatial indexes on SQL databases

+ Troubleshooting

- Side location conflict

* Splitting datasets

* Top N: retrieve first N rows

+ Engines

+ Notes

* Stacking datasets

* Sampling datasets

+ Filtering in DSS

- Rules based filters

* Conditions

* Groups

* Boolean operators

- Formula based filters

- SQL expression based filters

- ElasticSearch query string

* Sort: order values

+ Null values handling

+ Write ordering

* Pivot recipe

+ Defining the pivot table rows

+ Modality handling

- Computation of the list of modalities

- Cleaning of the modalities’ name

+ Aggregates

- Per row and modality

- Per row

+ Comparison to pivot processor

+ Pre-filtering

+ Examples

- Pivoting country net revenue by product

- Dummifying

* Push to editable recipe

+ Creating a Push to Editable recipe

* Download recipe

+ Creating a download recipe

+ Selecting files from the sources

- Mirroring rules

- Examples

+ Partitioned download recipes

- Example

* List Folder Contents

+ Output columns

+ Folder level mapping
