# Component: Project creation macros[¶](https://doc.dataiku.com/dss/latest/plugins/reference/project-creation-macros.html#component-project-creation-macros "Permalink to this headline")

Project creation build upon macros. You should thus be familiar with macros. For more information, please see Component: Macros

Please see Creating projects through macros for details on why you would use project creation macros. A user needs to be granted the Create projects using macros permission to use a project macro.

To start creating a project creation macro, we recommend that you use the plugin developer tools (see the tutorial for an introduction). In the Definition tab, click on “Add Python macro”, and enter the identifier for your new macro. You’ll see a new folder `python-runnables` and will have to edit the `runnable.py` and `runnable.json` files

A project macro is essentially a macro that will run *non-impersonated*, which allows it to have full control over DSS. It receives the identity of the end-user request Python function, thus allowing to perform logic based on this identity.

The project creation macro is responsible for actually creating the project, and setting up permissions.

In order to perform privileged operations, the project creation macro must obtain a privileged API key as shown in the example below.

## Example: Create project with a default code env[¶](https://doc.dataiku.com/dss/latest/plugins/reference/project-creation-macros.html#example-create-project-with-a-default-code-env "Permalink to this headline")

The `runnable.json` file looks like:

§ {

§ "meta": {

§ "label": "New project with code env",

§ "description": "Blabla",

§ "icon": "icon-puzzle-piece"

§ },

§ "impersonate": false,

§ "params": [

§ {

§ "name": "projectName",

§ "label": "Project name",

§ "type": "STRING",

§ "mandatory": true

§ },

§ {

§ "name": "pyCodeEnvName",

§ "label": "Python Code env name",

§ "type": "STRING",

§ "defaultValue": "python3"

§ }

§ ],

§ "resultType": "JSON\_OBJECT",

§ "macroRoles": [

§ {"type": "PROJECT\_CREATOR"}

§ ]

§ }

The two important parts here are:

* The macroRoles field defines this as a project creation macro

* The impersonate field makes the macro privileged

The “meta” and “params” fields are similar to all other kinds of DSS components.

The associated Python code is:

§ import dataiku

§ from dataiku.runnables import Runnable

§ from dataiku.runnables import utils

§ import json

§ class MyRunnable(Runnable):

§ def \_\_init\_\_(self, unused, config, plugin\_config):

§ # Note that, as all macros, it receives a first argument

§ # which is normally the project key, but which is irrelevant for project creation macros

§ self.config = config

§ def get\_progress\_target(self):

§ return None

§ def run(self, progress\_callback):

§ # Get the identity of the end DSS user

§ user\_client = dataiku.api\_client()

§ user\_auth\_info = user\_client.get\_auth\_info()

§ # Automatically create a privileged API key and obtain a privileged API client

§ # that has administrator privileges.

§ admin\_client = utils.get\_admin\_dss\_client("creation1", user\_auth\_info)

§ # The project creation macro must create the project. Therefore, it must first assign

§ # a unique project key. This helper makes this easy

§ project\_key = utils.make\_unique\_project\_key(admin\_client, self.config["projectName"])

§ # The macro must first perform the actual project creation.

§ # We pass the end-user identity as the owner of the newly-created project

§ print("Creating project")

§ admin\_client.create\_project(project\_key, self.config["projectName"], user\_auth\_info["authIdentifier"])

§ # Now, this macro sets up the default Python code environment, using the one specified by the user

§ print("Configuring project")

§ project = user\_client.get\_project(project\_key)

§ # Move the project to the current project folder, passed in the config as \_projectFolderId

§ project.move\_to\_folder(user\_client.get\_project\_folder(self.config['\_projectFolderId']))

§ settings = project.get\_settings()

§ settings.set\_python\_code\_env(self.config["pyCodeEnvName"])

§ settings.save()

§ # A project creation macro must return a JSON object containing a `projectKey` field with the newly-created

§ # project key

§ return json.dumps({"projectKey": project\_key})
