# Processors reference[¶](https://doc.dataiku.com/dss/latest/preparation/processors/index.html#processors-reference "Permalink to this headline")

This section provides a reference of all preparations processors in DSS. When available, this section includes links to Howto articles indicating concrete use of processors.

* Extract from array

* Fold an array

* Sort array

* Concatenate JSON arrays

+ Example

* Discretize (bin) numerical values

+ Options

* Change coordinates system

* Copy column

* Rename columns

* Concatenate columns

+ Example

+ Options

* Delete/Keep columns by name

+ Options

* Column Pseudonymization

+ What is pseudonymization ?

+ Input

+ Output

+ Pseudonymization Steps

+ Spark Execution

+ In-Database Execution

* Count occurrences

+ Matching modes

+ Normalization modes

* Convert currencies

+ Input currency

+ Output currency

+ Reference date

* Create if, then, else statements

+ Conditions

+ Actions

* Extract date elements

+ Options

+ Related resources

* Compute difference between dates

+ Options

* Format date with custom format

+ Options

+ Related resources

* Parse to standard date format

+ Options

+ Related resources

* Split e-mail addresses

* Enrich from French department

+ Available data

* Enrich from French postcode

+ Available data

* Enrich with build context

* Enrich with record context

* Extract ngrams

+ What are ngrams ?

+ Example use case

+ Output

+ Simplification

+ Advanced options

* Extract numbers

+ Options

* Fill column

* Fill empty cells with fixed value

+ Options

* Filter rows/cells on date

+ Options

* Filter rows/cells with formula

+ Options

* Filter invalid rows/cells

+ Options

+ Related resources

* Filter rows/cells on numerical range

+ Options

* Filter rows/cells on value

+ Options

* Find and replace

+ Options

+ Related resources

* Flag rows/cells on date range

+ Action

* Flag rows with formula

+ Options

+ Related resources

* Flag invalid rows

+ Columns selection

* Flag rows on numerical range

+ Columns selection

* Flag rows on value

+ Options

* Fold multiple columns

+ Example

+ Options

+ Related resources

* Fold multiple columns by pattern

+ Examples

+ Options

+ Related resources

* Fold object keys

* Formula

+ Usage examples

+ Getting help

* Fuzzy join with other dataset (memory-based)

+ Example use case

+ Requirements and limitations

+ Parameters

+ Output

* Generate Big Data

* Compute distance between geopoints

* Extract from geo column

* Geo-join

+ Example use case

+ Requirements

+ Parameters

+ Output

* Resolve GeoIP

* Create area around a geopoint

+ Action

+ Polygon creation options

+ Screenshots

* Create GeoPoint from lat/lon

* Extract lat/lon from GeoPoint

* Extract with grok

+ Overview

+ Syntax

- With a grok pattern

- With a regular expression (regex)

+ Found column

+ Some cases of application

+ Supported grok patterns

* Flag holidays

* Split invalid cells into another column

+ Example

* Join with other dataset (memory-based)

+ Behaviour details

+ Parameters

+ Output

* Extract with JSONPath

* Group long-tail values

+ Use case

* Compute the average of numerical values

+ Columns selection

+ Examples

* Translate values using meaning

* Normalize measure

* Merge long-tail values

* Move columns

* Negate boolean value

* Force numerical range

+ Options

* Generate numerical combinations

* Convert number formats

+ Options

* Nest columns

+ Example

* Unnest object (flatten JSON)

+ Example

+ Options

* Extract with regular expression

+ Options

+ Related resources

* Pivot

+ Example

- Input

- Process

- Details

* Python function

+ Operation modes (non-vectorized)

+ Python vs Jython mode

+ Vectorized operation

+ Operation modes (non-vectorized)

- Cell mode

- Row mode

- Rows mode

+ Operation modes (vectorized)

- Cell mode

- Row mode

- Rows mode

+ Help and code

+ Restrictions

* Split HTTP Query String

+ Output

+ Example

* Remove rows where cell is empty

+ Options

* Round numbers

+ Options

* Simplify text

+ Options

* Split and fold

* Split and unfold

* Split column

+ Examples

+ Options

* Switch case

+ Rules

+ Normalization modes

* Transform string

+ Options

* Tokenize text

+ Example use case

+ Output

+ Simplification

* Transpose rows to columns

* Triggered unfold

* Unfold

* Unfold an array

* Convert a UNIX timestamp to a date

+ Option

* Fill empty cells with previous/next value

+ Example

+ Options

* Split URL (into protocol, host, port, …)

* Classify User-Agent

* Generate a best-effort visitor id

* Zip JSON arrays

+ Example
