# Feature Store[¶](https://doc.dataiku.com/dss/latest/python-api/feature-store.html#feature-store "Permalink to this headline")

The public API allows you to:

* list feature groups `dataikuapi.dss.feature\_store.DSSFeatureStore.list\_feature\_groups()`

* check if a dataset is a feature group `dataikuapi.dss.dataset.DSSDatasetSettings.is\_feature\_group()`

* set/unset a dataset as a feature group: `dataikuapi.dss.dataset.DSSDatasetSettings.set\_feature\_group()`

See Feature Store for more information.

## Listing feature groups[¶](https://doc.dataiku.com/dss/latest/python-api/feature-store.html#listing-feature-groups "Permalink to this headline")

§ import dataiku

§ # if using API from inside DSS

§ client = dataiku.api\_client()

§ feature\_store = client.get\_feature\_store()

§ feature\_groups = feature\_store.list\_feature\_groups()

§ for feature\_group in feature\_groups:

§ print("{}".format(feature\_group.id))

Note

This will only display feature groups of projects on which the user has at least read permission

Note

Because of indexing latency, you have have to wait a few seconds before newly defined feature groups are visible

## (Un)setting a dataset as a Feature Group[¶](https://doc.dataiku.com/dss/latest/python-api/feature-store.html#un-setting-a-dataset-as-a-feature-group "Permalink to this headline")

§ import dataiku

§ # if using API from inside DSS

§ client = dataiku.api\_client()

§ project = client.get\_project('PROJECT\_ID')

§ ds = project.get\_dataset('DATASET\_ID')

§ ds\_settings = ds.get\_settings()

§ # pass False to undefine as Feature Group

§ ds\_settings.set\_feature\_group(True)

§ ds\_settings.save()

## API Reference[¶](https://doc.dataiku.com/dss/latest/python-api/feature-store.html#api-reference "Permalink to this headline")

*class* `dataikuapi.dss.feature_store.``DSSFeatureStore`(*client*)

`list_feature_groups`()

Get a list of feature groups on which the user has at least read permissions

* Returns: list of feature groups

* Return type: list of `dataikuapi.feature\_store.DSSFeatureGroupListItem`

*class* `dataikuapi.dss.feature_store.``DSSFeatureGroupListItem`(*client*, *project\_key*, *name*)

*property* `id`

`get_as_dataset`()

Gets the feature group as a dataset

* Returns: a handle on the dataset

* Return type: `dataikuapi.dss.dataset.DSSDataset`
