# The main FMClient class[¶](https://doc.dataiku.com/dss/latest/python-api/fleetmanager/fmclient.html#the-main-fmclient-class "Permalink to this headline")

The REST API Python client makes it easy to write client programs for the Fleet Manager REST API in Python. The REST API Python client is in the `dataikuapi` Python package.

The client is the entrypoint for many of the capabilities listed in this chapter.

## Creating a Fleet Manager client[¶](https://doc.dataiku.com/dss/latest/python-api/fleetmanager/fmclient.html#creating-a-fleet-manager-client "Permalink to this headline")

To work with the API, a connection needs to be established with Fleet Manager, by creating an `FMClient` object. Once the connection is established, the `FMClient` object serves as the entry point to the other calls.

Depending on your cloud provider, you will have to create the dedicated `FMClient`:

* a `FMClientAWS` for Amazon Web Services

* a `FMClientAzure` for Microsoft Azure

* a `FMClientGCP` for Google Cloud Platform

To connect you will need to provide the URL of your Fleet Manager server, and a key identifier and secret

§ import dataikuapi

§ key\_id = "<my key id>"

§ key\_secret = "<my key secret>"

§ client = dataikuapi.FMClientAWS("https://localhost", key\_id, key\_secret)

§ client = dataikuapi.FMClientAzure("https://localhost", key\_id, key\_secret)

§ client = dataikuapi.FMClientGCP("https://localhost", key\_id, key\_secret)

§ # client is now a FMClient and can perform all authorized actions.

§ # For example, list the DSS instances in the fleet for which you have access

§ client.list\_instances()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/python-api/fleetmanager/fmclient.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.fmclient.``FMClient`(*host*, *api\_key\_id*, *api\_key\_secret*, *tenant\_id='main'*, *extra\_headers=None*)

`get_cloud_credentials`()

Get the cloud credentials

* Returns: cloud credentials

* Return type: `dataikuapi.fm.tenant.FMCloudCredentials`

`get_cloud_tags`()

Get the tenant’s cloud tags

* Returns: tenant’s cloud tags

* Return type: `dataikuapi.fm.tenant.FMCloudTags`

`list_virtual_networks`()

List all virtual networks

* Returns: list of virtual networks

* Return type: list of `dataikuapi.fm.virtualnetworks.FMVirtualNetwork`

`get_virtual_network`(*virtual\_network\_id*)

Get a virtual network by its id

* Parameters: **virtual\_network\_id** (*str*) – the id of the network to retrieve

* Returns: the requested virtual network

* Return type: `dataikuapi.fm.virtualnetworks.FMVirtualNetwork`

`list_instance_templates`()

List all instance settings templates

* Returns: list of instance settings template

* Return type: list of `dataikuapi.fm.tenant.FMInstanceSettingsTemplate`

`get_instance_template`(*template\_id*)

Get an instance setting template template by its id

* Parameters: **template\_id** (*str*) – the id of the template to retrieve

* Returns: the requested instance settings template

* Return type: `dataikuapi.fm.instancesettingstemplates.FMInstanceSettingsTemplate`

`list_instances`()

List all DSS instances

* Returns: list of instances

* Return type: list of `dataikuapi.fm.instances.FMInstance`

`get_instance`(*instance\_id*)

Get a DSS instance by its id

* Parameters: **instance\_id** (*str*) – the id of the instance to retrieve

* Returns: the requested instance if any

* Return type: `dataikuapi.fm.instances.FMInstance`

`list_instance_images`()

List all available images to create new instances

* Returns: list of images, as a pair of id and label

*class* `dataikuapi.fmclient.``FMClientAWS`(*host*, *api\_key\_id*, *api\_key\_secret*, *tenant\_id='main'*, *extra\_headers=None*)

`new_virtual_network_creator`(*label*)

Instantiate a new virtual network creator

* Parameters: **label** (*str*) – The label of the network

* Return type: `dataikuapi.fm.virtualnetworks.FMAWSVirtualNetworkCreator`

`new_instance_template_creator`(*label*)

Instantiate a new instance template creator

* Parameters: **label** (*str*) – The label of the instance

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAWSInstanceSettingsTemplateCreator`

`new_instance_creator`(*label*, *instance\_settings\_template\_id*, *virtual\_network\_id*, *image\_id*)

Instantiate a new instance creator

* Parameters: * **label** (*str*) – The label of the instance
* **instance\_settings\_template** (*str*) – The instance settings template id this instance should be based on
* **virtual\_network** (*str*) – The virtual network where the instance should be spawned
* **image\_id** (*str*) – The ID of the DSS runtime image (ex: dss-9.0.3-default)

* Return type: `dataikuapi.fm.instances.FMAWSInstanceCreator`

*class* `dataikuapi.fmclient.``FMClientAzure`(*host*, *api\_key\_id*, *api\_key\_secret*, *tenant\_id='main'*, *extra\_headers=None*)

`new_virtual_network_creator`(*label*)

Instantiate a new virtual network creator

* Parameters: **label** (*str*) – The label of the network

* Return type: `dataikuapi.fm.virtualnetworks.FMAzureVirtualNetworkCreator`

`new_instance_template_creator`(*label*)

Instantiate a new instance template creator

* Parameters: **label** (*str*) – The label of the instance

* Return type: `dataikuapi.fm.instancesettingstemplates.FMAzureInstanceSettingsTemplateCreator`

`new_instance_creator`(*label*, *instance\_settings\_template\_id*, *virtual\_network\_id*, *image\_id*)

Instantiate a new instance creator

* Parameters: * **label** (*str*) – The label of the instance
* **instance\_settings\_template** (*str*) – The instance settings template id this instance should be based on
* **virtual\_network** (*str*) – The virtual network where the instance should be spawned
* **image\_id** (*str*) – The ID of the DSS runtime image (ex: dss-9.0.3-default)

* Return type: `dataikuapi.fm.instances.FMAzureInstanceCreator`

*class* `dataikuapi.fmclient.``FMClientGCP`(*host*, *api\_key\_id*, *api\_key\_secret*, *tenant\_id='main'*, *extra\_headers=None*)

`new_virtual_network_creator`(*label*)

Instantiate a new virtual network creator

* Parameters: **label** (*str*) – The label of the network

* Return type: `dataikuapi.fm.virtualnetworks.FMGCPVirtualNetworkCreator`

`new_instance_template_creator`(*label*)

Instantiate a new instance template creator

* Parameters: **label** (*str*) – The label of the instance

* Return type: `dataikuapi.fm.instancesettingstemplates.FMGCPInstanceSettingsTemplateCreator`

`new_instance_creator`(*label*, *instance\_settings\_template\_id*, *virtual\_network\_id*, *image\_id*)

Instantiate a new instance creator

* Parameters: * **label** (*str*) – The label of the instance
* **instance\_settings\_template** (*str*) – The instance settings template id this instance should be based on
* **virtual\_network** (*str*) – The virtual network where the instance should be spawned
* **image\_id** (*str*) – The ID of the DSS runtime image (ex: dss-9.0.3-default)

* Return type: `dataikuapi.fm.instances.FMGCPInstanceCreator`
