# Fleet Manager Instances[¶](https://doc.dataiku.com/dss/latest/python-api/fleetmanager/fminstances.html#fleet-manager-instances "Permalink to this headline")

Instances are the DSS instances that Fleet Manager will manage.

## Create an instance[¶](https://doc.dataiku.com/dss/latest/python-api/fleetmanager/fminstances.html#create-an-instance "Permalink to this headline")

§ import dataikuapi

§ key\_id = "<my key id>"

§ key\_secret = "<my key secret>"

§ # <Cloud vendor> is either AWS, Azure or GCP

§ client = dataikuapi.FMClient<Cloud vendor>("https://localhost", key\_id, key\_secret)

§ my\_template\_id = "ist-default"

§ my\_network\_id = "vn-default"

§ # create an instance

§ creator = client.new\_instance\_creator("My new designer", my\_template\_id, my\_network\_id, "dss-11.0.3-default")

§ dss = creator.create()

§ # provision the instance

§ status = dss.reprovision()

§ res = status.wait\_for\_result()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/python-api/fleetmanager/fminstances.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.fm.instances.``FMInstance`(*client*, *instance\_data*)

A handle to interact with a DSS instance. Do not create this directly, use `dataikuapi.fmclient.FMClient.get\_instance()` or

* `dataikuapi.fmclient.FMClientAWS.new\_instance\_creator()`

* `dataikuapi.fmclient.FMClientAzure.new\_instance\_creator()`

* `dataikuapi.fmclient.FMClientGCP.new\_instance\_creator()`

`get_client`()

Get a Python client to communicate with a DSS instance :return: a Python client to communicate with the target instance :rtype: `dataikuapi.dssclient.DSSClient`

`reprovision`()

Reprovision the physical DSS instance

* Returns: the Future object representing the reprovision process

* Return type: `dataikuapi.fm.future.FMFuture`

`deprovision`()

Deprovision the physical DSS instance

* Returns: the Future object representing the deprovision process

* Return type: `dataikuapi.fm.future.FMFuture`

`restart_dss`()

Restart the DSS running on the physical instance

* Returns: the Future object representing the restart process

* Return type: `dataikuapi.fm.future.FMFuture`

`save`()

Update the instance

`get_status`()

Get the physical DSS instance’s status

* Returns: the instance status

* Return type: `dataikuapi.fm.instances.FMInstanceStatus`

`delete`()

Delete the DSS instance

* Returns: the Future object representing the deletion process

* Return type: `dataikuapi.fm.future.FMFuture`

`get_initial_password`()

Get the initial DSS admin password.

Can only be called once

* Returns: a password for the ‘admin’ user.

`reset_user_password`(*username*, *password*)

Reset the password for a user on the DSS instance

* Parameters: * **username** (*string*) – login
* **password** (*string*) – new password

* Returns: the Future object representing the password reset process

* Return type: `dataikuapi.fm.future.FMFuture`

`replay_setup_actions`()

Replay the setup actions on the DSS instance

* Returns: the Future object representing the replay process

* Return type: `dataikuapi.fm.future.FMFuture`

`set_automated_snapshots`(*enable*, *period*, *keep=0*)

Set the automated snapshot policy for this instance

* Parameters: * **enable** (*boolean*) – Enable the automated snapshots
* **period** (*int*) – The time period between 2 snapshot in hours
* **keep** (*int*) – Optional, the number of snapshot to keep. Use 0 to keep all snapshots. Defaults to 0.

`set_custom_certificate`(*pem\_data*)

Set the custom certificate for this instance

Only needed when Virtual Network HTTPS Strategy is set to Custom Certificate

* Parameters: **pem\_data** (*str*) – The SSL certificate

`list_snapshots`()

List all the snapshots of this instance

* Returns: list of snapshots

* Return type: list of `dataikuapi.fm.instances.FMSnapshot`

`get_snapshot`(*snapshot\_id*)

Get a snapshot of this instance

* Parameters: **snapshot\_id** (*str*) – identifier of the snapshot

* Returns: Snapshot

* Return type: `dataikuapi.fm.instances.FMSnapshot`

`snapshot`(*reason\_for\_snapshot=None*)

Create a snapshot of the instance

* Returns: Snapshot

* Return type: `dataikuapi.fm.instances.FMSnapshot`

*class* `dataikuapi.fm.instances.``FMInstanceCreator`(*client*, *label*, *instance\_settings\_template\_id*, *virtual\_network\_id*, *image\_id*)

`with_dss_node_type`(*dss\_node\_type*)

Set the DSS node type of the instance to create. The default node type is DESIGN.

* Parameters: **dss\_node\_type** (`dataikuapi.fm.instances.FMNodeType`) – the type of the dss node to create.

* Return type: `dataikuapi.fm.instances.FMInstanceCreator`

`with_cloud_instance_type`(*cloud\_instance\_type*)

Set the machine type for the DSS Instance

* Parameters: **cloud\_instance\_type** (*str*) – the machine type to be used for the instance

* Return type: `dataikuapi.fm.instances.FMInstanceCreator`

`with_data_volume_options`(*data\_volume\_type=None*, *data\_volume\_size=None*, *data\_volume\_size\_max=None*, *data\_volume\_IOPS=None*, *data\_volume\_encryption=None*, *data\_volume\_encryption\_key=None*)

Set the options of the data volume to use with the DSS Instance

* Parameters: * **data\_volume\_type** (*str*) – Optional, data volume type
* **data\_volume\_size** (*int*) – Optional, data volume initial size
* **data\_volume\_size\_max** (*int*) – Optional, data volume maximum size
* **data\_volume\_IOPS** (*int*) – Optional, data volume IOPS
* **data\_volume\_encryption** (`dataikuapi.fm.instances.FMInstanceEncryptionMode`) – Optional, encryption mode of the data volume
* **data\_volume\_encryption\_key** (*str*) – Optional, the encryption key to use when data\_volume\_encryption\_key is FMInstanceEncryptionMode.CUSTOM

* Return type: `dataikuapi.fm.instances.FMInstanceCreator`

`with_cloud_tags`(*cloud\_tags*)

Set the tags to be applied to the cloud resources created for this DSS instance

* Parameters: **cloud\_tags** (*dict*) – a key value dictionary of tags to be applied on the cloud resources

* Return type: `dataikuapi.fm.instances.FMInstanceCreator`

`with_fm_tags`(*fm\_tags*)

A list of tags to add on the DSS Instance in Fleet Manager

* Parameters: **fm\_tags** (*list*) – Optional, list of tags to be applied on the instance in the Fleet Manager

* Return type: `dataikuapi.fm.instances.FMInstanceCreator`

*class* `dataikuapi.fm.instances.``FMAWSInstance`(*client*, *instance\_data*)

`set_elastic_ip`(*enable*, *elasticip\_allocation\_id*)

Set a public elastic ip for this instance

* Parameters: * **enable** (*boolan*) – Enable the elastic ip allocation
* **elasticip\_allocation\_id** (*str*) – AWS ElasticIP allocation ID

*class* `dataikuapi.fm.instances.``FMAWSInstanceCreator`(*client*, *label*, *instance\_settings\_template\_id*, *virtual\_network\_id*, *image\_id*)

`with_aws_root_volume_options`(*aws\_root\_volume\_size=None*, *aws\_root\_volume\_type=None*, *aws\_root\_volume\_IOPS=None*)

Set the options of the root volume of the DSS Instance

* Parameters: * **aws\_root\_volume\_size** (*int*) – Optional, the root volume size
* **aws\_root\_volume\_type** (*str*) – Optional, the root volume type
* **aws\_root\_volume\_IOPS** (*int*) – Optional, the root volume IOPS

* Return type: `dataikuapi.fm.instances.FMAWSInstanceCreator`

`create`()

Create the DSS instance

* Returns: a newly created DSS instance

* Return type: `dataikuapi.fm.instances.FMAWSInstance`

*class* `dataikuapi.fm.instances.``FMAzureInstance`(*client*, *instance\_data*)

`set_elastic_ip`(*enable*, *public\_ip\_id*)

Set a public elastic ip for this instance

* Parameters: * **enable** (*boolan*) – Enable the elastic ip allocation
* **public\_ip\_id** (*str*) – Azure Public IP ID

*class* `dataikuapi.fm.instances.``FMAzureInstanceCreator`(*client*, *label*, *instance\_settings\_template\_id*, *virtual\_network\_id*, *image\_id*)

`create`()

Create the DSS instance

* Returns: a newly created DSS instance

* Return type: `dataikuapi.fm.instances.FMAzureInstance`

*class* `dataikuapi.fm.instances.``FMGCPInstance`(*client*, *instance\_data*)

`set_public_ip`(*enable*, *public\_ip\_id*)

Set a public ip for this instance

* Parameters: * **enable** (*boolan*) – Enable the public ip allocation
* **public\_ip\_id** (*str*) – GCP Public IP ID

*class* `dataikuapi.fm.instances.``FMGCPInstanceCreator`(*client*, *label*, *instance\_settings\_template\_id*, *virtual\_network\_id*, *image\_id*)

`create`()

Create the DSS instance

* Returns: a newly created DSS instance

* Return type: `dataikuapi.fm.instances.FMGCPInstance`

*class* `dataikuapi.fm.instances.``FMInstanceEncryptionMode`(*value*)

An enumeration.

* 
`NONE` *= 'NONE'*:

* 
`DEFAULT_KEY` *= 'DEFAULT\_KEY'*:

* 
`TENANT` *= 'TENANT'*:

* 
`CUSTOM` *= 'CUSTOM'*:

*class* `dataikuapi.fm.instances.``FMInstanceStatus`(*data*)

A class holding read-only information about an Instance. This class should not be created directly. Instead, use `FMInstance.get\_status()`

*class* `dataikuapi.fm.instances.``FMSnapshot`(*client*, *instance\_id*, *snapshot\_id*, *snapshot\_data=None*)

A handle to interact with a snapshot of a DSS instance. Do not create this directly, use `FMInstance.snapshot()`

`get_info`()

Get the information about this snapshot

* Returns: a dict

`reprovision`()

Reprovision the physical DSS instance from this snapshot

* Returns: the Future object representing the reprovision process

* Return type: `dataikuapi.fm.future.FMFuture`

`delete`()

Delete the snapshot

* Returns: the Future object representing the deletion process

* Return type: `dataikuapi.fm.future.FMFuture`
