# Govern Artifacts[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-artifacts.html#govern-artifacts "Permalink to this headline")

Artifacts are all items in Dataiku Govern. Note: to learn more about them, go to the Dataiku Govern definitions page.

## List all artifact sign-offs[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-artifacts.html#list-all-artifact-sign-offs "Permalink to this headline")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # retrieve a specific artifact by its ID

§ artifact = client.get\_artifact('ar.1773')

§ # list all its sign-offs

§ signoffs = artifact.list\_signoffs()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/python-api/govern/govern-artifacts.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern.artifact.``GovernArtifact`(*client*, *artifact\_id*)

A handle to interact with an artifact on the Govern instance. Do not create this directly, use `get\_artifact()`

`get_definition`()

Retrieve the artifact definition and return it as an object.

* Returns: the corresponding artifact definition object

* Return type: `GovernArtifactDefinition`

`list_signoffs`()

List all the signoffs from the different steps of the workflow for this current artifact.

* Returns: the list of sign-offs

* Return type: list of `GovernArtifactSignoffListItem`

`get_signoff`(*step\_id*)

Get the sign-off for a specific step of the workflow for this current artifact.

* Parameters: **step\_id** (*str*) – id of the step to retrieve the sign-off from

* Returns: the corresponding `GovernArtifactSignoff`

`delete`()

Delete the artifact

* Returns: None

*class* `dataikuapi.govern.artifact.``GovernArtifactDefinition`(*client*, *artifact\_id*, *definition*)

The definition of an artifact. Do not create this class directly, instead use `get\_definition()`

`get_blueprint_version`()

Retrieve the blueprint version handle of this artifact

* Returns: the blueprint version handle

* Return type: `GovernBlueprintVersion`

`get_raw`()

Get the raw content of the artifact. This returns a reference to the artifact so changes made to the returned object will be reflected when saving.

* Return type: dict

`save`()

Save this settings back to the artifact.

*class* `dataikuapi.govern.artifact.``GovernArtifactSignoffListItem`(*client*, *artifact\_id*, *data*)

An item in a list of sign-offs. Do not create this directly, use `list\_signoffs()`

`get_raw`()

Get the raw content of the sign-off list item

* Returns: the raw content of the sign-off list item as a dict

* Return type: dict

`to_signoff`()

Gets the `GovernArtifactSignoff` corresponding to this sign-off object

* Returns: the sign-off object

* Return type: a `GovernArtifactSignoff`

*class* `dataikuapi.govern.artifact.``GovernArtifactSignoff`(*client*, *artifact\_id*, *step\_id*)

Handle to interact with the sign-off of a specific workflow step. Do not create this directly, use `get\_signoff()`

`get_definition`()

Get the definition of the last sign-off cycle of this specific workflow step.

* Returns: last sign-off cycle definition

* Return type: `GovernArtifactSignoffCycleDefinition`

`get_details`()

Get the last sign-off cycle details for this specific workflow step. This contains a list of computed users included in feedback groups and in the approval.

* Returns: sign-off cycle details

* Return type: `GovernArtifactSignoffCycleDetails`

`update_status`(*signoff\_status*, *users\_to\_notify=None*)

Change the status of the last cycle of the sign-off, takes as input the target status and optionally a list of users to notify. Only the users included in the groups of feedback and approval are able to give feedback or approval and can be notified, the complete list is available using: `get\_details()`. For the feedback, the users will be notified as part of a chosen group of feedback and the group must be specified.

* Parameters: * **signoff\_status** (*str*) – target feedback status to be chosen from: NOT\_STARTED, WAITING\_FOR\_FEEDBACK, WAITING\_FOR\_APPROVAL, APPROVED, REJECTED, ABANDONED
* **users\_to\_notify** (*list of dict*) – (Optional) List of the user to notify as part of the status change
(WAITING\_FOR\_FEEDBACK will involve the feedback groups, WAITING\_FOR\_APPROVAL will involve the final approval).
The list should be a list of dict containing two keys “userLogin” and “groupId” for each user to notify.
The “groupId” key is mandatory for feedback notification and forbidden for the final approval notification.
All users that are not in the sign-off configuration will be ignored.

* Returns: None

`add_feedback`(*group\_id*, *feedback\_status*, *comment=None*)

Add a feedback for a specific feedback group of the last cycle of the sign-off. Takes as input a group\_id (the feedback group id), a feedback status and an optional comment

* Parameters: * **group\_id** (*str*) – ID of the feedback group
* **feedback\_status** (*str*) – feedback status to be chosen from: APPROVED, MINOR\_ISSUE, MAJOR\_ISSUE
* **comment** (*str*) – (Optional) feedback comment

* Returns: None

`delegate_feedback`(*group\_id*, *users\_container*)

Delegate a feedback to specific users for the last cycle of the sign-off. Takes as input a group\_id (the feedback group that should have done the feedback originally), and an users container definition to delegate to.

* Parameters: * **group\_id** (*str*) – ID of the feedback group
* **users\_container** (*dict*) – a dict representing the users to delegate to.
Use `build()` to build a users container definition for a single user.

* Returns: None

`add_approval`(*approval\_status*, *comment=None*)

Add the final approval of the last cycle of the sign-off. Takes as input a feedback status and an optional comment

* Parameters: * **approval\_status** (*str*) – approval status to be chosen from: APPROVED, REJECTED, ABANDONED
* **comment** (*str*) – (Optional) approval comment

* Returns: None

`delegate_approval`(*users\_container*)

Delegate the approval to specific users for the last cycle of the sign-off. Takes as input an users container definition to delegate to.

* Parameters: **users\_container** (*str*) – a dict representing the users to delegate to.
Use `build()` to build a users container definition for a single user.

* Returns: None

*class* `dataikuapi.govern.artifact.``GovernArtifactSignoffCycleDefinition`(*client*, *artifact\_id*, *step\_id*, *definition*)

The definition of a sign-off cycle. Do not create this class directly, instead use `get\_definition()`

`get_raw`()

Get the raw content of the sign-off cycle definition.

* Return type: dict

*class* `dataikuapi.govern.artifact.``GovernArtifactSignoffCycleDetails`(*client*, *artifact\_id*, *step\_id*, *details*)

The details of a sign-off cycle. Do not create this class directly, instead use `get\_details()`

`get_raw`()

Get the raw content of the sign-off cycle details.

* Return type: dict
