# Plugins[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#plugins "Permalink to this headline")

The API offers methods to:

* Install plugins

* Uninstall plugins and list their usages

* Update plugins

* Read and write plugin settings

* Create and update plugin code envs

## Installing plugins[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#installing-plugins "Permalink to this headline")

### From a Zip file[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#from-a-zip-file "Permalink to this headline")

§ with open("myplugin.zip", "r") as f:

§ client.install\_plugin\_from\_archive(f)

See `install\_plugin\_from\_archive()` for more details.

### From the Dataiku plugin store[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#from-the-dataiku-plugin-store "Permalink to this headline")

§ future = client.install\_plugin\_from\_store("googlesheets")

§ future.wait\_for\_result()

See `install\_plugin\_from\_store()` for more details.

### From a Git repository[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#from-a-git-repository "Permalink to this headline")

§ future = client.install\_plugin\_from\_git("[email protected]:myorg/myrepo")

§ future.wait\_for\_result()

See `install\_plugin\_from\_git()` for more details.

## Uninstalling plugins[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#uninstalling-plugins "Permalink to this headline")

### Listing usages of a plugin[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#listing-usages-of-a-plugin "Permalink to this headline")

§ plugin = client.get\_plugin('my-plugin-id')

§ usages = plugin.list\_usages()

See `list\_usages()` for more details.

### Uninstalling a plugin[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#uninstalling-a-plugin "Permalink to this headline")

§ plugin = client.get\_plugin('my-plugin-id')

§ future = plugin.delete()

Plugin deletion fails if a usage is detected. It can be forced with `force=True`:

§ plugin = client.get\_plugin('my-plugin-id')

§ future = plugin.delete(force=True)

See `delete()` for more details.

## Managing code envs[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#managing-code-envs "Permalink to this headline")

§ plugin = client.get\_plugin("myplugin")

§ # Start creating the code env, and wait for it to be done

§ future = plugin.create\_code\_env()

§ result = future.wait\_for\_result()

§ # NB: If the plugin requires Python 3.6 for example, you will use something like:

§ # plugin.create\_code\_env(python\_interpreter="PYTHON36")

§ # Now the code env is created, but we still need to configure the plugin to use it

§ settings = plugin.get\_settings()

§ settings.set\_code\_env(result["envName"])

§ settings.save()

## Handling settings[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#handling-settings "Permalink to this headline")

§ plugin = client.get\_plugin("myplugin")

§ # Obtain the current settings

§ settings = plugin.get\_settings()

§ raw\_settings = settings.get\_raw()

§ # Modify the settings

§ # ...

§ # And save them back

§ settings.save()

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/plugins.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.plugin.``DSSPlugin`(*client*, *plugin\_id*)

A plugin on the DSS instance

`get_settings`()

Return the plugin-level settings

* Returns: a `DSSPluginSettings`

`create_code_env`(*python\_interpreter=None*, *conda=False*)

Starts the creation of the code env of the plugin

* Returns: a `dataikuapi.dssfuture.DSSFuture`

`update_code_env`()

Starts an update of the code env of the plugin

* Returns: a `dataikuapi.dss.future.DSSFuture`

`update_from_zip`(*fp*)

Updates the plugin from a plugin archive (as a file object)

* Parameters: **fp** (*object*) – A file-like object pointing to a plugin archive zip

`update_from_store`()

Updates the plugin from the Dataiku plugin store

* Returns: a `DSSFuture`

`update_from_git`(*repository\_url*, *checkout='master'*, *subpath=None*)

Updates the plugin from a Git repository. DSS must be setup to allow access to the repository.

* Parameters: * **repository\_url** (*str*) – URL of a Git remote
* **checkout** (*str*) – branch/tag/SHA1 to commit. For example “master”
* **subpath** (*str*) – Optional, path within the repository to use as plugin. Should contain a ‘plugin.json’ file

* Returns: a `DSSFuture`

`list_usages`(*project\_key=None*)

Get the list of usages of the plugin.

* Parameters: **project\_key** (*str*) – optional key of project where to look for usages. Default is None and looking in all projects.

* Returns: a `DSSPluginUsages`

`delete`(*force=False*)

Delete a plugin.

If not forced (default), pre-deletion checks will be run (as by `prepare\_delete()` and the deletion will be performed if and only if no usage of the plugin is detected and no error occurred during usages analysis.

* Parameters: **force** (*bool*) – if True, plugin will be deleted even if usages are found or errors occurred during usages

analysis. Default is False. :return: a `dataikuapi.dssfuture.DSSFuture`

`list_files`()

Get the hierarchy of files in the plugin (dev plugins only)

`get_file`(*path*)

Get a file from the plugin folder (dev plugins only)

* Parameters: **path** (*str*) – the path of the file, relative to the root of the plugin

* Returns: a file-like object containing the file’s content

`put_file`(*path*, *f*)

Update a file in the plugin folder (dev plugins only)

* Parameters: * **f** (*file-like*) – the file contents, as a file-like object
* **path** (*str*) – the path of the file, relative ot the root of the plugin

`rename_file`(*path*, *new\_name*)

Rename a file/folder in the plugin

* Parameters: * **path** (*str*) – the path of the file/folder, relative ot the root of the plugin
* **new\_name** (*str*) – the new name of the file/folder

`move_file`(*path*, *new\_path*)

Move a file/folder in the plugin

* Parameters: * **path** (*str*) – the path of the file/folder, relative ot the root of the plugin
* **new\_path** (*str*) – the new path relative at the root of the plugin

*class* `dataikuapi.dss.plugin.``DSSPluginSettings`(*client*, *plugin\_id*, *settings*)

The settings of a plugin.

`get_raw`()

Returns the raw settings object

`set_code_env`(*code\_env\_name*)

Sets the name of the code env to use for this plugin

`save`()

Saves the settings to DSS

*class* `dataikuapi.dss.plugin.``DSSPluginUsage`(*data*)

Information on a usage of an element of a plugin.

Has the following properties: - element\_kind: webapps, python-formats,… - element\_type: type name of the element - object\_id: id of the object using the plugin element. Can be None. - object\_type: type of the object using the plugin element. Can be None. - project\_key: project key of the object using the plugin element. Can be None.

*class* `dataikuapi.dss.plugin.``DSSMissingType`(*data*)

Information on a type not found while analyzing usages of a plugin.

Has the following properties: - missing type: the missing type - object\_id: id of the object depending on the missing type. Can be None. - object\_type: type of the object depending on the missing type. Can be None. - project\_key: project key of the object depending on the missing type. Can be None.

*class* `dataikuapi.dss.plugin.``DSSPluginUsages`(*data*)

Information on the usages of a plugin.

Has the following properties: - usages (list of `DSSPluginUsage`) - missing\_types (a list of `DSSMissingType`).

Some custom types may not be found during usage analysis, typically when a plugin was removed but is still used. This prevents some detailed analysis and may hide some uses. This information is provided in missing\_types.

`get_raw`()

Get plugin usages as a dictionary. :rtype: dict

`maybe_used`()

Returns true if the plugin maybe in use, as usages of the plugin were found, or errors encountered during analysis. :return:
