# Scenarios (in a scenario)[¶](https://doc.dataiku.com/dss/latest/python-api/scenarios-inside.html#scenarios-in-a-scenario "Permalink to this headline")

This is the documentation of the API for use in scenarios.

Warning

This API can only be used within a scenario in order to run steps and report on progress of the current scenario.

If you want to control scenarios, please see Scenarios

These functions can be used both for “Execute Python code” steps in steps-based scenarios, and for full Python scenarios

A quick description of Python scenarios can be found in Definitions. More details and usage samples are also available in Custom scenarios

The Scenario is the main class you’ll use to interact with DSS in your “Execute Python code” steps and Python scenarios.

*class* `dataiku.scenario.``Scenario`

Handle to the current (running) scenario.

`add_report_item`(*object\_ref*, *partition*, *report\_item*)

When used in the code of a custom step, adds a report item to the current step run

`get_message_sender`(*channel\_id*, *type=None*)

Gets a sender for reporting messages, using one of DSS’s Messaging channels

`get_build_state`()

Gets a handle to query previous builds

`get_trigger_type`()

Returns the type of the trigger that launched this scenario run

`get_trigger_name`()

Returns the name (if defined) of the trigger that launched this scenario run

`get_trigger_params`()

Returns a dictionary of the params set by the trigger that launched this scenario run

`set_scenario_variables`(*\*\*kwargs*)

Define additional variables in this scenario run

`get_previous_steps_outputs`()

Returns the results of the steps previously executed in this scenario run. For example, if a SQL step ran before in the scenario, and its name is ‘the\_sql’, then the list returned by this function will be like:

§ [

§ ...

§ {

§ 'stepName': 'the\_sql',

§ 'result': {

§ 'success': True,

§ 'hasResultset': True,

§ 'columns': [ {'type': 'int8', 'name': 'a'}, {'type': 'varchar', 'name': 'b'} ],

§ 'totalRows': 2,

§ 'rows': [

§ ['1000', 'min'],

§ ['2500', 'max']

§ ],

§ 'log': '',

§ 'endedOn': 0,

§ 'totalRowsClipped': False

§ }

§ },

§ ...

§ ]

Important note: the exact structure of each type of step run output is not precisely defined, and may vary  from a DSS release to another

`get_all_variables`()

Returns a dictionary of all variables (including the scenario-specific values)

`run_step`(*step*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Run a step in this scenario.

* Parameters: * **step** (*BuildFlowItemsStepDefHelper*) – Must be a step definition returned by `dataiku.scenario.BuildFlowItemsStepDefHelper.get\_step()`. (See code sample below)
* **asynchronous** (*bool*) – If True, the function launches a step run and returns immediately a `dataiku.scenario.step.StepHandle` object, on which the user will need to call `dataiku.scenario.step.StepHandle.is\_done()` or `dataiku.scenario.step.StepHandle.wait\_for\_completion()`. Otherwise the function waits until the step has finished running and returns the result of the step.
* **fail\_fatal** (*bool*) – If True, returns an Exception if the step fails.

Code sample:

§ # Code sample to build several datasets in a scenario step

§ from dataiku.scenario import Scenario

§ from dataiku.scenario import BuildFlowItemsStepDefHelper

§ # The Scenario object is the main handle from which you initiate steps

§ scenario = Scenario()

§ # Create a 'Build Flow Items' step.

§ step = BuildFlowItemsStepDefHelper("build\_datasets\_step")

§ # Add each dataset / folder / model to build

§ step.add\_dataset("dataset\_name\_1", "project\_key")

§ step.add\_dataset("dataset\_name\_2", "project\_key")

§ step.add\_dataset("dataset\_name\_3", "project\_key")

§ # Run the scenario step. The dependencies engine will parallelize what can be parallelized.

§ scenario.run\_step(step.get\_step())

`new_build_flowitems_step`(*step\_name=None*, *build\_mode='RECURSIVE\_BUILD'*)

Creates and returns a helper to prepare a multi-item “build” step.

* Returns: a `BuildFlowItemsStepDefHelper` object

`build_dataset`(*dataset\_name*, *project\_key=None*, *build\_mode='RECURSIVE\_BUILD'*, *partitions=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Executes the build of a dataset

* Parameters: * **dataset\_name** – name of the dataset to build
* **project\_key** – optional, project key of the project in which the dataset is built
* **build\_mode** – one of “RECURSIVE\_BUILD” (default), “NON\_RECURSIVE\_FORCED\_BUILD”, “RECURSIVE\_FORCED\_BUILD”, “RECURSIVE\_MISSING\_ONLY\_BUILD”
* **partitions** – can be given as a partitions spec, variables expansion is supported

`build_folder`(*folder\_id*, *project\_key=None*, *build\_mode='RECURSIVE\_BUILD'*, *partitions=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Executes the build of a folder

* Parameters: * **folder\_id** – the identifier of the folder (!= its name)
* **partitions** – Can be given as a partitions spec. Variables expansion is supported

`train_model`(*model\_id*, *project\_key=None*, *build\_mode='RECURSIVE\_BUILD'*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Executes the train of a saved model

* Parameters: **model\_id** – the identifier of the model (!= its name)

`build_evaluation_store`(*evaluation\_store\_id*, *project\_key=None*, *build\_mode='RECURSIVE\_BUILD'*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*)

Executes the build of a model evaluation store, to produce a model evalution

* Parameters: **evaluation\_store\_id** – the identifier of the model evaluation store (!= its name)

`invalidate_dataset_cache`(*dataset\_name*, *project\_key=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Invalidate the caches of a dataset

`clear_dataset`(*dataset\_name*, *project\_key=None*, *partitions=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Executes a ‘clear’ operation on a dataset

* Parameters: **partitions** – Can be given as a partitions spec. Variables expansion is supported

`clear_folder`(*folder\_id*, *project\_key=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Executes a ‘clear’ operation on a managed folder

`run_dataset_checks`(*dataset\_name*, *project\_key=None*, *partitions=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Runs the checks defined on a dataset

* Parameters: **partitions** – Can be given as a partitions spec. Variables expansion is supported

`compute_dataset_metrics`(*dataset\_name*, *project\_key=None*, *partitions=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Computes the metrics defined on a dataset

* Parameters: **partitions** – Can be given as a partitions spec. Variables expansion is supported

`synchronize_hive_metastore`(*dataset\_name*, *project\_key=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Synchronizes the Hive metastore from the dataset definition for a single dataset (all partitions).

`update_from_hive_metastore`(*dataset\_name*, *project\_key=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Update a single dataset definition (all partitions) from its table in the Hive metastore .

`execute_sql`(*connection*, *sql*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Executes a sql query

* Parameters: * **connection** – name of the DSS connection to run the query one
* **sql** – the query to run

`set_project_variables`(*project\_key=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Sets variables on the project. The variables are passed as named parameters to this function. For example:

s.set\_project\_variables(‘PROJ’, var1=’value1’, var2=True)

will add 2 variables var1 and var2 in the project’s variables, with values ‘value1’ and True respectively

`set_global_variables`(*step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Sets variables on the DSS instance. The variables are passed as named parameters to this function. For example:

s.set\_global\_variables(var1=’value1’, var2=True)

will add 2 variables var1 and var2 in the instance’s variables, with values ‘value1’ and True respectively

`run_global_variables_update`(*update\_code=None*, *step\_name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Run the code for updating the DSS instance’s variable defined in the global settings.

* Parameters: **update\_code** – custom code to run instead of the one defined in the global settings

`run_scenario`(*scenario\_id*, *project\_key=None*, *name=None*, *asynchronous=False*, *fail\_fatal=True*, *\*\*kwargs*)

Runs a scenario

* Parameters: * **scenario\_id** – identifier of the scenario (can be different from its name)
* **project\_key** – optional project key of the project where the scenario is defined (defaults to current project)
* **name** – optional name of the step
* **asynchronous** (*bool*) – If True, waits for result, else immediately returns a future. See `dataiku.scenario.run\_step()` for details.
* **fail\_fatal** (*bool*) – If True, returns an Exception if the step fails.. See `dataiku.scenario.run\_step()` for details.

Code sample:

§ # Code sample to run another scenario asynchronously without failing

§ from dataiku.scenario import Scenario

§ result = scenario.run\_scenario("ANOTHER\_SCENARIO", asynchronous=False, fail\_fatal=False)

§ print(result.get\_outcome())

`create_jupyter_export`(*notebook\_id*, *execute\_notebook=False*, *name=None*, *asynchronous=False*, *\*\*kwargs*)

Create a new export from a jupyter notebook

* Parameters: * **notebook\_id** – identifier of the notebook
* **execute\_notebook** – should the notebook be executed prior to the export

`package_api_service`(*service\_id*, *package\_id*, *transmogrify=False*, *name=None*, *asynchronous=False*, *\*\*kwargs*)

Make a package for an API service.

* Parameters: * **service\_id** – identifier of the API service
* **package\_id** – identifier for the created package
* **transmogrify** – if True, make the package\_id unique by appending a number (if not unique already)

*class* `dataiku.scenario.``BuildFlowItemsStepDefHelper`(*scenario*, *step\_name=None*, *build\_mode='RECURSIVE\_BUILD'*)

Helper to build the definition of a ‘Build Flow Items’ step. Multiple items can be added

`add_dataset`(*dataset\_name*, *project\_key=None*, *partitions=None*)

Add a dataset to build

* Parameters: * **dataset\_name** – name of the dataset
* **partitions** – partition spec

`add_folder`(*folder\_id*, *project\_key=None*, *partitions=None*)

Add a folder to build

* Parameters: **folder\_id** – identifier of a folder (!= its name)

`add_model`(*model\_id*, *project\_key=None*)

Add a saved model to build

* Parameters: **model\_id** – identifier of a saved model (!= its name)

`add_evaluation_store`(*evaluation\_store\_id*, *project\_key=None*)

Add a model evaluation store to build

* Parameters: **evaluation\_store\_id** – identifier of a model evaluation store (!= its name)

`get_step`()

Get the step definition
