# Workspaces[¶](https://doc.dataiku.com/dss/latest/python-api/workspaces.html#workspaces "Permalink to this headline")

You can interact with the Workspaces through the API.

* Basic operations

+ Listing workspaces

+ Modifying workspace

+ Deleting a workspace

* Adding and deleting the objects in a workspace

* Reference documentation

## Basic operations[¶](https://doc.dataiku.com/dss/latest/python-api/workspaces.html#basic-operations "Permalink to this headline")

### Listing workspaces[¶](https://doc.dataiku.com/dss/latest/python-api/workspaces.html#listing-workspaces "Permalink to this headline")

§ workspaces = client.list\_workspaces(True)

§ # Returns a list of DSSWorkspace

§ for workspace in workspaces:

§ # Access to main information in the workspace

§ print("Workspace key: %s" % workspace.workspace\_key)

§ print("Display name: %s" % workspace.get\_settings().display\_name)

§ print("Description: %s" % workspace.get\_settings().description)

§ print("Permissions: %s" % workspace.get\_settings().permissions) # Returns a list of DSSWorkspacePermissionItem

§ # You can also list the objects in a workspaces

§ print("Objects: %s" % workspace.list\_objects())

### Modifying workspace[¶](https://doc.dataiku.com/dss/latest/python-api/workspaces.html#modifying-workspace "Permalink to this headline")

§ workspace = client.get\_workspace("WORKSPACE\_KEY")

§ settings = workspace.get\_settings()

§ settings.permissions = [\*settings.permissions, DSSWorkspacePermissionItem.member\_user("LOGIN"), DSSWorkspacePermissionItem.contributor\_group("GROUP")]

§ settings.save()

### Deleting a workspace[¶](https://doc.dataiku.com/dss/latest/python-api/workspaces.html#deleting-a-workspace "Permalink to this headline")

§ workspace = client.get\_workspace("WORKSPACE\_KEY")

§ workspace.delete()

## Adding and deleting the objects in a workspace[¶](https://doc.dataiku.com/dss/latest/python-api/workspaces.html#adding-and-deleting-the-objects-in-a-workspace "Permalink to this headline")

§ workspace = client.get\_workspace("WORKSPACE\_KEY")

§ workspace\_objects = workspace.list\_objects()

§ for workspace\_object in workspace\_objects

§ workspace\_object.delete()

§ workspace.add\_object(client.get\_project("PROJECT\_KEY").get\_dataset("DATASET\_NAME")) # To add a dataset

§ workspace.add\_object(client.get\_project("PROJECT\_KEY").get\_wiki("WIKI").get\_article("ARTICLE"))  # To add an article

§ workspace.add\_object(client.get\_app("APP\_ID")) # To add an app

§ workspace.add\_object({"htmlLink": {"name": "Dataiku", "url": "https://www.dataiku.com/", "description": "Dataiku website"}}) # You can also specify the content as a dict, here we add a link

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/python-api/workspaces.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.workspace.``DSSWorkspace`(*client*, *workspace\_key*)

A handle to interact with a workspace on the DSS instance.

Do not create this class directly, instead use `dataikuapi.DSSClient.get\_workspace()`

`get_settings`()

Gets the settings of this workspace.

* Returns: a handle to read, modify and save the settings

* Return type: `DSSWorkspaceSettings`

`list_objects`()

List the objects in this workspace

* Returns: The list of the objects

* Return type: list of `DSSWorkspaceObject`

`add_object`(*object*)

Add an object to this workspace. Object can be of different shapes (`dataikuapi.dss.dataset.DSSDataset`, `dataikuapi.dss.wiki.DSSWikiArticle`, `dataikuapi.dss.app.DSSApp`, `DSSWorkspaceHtmlLinkObject` or a `dict` that contains the raw data)

`delete`()

Delete the workspace

This call requires Administrator rights on the workspace.

*class* `dataikuapi.dss.workspace.``DSSWorkspaceObject`(*workspace*, *data*)

A handle on an object of a workspace

Do not create this class directly, instead use `dataikuapi.dss.DSSWorkspace.list\_objects()`

`get_raw`()

`remove`()

Remove this object from the workspace

This call requires Contributor rights on the workspace.

*class* `dataikuapi.dss.workspace.``DSSWorkspaceSettings`(*workspace*, *settings*)

A handle on the settings of a workspace

Do not create this class directly, instead use `dataikuapi.dss.DSSWorkspace.get\_settings()`

`get_raw`()

*property* `display_name`

Get or set the name of the workspace

* Return type: `str`

*property* `color`

Get or set the background color of the workspace (using #xxxxxx syntax)

* Return type: `str`

*property* `description`

Get or set the description of the workspace

* Return type: `str`

*property* `permissions`

Get or set the permissions controlling who is a member, contributor or admin of the workspace

* Return type: list of `DSSWorkspacePermissionItem`

*property* `current_user_permissions`

Permissions of the current user (read-only)

* Return type: `DSSWorkspacePermissionItem`

`save`()

Save the changes made on the settings

This call requires Administrator rights on the workspace.

*class* `dataikuapi.dss.workspace.``DSSWorkspacePermissionItem`(*data*)

*classmethod* `admin_group`(*group*)

*classmethod* `contributor_group`(*group*)

*classmethod* `member_group`(*group*)

*classmethod* `admin_user`(*user*)

*classmethod* `contributor_user`(*user*)

*classmethod* `member_user`(*user*)

*property* `user`

Get user login

* Return type: `str`

*property* `group`

Get group name

* Return type: `str`

*property* `admin`

Get admin permission

* Return type: `boolean`

*property* `write`

Get write permission

* Return type: `boolean`

*property* `read`

Get read permission

* Return type: `boolean`
