# Security[¶](https://doc.dataiku.com/dss/latest/security/index.html#security "Permalink to this headline")

Note

**Please read the following note about some 3rd party vulnerabilities**

**OpenSSL**

After conducting internal research, we can confirm that Dataiku DSS is not vulnerable to the two OpenSSL vulnerabilities reported in November 2022 (CVE-2022-3602 and CVE-2022-3786). These vulnerabilities only affect OpenSSL 3, which no Dataiku product ships with.

If you are using Dataiku Cloud Stacks or Dataiku Online, no operation is required.

Please however note that if you are using Dataiku Custom setup, depending on your operating system, an operating system update may be needed. Please refer to your OS provider’s instructions.

**Text4Shell**

After conducting internal research, we can confirm that Dataiku DSS is not vulnerable to the “Text4Shell” vulnerability (CVE-2022-42889). Dataiku DSS (nor its bundled Spark) do not use the specific vulnerable function StringSubstitutor/StringLookup.

No mitigation nor upgrade is required. Dataiku keeps closely monitoring the security situation and will take action if a potential exploitation path appears.

**SpringShell**

After conducting internal research, we can confirm that Dataiku DSS is not vulnerable to the “SpringShell” vulnerability (CVE-2022-22965).

Dataiku DSS does not use the specific vulnerable spring-webmvc “data binding” feature.

Dataiku DSS is not vulnerable either to the unrelated Spring Cloud Function vulnerability (CVE-2022-22963), nor to the medium-severity CVE-2022-22950.

No mitigation action nor upgrade is required. Dataiku keeps closely monitoring the security situation based on information provided by Spring and by JFrog, as it does for all of its third-party dependencies, and will take action if a vulnerability is exploitable.

**Log4J**

After conducting internal research, we can confirm that Dataiku DSS is not vulnerable to the family of vulnerabilities regarding Log4J:

* “log4shell” vulnerabilities (CVE-2021-44228, CVE-2021-45046, CVE-2021-45105)

* JMSAppender and JMSSink vulnerabilities (CVE-2021-4104, CVE-2021-44832,CVE-2022-23302)

* JDBCAppender vulnerabilities (CVE-2022-23305)

* SocketAppender vulnerability (CVE-2019-17571)

* SMTPAppender vulnerability (CVE-2020-9488)

* Chainsaw vulnerability (CVE-2022-23307)

Dataiku does not use any of the vulnerable features.

No mitigation action nor upgrade is required. Dataiku keeps closely monitoring the security situation on log4j, as it does for all of its third-party dependencies, and will take action if a vulnerability is exploitable.

**Nginx LDAP reference**

Dataiku DSS does not use the Nginx LDAP reference implementation and is not vulnerable to the Nginx LDAP reference implementation security vulnerabilities

* Project Access

+ Discoverable projects

+ Private projects

+ Access Requests

* Main project permissions

+ Per-project group permissions

+ Project owner

+ Project visibility

+ Per-project single user permissions

+ Global group permissions

+ Multiple group membership

* Connections security

+ Securing access to connections

+ Reading details of a connection

+ Per-user credentials for connections

+ Personal connections

* User profiles

* Shared objects

+ Quick and managed sharing

+ Sharing objects between projects via managed sharing

+ Sharing objects between projects via quick sharing

+ Permissions on shared objects

+ Initiating an object-sharing request

+ Managing an object-sharing request

* Workspaces & dashboards authorizations

+ Scope

+ Adding objects to “Workspaces and dashboards authorizations” list

+ Details by object type

* User secrets

+ Entering user secrets

+ Using user secrets

* Audit Trail

* Govern Security: Roles and Permissions

+ User actions

+ Roles Assignment

+ Permissions

* Configuring LDAP authentication

+ Connecting to a LDAP directory

+ LDAP directory configuration templates

+ Using secure LDAP connections

+ Managing users

+ Managing groups

* Single Sign-On

+ Users database

+ OpenID Connect (OIDC)

+ SAML

+ SPNEGO / Kerberos

* Multi-Factor Authentication

* Passwords security

+ Local passwords database or not

+ Passwords complexity

+ Encryption of the local passwords database

+ 3rd party system credentials

* Advanced security options

+ Hiding error stacks

+ Hiding version info

+ Using secure cookies

+ Expiring sessions

+ Forcing a single session per user

+ Restricting visibility of groups and users

+ Redirecting to a custom URL after logout

+ Example general-settings.json file

+ Restricting exports

+ Setting security-related HTTP headers
