# Main project permissions[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#main-project-permissions "Permalink to this headline")

* Per-project group permissions

+ Admin

+ Read project content

+ Write project content

+ Share to workspaces

+ Export datasets

+ Run scenarios

+ Read dashboards

+ Write dashboards

+ Manage authorized objects

+ Manage shared objects

+ Execute app

* Project owner

* Project visibility

* Per-project single user permissions

* Global group permissions

+ Projects creation

+ Workspaces

+ Code execution

+ Code envs & Dynamic clusters

+ Advanced permissions

+ Write unisolated code: details

* Multiple group membership

DSS uses a groups-based model to allow users to perform actions through it.

The basic principle is that users are added to groups, and groups have permissions on each project.

## Per-project group permissions[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#per-project-group-permissions "Permalink to this headline")

On each project, you can configure an arbitrary number of groups who have access to this project. Adding permissions to projects is done in the Permissions pane of the Security menu.

Each group can have one or several of the following permissions. By default, groups don’t have any kind of access to a project.

### Admin[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#admin "Permalink to this headline")

This group may perform any action on the project, including:

* change the permissions and owner of the project

* create project bundles

This permission implies all other permissions.

### Read project content[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#read-project-content "Permalink to this headline")

This group may see the Flow, access the datasets, read the recipes, … More generally speaking, this group may read every configuration and data in this project.

This permission implies the “Read dashboards” permission

### Write project content[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#write-project-content "Permalink to this headline")

This group may read and write every configuration and data in this project. This includes the ability to create new datasets, recipes, …

This also includes the ability to run all jobs in this project.

Note

This permission is the “default” permission that you may want to give to your data team.

This permission implies the “Read project content”, “Read dashboards”, “Run scenarios” and “Write dashboards” permissions

### Share to workspaces[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#share-to-workspaces "Permalink to this headline")

This group may be able to share objects (Dashboards, Datasets, Wiki pages) to workspaces. Note that DSS administrators must separately grant the group permission to share content into workspaces, regardless of source project.

### Export datasets[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#export-datasets "Permalink to this headline")

This group may click on the “Download” button to retrieve the content of a dataset.

Warning

Disabling this permission removes the most obvious way to download whole datasets, but through various means, users who have at least “Read project content” will still be able to download datasets.

If you absolutely want your users not to be able to retrieve the full content of datasets, do not give them access to the project.

### Run scenarios[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#run-scenarios "Permalink to this headline")

This group may run scenarios. They may not run jobs that are not part of a scenario. Only scenarios that have a “Run As” user may be run by users who only have this permission.

This permission is generally not very useful without the “Read project content” permission.

### Read dashboards[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#read-dashboards "Permalink to this headline")

This group may read dashboards that have been created. They may not modify anything. They can only read dashboard insights that use project objects that have been shared with them using Workspaces & dashboards authorizations.

### Write dashboards[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#write-dashboards "Permalink to this headline")

This group may create their own dashboards, using the project objects that have been shared with them using Workspaces & dashboards authorizations.

This permission implies “Read dashboards”.

### Manage authorized objects[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#manage-authorized-objects "Permalink to this headline")

This group may modify which objects of the project are usable by dashboard-only users through the Workspaces & dashboards authorizations and accessible through a workspace.

This permission is generally not very useful without the “Read project content” permission. This permission is implied by the “Share to workspaces” permission.

The main use case for this permission is the following:

* A group of analysts and data scientists creates a Flow

* The data is of medium sensitivity so all dashboard users could use any of the Flow

* However, the dashboard users must not be able to break or modify the Flow

* Thus, the dashboard users (or a subgroup of them) has this permission to gain access to source datasets

### Manage shared objects[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#manage-shared-objects "Permalink to this headline")

This group may modify which objects of the project are available in other projects through the Shared objects.

This permission is generally not very useful without the “Read project content” permission.

The main use case for this permission is the following:

* A group of analysts and data scientists creates a Flow

* The data is of medium sensitivity so all or some DSS users should be able to reuse it on other projects

* However, the other projects’ users must not be able to break or modify the Flow

* Thus, a group of other project’s users has permission to go in the project, and “pick” datasets to use in other projects.

### Execute app[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#execute-app "Permalink to this headline")

This permission is only exposed on projects converted into a Dataiku application or an application-as-recipe.

This group may execute the corresponding application if the application is configured to be instantiated only by user with this permission. Else this permission is not needed.

## Project owner[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#project-owner "Permalink to this headline")

In addition to the per-group access, each project has a single user who “owns” the project. Being the owner of a project does not grant any additional permissions compared to being in a group who has Administrator access to this project.

This owner status is used mainly to actually grant access to a project to the user who just created it.

## Project visibility[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#project-visibility "Permalink to this headline")

It is possible to allow all users to access a project’s page displaying a limited amount of information about the project regardless of the users’ permissions. The information displayed in this case includes the project image, name, short description, owner, tags and status.

This feature can be enabled on a per-project basis or for all projects on the DSS instance on the **Administration > Settings > Misc** page. Discoverable projects appear in the Projects and Project Folders view, in the Catalog, and in the Search DSS results for all users making them easily discoverable. If a user doesn’t have access to a discoverable project, the project is denoted with a padlock symbol.

## Per-project single user permissions[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#per-project-single-user-permissions "Permalink to this headline")

In addition to the per-group access, on each project, you can configure an arbitrary number of individual users who have access to this project. Adding permissions to projects is done in the Permissions pane of the Security menu.

Each user can be granted the same kind of project permissions than groups above. This is useful for a non-administrator to give access to a project to some users individually, without the need for those users to belong to specific groups.

Warning

When using User Isolation in “DSS-managed ACL” mode, HDFS ACLs are not supported for individual user permissions on projects. See Hadoop Impersonation (HDFS, YARN, Hive, Impala).

## Global group permissions[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#global-group-permissions "Permalink to this headline")

In addition to the per-project permissions, groups can also be granted several global permissions that apply to all DSS.

These permissions are configured in the settings screen of the group.

* Administrator: members of a group with this permission can perform any action on DSS. DSS administrators are implicitly administrators of all DSS projects and may access any project, even without explicitly being granted access through a project-group grant.

### Projects creation[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#projects-creation "Permalink to this headline")

* Create projects: members of a group with this permission can create their own projects, using a blank project, project duplication of project import

* Create projects using macros: members of a group with this permission can create projects using a project creation macro

* Create projects using templates: members of a group with this permission can create projects using predefined templates (Dataiku samples and tutorials)

* “Write in root project folder”: members of a group with this permission can create folders and projects in the root folder, or move them to the root.

### Workspaces[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#workspaces "Permalink to this headline")

* Create workspaces: members of a group with this permission can create their own workspaces.

* Share to workspaces: members of a group with this permission can share objects to workspaces.

### Code execution[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#code-execution "Permalink to this headline")

* “Write isolated code”: members of a group with this permission can write code which will run with impersonated rights. This permission is only available when User Isolation Framework is enabled.

* “Write unisolated code”: members of a group with this permission can write code which will be executed with the UNIX privileges of the DSS UNIX user.

* “Create active Web content”: members of a group with this permission can author Web content that is able to execute Javascript when viewed by other users. This includes webapps, Jupyter notebooks and RMarkdown reports

### Code envs & Dynamic clusters[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#code-envs-dynamic-clusters "Permalink to this headline")

* “Manage all/own code envs”: members of a group with this permission can create and manage code environments; their own, those they’ve been given administrative access to, and even others, if given the ‘all’ permission.

* “Manage all/own clusters”: members of a group with this permission can create and manage clusters; their own, those they’ve been given administrative access to, and even others, if given the ‘all’ permission.

### Advanced permissions[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#advanced-permissions "Permalink to this headline")

* “Develop plugins”: members of a group with this permission can create and edit development plugins. Be aware that this permission could allow a hostile user to circumvent the permissions system.

* “Edit lib folders”: members of a group with this permission can edit the Python & R libraries and the static web resources in the DSS instance.

* “Create personal connections”: members of a group with this permission can create new connections to SQL, NoSQL, and Cloud storage.

* “View indexed Hive connections”: members of a group with this permission can use the DSS catalog to view indexed Hive connections.

* “Manage user-defined meanings”: members of a group with this permission can create instance-wide user-defined meanings, which will be accessible and usable by all DSS projects.

* “Create published API services”: members of a group with this permission can create an API service endpoint and publish it to a DSS API node through the DSS API Deployer.

### Write unisolated code: details[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#write-unisolated-code-details "Permalink to this headline")

For more information about enabling user isolation, see User Isolation Framework

#### Regular security mode[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#regular-security-mode "Permalink to this headline")

When UIF is disabled, DSS runs as a single UNIX user. All code which is written through the interface and executed locally is therefore ran with the permissions of this said user.

This includes notably:

* Python and R recipes

* Python and R notebooks

* PySpark and SparkR recipes

* Custom Python code in preparation recipes

* Custom Python code for machine learning models

No user (even with the Data Scientist profile) may write such code if they are not granted the “Write unisolated code” permission.

It is important to note that since the DSS Unix user has filesystem access to the DSS configuration, a user who has the “write unisolated code” permission is able to alter the DSS configuration, including security-related controls. This means that a hostile user with these privileges would be able to bypass DSS authorization mechanisms.

#### User isolation enabled[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#user-isolation-enabled "Permalink to this headline")

When UIF is enabled, most of the aforementioned code runs with end-user permissions. The “write unisolated code” permission only applies to the following specific locations where the code is not ran using end-user impersonation:

* Write custom partition dependency functions

* Write Python UDF in data preparation

## Multiple group membership[¶](https://doc.dataiku.com/dss/latest/security/permissions.html#multiple-group-membership "Permalink to this headline")

Users may belong to several groups. All permissions are cumulative: being a member of a group who has a given permission grants it, even if you are also member of a group who doesn’t have said permission.

DSS does not have negative permissions.
