# Interactive statistics[¶](https://doc.dataiku.com/dss/latest/statistics/index.html#interactive-statistics "Permalink to this headline")

An interactive statistics worksheet in Dataiku DSS provides a dedicated interface for performing exploratory data analysis (EDA) on datasets. Using this feature, you can:

* Summarize or describe data samples, e.g. using univariate analysis, bivariate analysis, distribution & curve fitting, and correlation matrices. This falls under the area of descriptive statistics.

* Draw conclusions from a sample dataset about an underlying population, e.g. using hypothesis testing. This falls under the area of inferential statistics.

* Visualize the structure of the dataset in a reduced number of dimensions, using principal component analysis. This falls under the area of dimensionality reduction.

This section of the reference documentation covers the DSS **Worksheet** and performing EDA tasks in DSS.

* The Worksheet Interface

+ Elements of a worksheet

+ Elements of a card

- Types of cards

* Univariate Analysis

+ Card options

- Histogram

* Numerical histogram

* Categorical histogram

- Box Plot

- Summary Stats

- Quantile Table

- Frequency Table

- Cumulative Distribution Function

* Bivariate Analysis

+ Card options

- Histogram

- Box Plot

- Mosaic Plot

- Scatter Plot

- Summary Stats

- Frequency Table

* Fit curves and distributions

+ Fit Distribution

+ 2D Fit Distribution

+ Fit curve

* Statistical Tests

+ One-sample tests

- Student *t*-test (one-sample)

- Sign test (one-sample)

- Shapiro-Wilk test

+ Two-sample tests

- Student *t*-test (two-sample)

- Median mood test (two-sample)

- Kolmogrov-Smirnov test (two-sample)

+ N-sample tests

- One-way ANOVA

- Median mood test (N-samples)

- Pairwise student *t*-test

- Pairwise median mood test

+ Categorical test

- Chi-square independence test

* Multivariate Analysis

+ Principal Component Analysis (PCA)

+ Correlation matrix

+ Scatter plot 3D

+ Parallel Coordinates Plot

* Time Series Analysis

+ Stationarity and unit root tests

- Augmented Dickey-Fuller (ADF) test

- Zivot-Andrews test

- Kwiatkowski-Phillips-Schmidt-Shin (KPSS) test

+ Trend

- Mann-Kendall trend test

+ Auto-correlation

- Auto-correlation function plot

- Partial auto-correlation function plot

- Durbin-Watson statistic

* Assisted Data Exploration
