# Concept: Webapps in Dataiku[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/visualization/webapps.html#concept-webapps-in-dataiku "Permalink to this headline")

Webapps are custom applications hosted by Dataiku DSS, which allow you to extend DSS’s visualization capabilities.

Webapps can be used to write advanced interactive visualizations or custom applicative frontends. Once created, webapps can then be embedded in dashboards or stay as they are.

There are several use cases where a webapp could be useful. For example:

* you want to use a custom interactive visualization that is not natively found in Dataiku DSS; or,

* you want to build an interactive dashboard that will update based on a given set of user inputs.

There are four main types of webapps that are fully hosted and can be written in Dataiku DSS:

* Standard webapps;

* Shiny webapps;

* Bokeh webapps;

* and Dash webapps (version 9.0 and above).

## Create a Webapp in Dataiku DSS[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/visualization/webapps.html#create-a-webapp-in-dataiku-dss "Permalink to this headline")

Webapps can be accessed from the top navigation menu of a project, by hovering over the Code menu and clicking “Webapps”.

To develop a webapp, you can start from scratch or from a template.

All of the four webapp types can be written in the Dataiku DSS webapp editor. Dataiku DSS allows you to write your code as you would outside of DSS, and it takes care of hosting your webapp, making it available to users with access to your project.

Let’s now walk through each of the webapp types and how you can create them.

## Standard Webapps[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/visualization/webapps.html#standard-webapps "Permalink to this headline")

Standard webapps are developed in HTML, CSS, and Javascript code. They can additionally contain a Python backend.

For Standard webapps, you need to write at least:

* the HTML of your frontend;

* CSS code if you want to edit its visual appearance;

* and Javascript code to make it interactive.

The Javascript code can use the DSS Javascript API to interact with datasets.

In addition, you can add a Python backend - a Python file which uses the Flask library.

To further customize your webapp, you can check the **Settings** tab for settings that you might want to change. You will be able to select a specific environment for your backend, and import some additional CSS & Javascript libraries.

## Shiny Webapps[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/visualization/webapps.html#shiny-webapps "Permalink to this headline")

Shiny webapps are written in R, both for the frontend and the backend, using the Shiny library.

You will have access to the “UI” part and the “Server” part. In the Server code, you can use the DSS R API without restriction, to interact with datasets, perform queries, or do all kinds of administrative tasks.

## Bokeh Webapps[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/visualization/webapps.html#bokeh-webapps "Permalink to this headline")

Bokeh webapps are written in Python, both for the frontend and the backend, using the Bokeh library.

For Bokeh, there is only one Python file to edit. You can use the DSS Python API without restriction.

## Dash Webapps[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/visualization/webapps.html#dash-webapps "Permalink to this headline")

Users of Dataiku 9.0 and above can also create Dash webapps, which use a Python library developed by Plotly.

For Dash webapps, the backend requires a code environment with the dash package installed. Unlike bokeh, the dash package is not preinstalled in the DSS builtin environment, which means that you would need to install the dash package yourself in an environment of your choice (or select an environment that already has it), and then configure your webapp to use this environment.

Webapps inherit the project environment by default, but you can also choose a different code environment specifically for the webapp. Once an appropriate code environment is selected (either at the project or webapp level), and the backend is started, you can begin writing your Dash webapp.

## Visual Webapps[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/visualization/webapps.html#visual-webapps "Permalink to this headline")

A code webapp can also be developed as a plugin and thus become available as a “visual webapp” for non-coders.

For visual webapps, the interface will prompt you to start creating the backend first. From then on, the process will depend on how the plugin was developed.

Below, you can see an example of a very simple visual webapp which can be run and edited by anyone from non-coders to coders.

In the **Settings** tab of this visual webapp, for example, users can select the input dataset for the visualization, as well as the columns to use for the X axis and the Y axis. Unlike code webapps, in a visual webapp, this can all be done through the visual UI, without having to use code.

Once the user selects the input parameters, they can visualize the webapp in the **View** tab, which displays an interactive scatter plot based on the user inputs.

## Webapps vs. Dataiku Applications[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/visualization/webapps.html#webapps-vs-dataiku-applications "Permalink to this headline")

Webapps may occasionally be confused with the concept of “Dataiku Applications”. Be aware that these are two different tools.

Webapps are custom interactive applications hosted by Dataiku DSS, which allow you to manipulate the Dataiku API with either Python, R or Javascript.

Dataiku Applications are a way to package a Dataiku project as a reusable application, prompting the user to enter an input to modify parameters, trigger some actions and get consumable results. The tool itself does not require coding skills and the application is created in a predefined interface from Dataiku DSS.

Learn more about the difference between Dataiku applications and webapps in this article.

## Publish Webapps[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/visualization/webapps.html#publish-webapps "Permalink to this headline")

Once your webapp is developed, you can publish it, either to a dashboard or to a public URL.

You can publish a webapp to a dashboard:

* from the dashboard itself, by clicking the green **”+”** icon, choosing the **“Webapps”** object, and selecting the webapp that you want to publish;

* or from the **Actions** menu of the webapp itself, by clicking **Publish** and selecting the dashboard that you want to publish your webapp on.

Access to the webapp will be allowed for logged-in Dataiku DSS users having at least the rights to “Read dashboards” on the DSS project (if the webapp is accessible to dashboard users).

Webapps can also be made public and accessible via a public URL. Making webapps public is a functionality restricted to Administrator users. You will learn more about Dataiku DSS admin privileges in another course.

This text summary introduced the concept of webapps and when to use them, the types of webapps hosted by Dataiku DSS, and how to publish them. Now you can create your own interactive visualizations!
