# Concept: Code Samples[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#concept-code-samples "Permalink to this headline")

In this lesson, we’ll take a look at some common ways you can create and use code samples, including:

* In notebooks and code recipes,

* In the Lab, and

* In a webapp

Dataiku provides code samples that are available to all projects on the same instance. Code samples are “starter” code–snippets that illustrate the steps to perform a specific task and help developers get started.

## Notebooks[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#notebooks "Permalink to this headline")

Each type of notebook in Dataiku allows you to use and add code samples. For example, in a Jupyter notebook, you can click **Code Samples** to start searching the code snippets available on your Dataiku instance.

Let’s say you want to find code samples that you can use to merge Pandas DataFrames. To do this, search for``dataframe`` to view results where this term is either part of the title or description.

You can also search by tag. For example, you can select the tags, “Pandas”, “Combine”, and “Dataframe”, to help narrow down your search results.

Dataiku displays the code sample, including any variations, along with its documentation.

Once you insert this code, it becomes part of your script.

### Adding a Code Sample[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#adding-a-code-sample "Permalink to this headline")

You can add code samples wherever code samples are found. For example, you can add a new code sample in the code samples of your notebook.

To do this, click **+ Add Your Own**, then type a descriptive title and description (both are searchable). Then, apply tags to make it even more discoverable by others. The default option is “share with other users”.

You can add additional information that might help others understand the purpose and usage of your code snippet.

Then, finally, add the core code of your code sample including any variants.

Code variants make sense when it isn’t possible to create a single code snippet that covers all use cases.

Dataiku makes your code sample immediately available to all users on the same instance.

## Code Recipes[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#code-recipes "Permalink to this headline")

In code recipes, you can find Code Samples by visiting the **Code** tab of the recipe.

Code samples work much the same way as in your notebook. For example, you can enter a search term and apply tags to narrow down the search. You can then select to insert the snippet into your code.

## Visual Machine Learning in the Lab[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#visual-machine-learning-in-the-lab "Permalink to this headline")

Visual Machine Learning in the Lab is another place you can use and create code samples.

### Custom Algorithms[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#custom-algorithms "Permalink to this headline")

Let’s start by looking at custom algorithms.

When designing your machine learning model, you can select to add a custom Python model in the **Custom Python model** window. From there, you can add a custom Python model code sample.

### Custom Model Metrics[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#custom-model-metrics "Permalink to this headline")

In visual ML, you can also define your own Custom Model Metrics.

Once defined, Dataiku will use this custom metric to decide which model is best. In other words, it is the metric for which the model hyperparameters will be optimized.

Although there are no default code samples for custom metrics, you can create your own that will be available to you and your team.

When creating custom model metrics, Dataiku gives you access to predefined functions that you can configure, such as “Lift” and “Cost matrix”.

### Custom Preprocessing of Text Features[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#custom-preprocessing-of-text-features "Permalink to this headline")

Another way to use code samples in your visual analysis is custom preprocessing of text features.

When handling a text feature, you can select custom preprocessing. Then, you can write your own code to handle the preprocessing of the values in this text column.

One requirement is that your code must create a “processor” object that will be responsible for processing the data.

Once your custom processing code is defined, you will have the ability to save it as a code sample.

## Webapps[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#webapps "Permalink to this headline")

Finally, let’s look at webapps.

Code samples make it easier to reproduce a webapp from one project to another.

You can use code samples when working with Bokeh, Shiny, and standard webapps.

Code Samples are found in the **Edit** mode of the webapp.

For example, you could insert a code sample that can be used to “Add a Button”.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/code-samples-summary.html#what-s-next "Permalink to this headline")

Check out the other lessons included in this course!

You might also be interested in visiting Code in Dataiku where you can learn more about code notebooks and recipes, or Custom ML Models where you’ll learn more about custom preprocessing and custom modeling using visual ML.
