# Concept: Shared Code Libraries[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/shared-code-libraries-summary.html#concept-shared-code-libraries "Permalink to this headline")

In this lesson, we’ll discuss:

* Working with the project library editor,

* Using code from the project library within the same project, and

* Sharing the project library with other projects.

The project’s code library is where files are stored. The library editor is used to create folders and upload or add files. In the example below, we’ve added a code module that writes data from a Dataiku dataset into an Excel workbook. The file resides under the Python source folder.

This DataFrame to Excel function is now available to use in code capacities including recipes and notebooks. We can access this reusable code from within our project and share it with other projects. Let’s first look at how we can use this code from within our project.

Let’s say we want to use this function in a Python recipe. To do this, we’ll use an import statement that lets Dataiku know we want to import the “DataFrame\_to\_xlsx” function from the file, “to\_xlsx”.

Now let’s look at how we can share this code with other projects on the same Dataiku instance. To demonstrate this concept, we’ll share the project library that was created in project A with project B.

To do this, we start by copying the project key from the URL of the parent project, project A. Then in the library editor of project B, we’ll find the “external-libraries.json” file. We edit the “import Libraries From Project” list, adding the project key from Project A, enclosing the project key in brackets.

The project library from project A is now available to project B. In Project B, we can now import the DataFrame to Excel function in our Python recipe the same way that we used it in Project A.

Note

You only have to import a project library once. If changes are made to the project library in the parent project, the changes are available to all child projects. The only time a change in the parent project would not be usable is if a user inadvertently changes the name of a shared file or function.

When we share libraries between projects, and we plan to deploy our project to the automation node, the parent project must be deployed so that the project library is available.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/courses/advanced-code/shared-code/shared-code-libraries-summary.html#whats-next "Permalink to this headline")

In upcoming lessons in this course, we’ll discuss these concepts in more detail. We’ll even look at ways we can import code from a Git repository into our project library.
