# Introduction to Deep Learning with Code[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/deep-learning-code/introduction.html#introduction-to-deep-learning-with-code "Permalink to this headline")

You can define a Deep Learning architecture using the Keras library to build a custom model in Dataiku’s Visual Machine Learning tool. You can then train, deploy, and score the model like any other model created and managed in Dataiku DSS.

Deep learning offers extremely flexible modeling of the relationships between a target and its input features, and is used in a variety of challenging applications, such as image processing, text analysis, and time series, in addition to models for structured data.

## Objectives[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/deep-learning-code/introduction.html#objectives "Permalink to this headline")

This how-to walks through the Deep Learning interface in Dataiku DSS, using a simple multilayer perceptron (MLP) for classification.

## Prerequisites[¶](https://knowledge.dataiku.com/latest/courses/advanced-analytics/deep-learning-code/introduction.html#prerequisites "Permalink to this headline")

You should have some experience with Visual Machine Learning in Dataiku. We’ll use the project from that tutorial.

You should have some familiarity with Keras. While building a deep learning model in Dataiku requires some comfort with coding, its inclusion in the Visual ML tool means that the model lifecycle is managed by Dataiku.

You will need access to a code environment with the necessary libraries. When creating a code environment, you can add sets of packages on the **Packages to Install** tab. Choose the Visual Deep Learning package set that corresponds to the hardware you’re running on.
