# Running Jobs with Partitioned Datasets[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#running-jobs-with-partitioned-datasets "Permalink to this headline")

When we build a Flow with partitioned datasets, we are deciding what we want to build, and then Dataiku decides what to run to fulfill our request.

## Partition Dependencies[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#partition-dependencies "Permalink to this headline")

To tell Dataiku what we want to build, we configure the following elements:

* The input identifier,

* The partition dependency function type, and

* the target identifier.

Let’s look at a few ways we could configure partition dependencies.

### Time-Based Dimension: Function Type “Equals”[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#time-based-dimension-function-type-equals "Permalink to this headline")

In this example, our input dataset is partitioned by “Day” using the column, *purchase\_date*. Our goal is to build an output dataset made up of specific partitions using the Join recipe.

Our partition dependency function type is “Equals” because we want Dataiku to compute the target partition using the same partition identifier value, “Day”, as the input partition.

In addition, we want to build only specific partitions. Our target identifier is a string, `2017-12-20,2017-12-21,2017-12-22,2017-12-23`, identifying the “days” we want to build.

### Time-Based Dimension: Function Type “Since the Beginning of the Month”[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#time-based-dimension-function-type-since-the-beginning-of-the-month "Permalink to this headline")

In this example, we are again using a Join recipe to build a dataset using the *purchase\_date* dimension.

This time, we want the output dataset to contain all the partitions “Since beginning of month.”

In addition, we’ve targeted a specific date, `2018-04-30`.

We could also use a scenario to configure the target identifier using a keyword, such as “PREVIOUS\_DAY.”

### Discrete-Based Dimension: Function Type “Equals”[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#discrete-based-dimension-function-type-equals "Permalink to this headline")

In this example, we are using the Window recipe to build a dataset using the *merchant\_subsector\_description* dimension.

Our partition dependency function type is “Equals” because we want Dataiku to compute the target partition using the same partition identifier value, `merchant\_subsector\_description`, as the input partition.

In addition, we’ve targeted specific partitions, `gas/internet/insurance`.

In these examples, we specified what we want to build by configuring the partition dependencies.

Let’s look at three examples to demonstrate how a partitioned job runs.

## Job Behavior and Activities[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#job-behavior-and-activities "Permalink to this headline")

### Request One Partition from Three Input Partitions: Function Type “Equals”[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#request-one-partition-from-three-input-partitions-function-type-equals "Permalink to this headline")

In this example, our input dataset contains three partitions. We are requesting one output partition. To build the requested partition, Dataiku runs one activity. A job can have more than one activity, and an activity is the run of a recipe on a specific partition.

We’ve selected “Equals” as the partition dependency function type. The dimension is already defined because there is only one partition dimension in the input dataset to choose from. If our input dataset was partitioned by more than one dimension, Dataiku would display more than one input identifier option.

In the Recipe Run options, we’ll specify the target identifier, `2020-11-04`, before running the recipe.

Before Dataiku can run the job, it does the following:

* It starts with the dataset that needs to be built.

* It then looks at which recipe is upstream to gather the partition dependency information.

Once Dataiku computes the partition dependencies, it can then build the Flow. Since we requested to build one partition, there is one activity.

### Request Three Partitions from Three Input Partitions: Function Type “Equals”[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#request-three-partitions-from-three-input-partitions-function-type-equals "Permalink to this headline")

If we were to request three partitions, instead of one, using “equals”, with the same three input partitions, Dataiku would run three activities–one per partition–to build three partitions.

### Request One Partition from Several Input Partitions: Function Type “Since Beginning of Month”[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#request-one-partition-from-several-input-partitions-function-type-since-beginning-of-month "Permalink to this headline")

To use an example with a different type of mapping, let’s say we want to request one partition, using “Since beginning of month”. Using `2020-11-04` as the requested partition gives us four total input partitions.

To build this job, Dataiku runs one activity to build one output partition that combines the four input partitions.

Even if there were 30 upstream partitions, Dataiku would still only generate a single, downstream partition with this particular mapping.

## Building a Flow with Multiple Partitioned Datasets[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#building-a-flow-with-multiple-partitioned-datasets "Permalink to this headline")

Let’s consider how Dataiku might build a Flow where we have four datasets and three recipes.

Each dataset in our Flow is partitioned by “Day”. In this diagram, recipes are represented by letters of the alphabet while datasets are numbered. The goal is to build the partition “2020-01-03” in the last dataset in the Flow.

To do this, Dataiku starts from the last dataset and works backwards to compute the partition dependencies. For example, since recipe “f” is upstream of the final partition to be built, its partition dependencies are computed first.

Once all the partition dependencies are computed, the job activities begin using a “forward” execution in the Flow. Starting with the second dataset, the first job activity builds the partitions needed to build the partition requested, which, in turn, builds an output dataset that is needed downstream.

A third job activity builds the partitions needed to build the output of recipe “f”.

## Exploring a Flow with Multiple Partitioned Datasets[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#exploring-a-flow-with-multiple-partitioned-datasets "Permalink to this headline")

### Build Configuration[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#build-configuration "Permalink to this headline")

When we select to build a dataset in the Flow or run a recipe, Dataiku displays the “build configuration”. We can choose between a non-recursive or a recursive job–the behavior remains the same. The difference is that Dataiku is asking us to select the partition or partitions we want to work with. This is similar to the option displayed in a visual recipe’s configuration window.

When we view a partitioned job, we can see the activities. Each activity informs us about the partition it was building.

### Build a Partitioned Model[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#build-a-partitioned-model "Permalink to this headline")

When building a machine learning model, we can use the target panel of the design pane to tell Dataiku to use a partitioned dataset. Using this feature, we can train our machine learning models on a specific partition of the dataset.

In addition, using the Train/Test Set Panel of the Design Pane, we can subsample the set on which the splitting will be performed. Using this feature, we can decide to use all partitions or a specific partition.

## What’s next?[¶](https://knowledge.dataiku.com/latest/courses/advanced-partitioning/running-job-with-partitioned-datasets-summary.html#what-s-next "Permalink to this headline")

Visit the Dataiku product documentation to find out more about working with partitions, including partition identifiers, and partition dependencies. For examples of ways to use keywords, visit Variables in scenarios.
