# Wrap Up: APIs in Dataiku[¶](https://knowledge.dataiku.com/latest/courses/apis/course-complete.html#wrap-up-apis-in-dataiku "Permalink to this headline")

## Congratulations![¶](https://knowledge.dataiku.com/latest/courses/apis/course-complete.html#congratulations "Permalink to this headline")

You’ve just completed the **APIs in Dataiku** course, where you gained experience programmatically interacting with Dataiku objects and the instance.

Here are a few of the main takeaways from this course:

* Dataiku offers APIs to enable coders to more easily interact with Dataiku objects and the instance itself, purely through code.

* The **dataiku package** enables low-level interaction with Dataiku objects, such as datasets, managed folders, and saved models.

* The **public API** can accomplish a wide variety of administration and automation tasks, such as:

>

>

> 	+ managing users, groups, and connections;

> 	+ investigating the status of jobs, notebooks, and scenarios, or environments; and

> 	+ automating the machine learning model lifecycle.

>

* The public API is an HTTP REST API, but it is also available as a Python API client, which is the recommended way to interact with this API. The wrapper for the public REST API is the **dataikuapi Python package**, but in most cases you’ll be using it “under the hood”.

* No matter whether you are calling the dataiku package or the public API, the choice of coding within Dataiku DSS or outside of it remains yours. The APIs are available “out-of-the-box” inside of Dataiku, but you can also import these packages outside of Dataiku.

## Learn More[¶](https://knowledge.dataiku.com/latest/courses/apis/course-complete.html#learn-more "Permalink to this headline")

Now that you have completed this course, you may wish to consult the documentation on the Python APIs for more information. When ready, continue progressing on your Developer learning path!
