# Concept: Datasets in DSS[¶](https://knowledge.dataiku.com/latest/courses/basics/create-dataset/concept-dataset.html#concept-datasets-in-dss "Permalink to this headline")

Tip

This content is also included in the free Dataiku Academy course, Basics 101, which is part of the Core Designer learning path. Register for the course there if you’d like to track and validate your progress alongside concept videos, summaries, hands-on tutorials, and quizzes.

A dataset in Dataiku can be any piece of data in a tabular format. Examples of possible Dataiku datasets include:

* an uploaded Excel spreadsheet

* an SQL table

* a folder of data files on a Hadoop cluster

* a CSV file in the cloud, such as an Amazon S3 bucket

Dataiku will represent all of these examples in the Flow of a project with a blue square with the icon matching the type of the source dataset.

Regardless of the origins of the source dataset, the methods for interacting with any Dataiku dataset are the same. You can read, write, visualize, and manipulate datasets within Dataiku using the same methods. You’ll find the same Explore, Charts, and Statistics tabs, along with the same sets of visual, code and plugin recipes.

This is possible because Dataiku decouples data processing logic (such as recipes in the Flow) from the underlying storage infrastructure of a dataset.

With the exception of directly uploading files to Dataiku (as done in this Basics tutorial), the Dataiku server does not need to ingest the entire dataset to create its representation in Dataiku. Generally, creating a dataset in Dataiku means that the user merely informs Dataiku of how it can access the data from a particular connection. Dataiku remembers the location of the original external or source datasets. The data is not copied into Dataiku. Rather, the dataset in Dataiku is a view of the data in the original system. Only a sample of the data, as configured by the user, is transferred via the browser.

The following example Flow includes different types of datasets, such as an uploaded file, a table in a SQL database, and cloud storage datasets.

## Learn More[¶](https://knowledge.dataiku.com/latest/courses/basics/create-dataset/concept-dataset.html#learn-more "Permalink to this headline")

In this lesson, you learned about datasets used in a Dataiku project. Continue learning about the Basics of Dataiku by visiting Concept: Connections.
