# Hands-On Tutorial: Explore Your Data[¶](https://knowledge.dataiku.com/latest/courses/basics/explore-data/explore-your-data.html#hands-on-tutorial-explore-your-data "Permalink to this headline")

Note

This lesson is a continuation of the Basics 101 hands-on tutorial.

The **Explore** tab of a dataset provides a tabular view of your data where you can start to examine it.

## Sampling[¶](https://knowledge.dataiku.com/latest/courses/basics/explore-data/explore-your-data.html#sampling "Permalink to this headline")

Dataiku shows only a sample of a dataset when you are working interactively with it.

You can see the sampling method in the top left of the **Explore** tab. By default, the sample in this tab includes the first 10,000 records of the dataset.

To view the total row count of your dataset, select **Compute row count** (the arrow icon).

To see or change the sample settings of a dataset select the **Sample** badge, which opens a panel on the left.

## Storage Type and Meaning[¶](https://knowledge.dataiku.com/latest/courses/basics/explore-data/explore-your-data.html#storage-type-and-meaning "Permalink to this headline")

Beneath each column name is the storage **type** and **meaning**.

Dataiku detects a meaning of “Integer” for *customer\_id*, based upon the fact that most values of *customer\_id* are integers. The gauge shows red for the few values that do not match this meaning, which allows us to determine whether these values are truly invalid customer IDs, or, as is the case here, Integer is too restrictive a meaning for *customer\_id*.

Click on the meaning and update it to **Text**. Now the gauge for *customer\_id* is entirely green.

Note

In this dataset, we do not have any missing values. But if we did, they would be represented by the color gray in the data quality bar.

## Charts[¶](https://knowledge.dataiku.com/latest/courses/basics/explore-data/explore-your-data.html#charts "Permalink to this headline")

You can use charts to explore a dataset. For example, we might want to know how often each type of t-shirt is ordered.

* Click on the **Charts** tab.

* From the panel on the left, drag and drop *Count of records* as the Y variable.

* Drag and drop *tshirt\_category* as the X variable.

Dataiku shows a column chart of *Count of records* by *tshirt\_category* for the current sample.

The chart reveals that the values of *tshirt\_category* are not consistently recorded. Sometimes black shirt color is recorded as “Black”, and sometimes as “Bl”. Similarly, white shirts are sometimes recorded as “White” and sometimes as “Wh”.

## Learn More[¶](https://knowledge.dataiku.com/latest/courses/basics/explore-data/explore-your-data.html#learn-more "Permalink to this headline")

Congratulations! You’ve created your first project, imported your first dataset, and created your first chart. In the Basics 102 course, the Hands-On Tutorial: Preparing Data will show you how to handle issues with the dataset by using a **Prepare** recipe.
