# Concept: SQL Notebooks[¶](https://knowledge.dataiku.com/latest/courses/dss-and-sql/sql-notebooks/concepts-summary.html#concept-sql-notebooks "Permalink to this headline")

## When to Use an SQL Notebook[¶](https://knowledge.dataiku.com/latest/courses/dss-and-sql/sql-notebooks/concepts-summary.html#when-to-use-an-sql-notebook "Permalink to this headline")

An SQL Notebook allows you to interact with the tables associated with your Dataiku SQL datasets, through the use of SQL queries.

With SQL notebooks, you can:

* perform queries on an SQL dataset for quick prototyping and data analysis,

* leverage an SQL engine for in-database computations, and

* return query outputs without having to write them as new datasets in your SQL database.

When creating an SQL notebook, you must link it to an SQL connection already set up by an administrator in your Dataiku instance.

## The SQL Notebook Interface[¶](https://knowledge.dataiku.com/latest/courses/dss-and-sql/sql-notebooks/concepts-summary.html#the-sql-notebook-interface "Permalink to this headline")

The main area of the SQL notebook interface is a window for writing queries.

In the left panel, the **Queries** tab lists all the queries available. When you first create your notebook, this tab is empty. You must click the **+Query** button to create your first query.

The left panel also contains a **Tables** tab that lists:

* the tables available in your connection,

* additional information like the list of columns in each table, and

* the column data types.

When you have several tables, you can sort them by table name or dataset name.

By clicking the **plus** icon next to a table name, a `SELECT` statement displays within the query window. This is where you can quickly build your query by selecting a column name to add to the query window.

When you run the query, the results display below the query window for you to explore and download.

The SQL notebook also lets you switch views between full screen and stacked query modes and add a new query or markdown cell.

You can even add comments, either in plain text or markdown within a markdown cell.

Dataiku stores all queries and comments you create in the **Queries** tab as distinct cells. Simply click to view them. As you can see below, each query cell is where you execute and modify a single query. It is recommended to keep a single cell for each query as each cell has its own history and you can rerun any query at a later time.

For better clarity, note that you can name your query.

Once back in the **Flow**, you’ll notice the SQL notebook is not represented by a Flow icon. This is because SQL notebooks are made to write SQL code for experimentation only. It is a Lab object outside of the Flow.

Note

To use a query from a notebook in the Flow, you must turn the query into an SQL code recipe. To do so:

Go back to the notebook through the top navigation bar or by typing the shortcut **G** then **N** from the Flow.

Select the relevant query in full screen query mode.

Click **Create Recipe**.

This SQL recipe is added to the Flow as it is used to transform your data and generate an output dataset.

For more information, see SQL notebook in the product documentation.
