# Six Components of Model Development that Impact MLOps[¶](https://knowledge.dataiku.com/latest/courses/mlops/prod-concepts/model-dev-components.html#six-components-of-model-development-that-impact-mlops "Permalink to this headline")

According to Introducing MLOps: How to Scale Machine Learning in the Enterprise, you can avoid common pitfalls associated with MLOps by performing certain tasks during the model development stage itself.

While there are several components to model development, we’ll focus on key components of model development that can have an impact on MLOps after deployment. The earlier these components are considered, and the measurements of them addressed, in the MLOps lifecycle, the less the accumulated debt.

## Alignment with Business Objectives[¶](https://knowledge.dataiku.com/latest/courses/mlops/prod-concepts/model-dev-components.html#alignment-with-business-objectives "Permalink to this headline")

Business objectives should guide model development. We can build safeguards like sanity checks and visualizations to keep stakeholders informed by considering business objectives during the design phase.

We can then be prepared to take action, such as redesigning and redeploying the model or adjusting business metrics.

We know model development is based on business objectives when we can answer questions such as these:

* What is the business problem we want to address? How will the model address it?

* What level of model performance is acceptable to the business?

* Is the model negatively or positively impacting the business?

* How are models monitored over time to detect model deterioration?

* Who will be responsible for the performance and maintenance of machine learning models in production?

## Exploratory Data Analysis (EDA)[¶](https://knowledge.dataiku.com/latest/courses/mlops/prod-concepts/model-dev-components.html#exploratory-data-analysis-eda "Permalink to this headline")

To develop a model, we need suitable data. Once the organization has established the business objectives for the model, we can explore and analyze the data. There are many tests for data suitability:

* Is the data quality sufficient? For example, is the data complete and in a suitable format?

* Can we legally use the data?

* How can we ensure our data security practices satisfy government regulations such as the EU General Data Protection Regulation (GDPR)?

* Will stakeholders understand the data and be able to derive analyses from it?

* Is the data sufficiently accurate, reliable, and free from bias–both statistical and discriminatory?

* Will the data be available in real-time in production?

* As data changes, how will we continuously monitor and evaluate model performance to ensure the model is behaving as expected?

## Feature Engineering and Selection[¶](https://knowledge.dataiku.com/latest/courses/mlops/prod-concepts/model-dev-components.html#feature-engineering-and-selection "Permalink to this headline")

Feature engineering and feature selection are crucial steps in model development. Once we better understand the data, we can cleanse and transform it into features representing the problem. These features then become inputs–used to improve model performance.

There are many considerations when selecting features, including the following:

* What features can we create from existing data according to EDA and business expertise?

* Does the feature help solve the problem identified by the business objectives?

* What level of explainability do we need for the features?

* Is the feature irrelevant and of poor data quality?

* How will we maintain these features over time?

## Reproducibility[¶](https://knowledge.dataiku.com/latest/courses/mlops/prod-concepts/model-dev-components.html#reproducibility "Permalink to this headline")

Data scientists experiment and iterate on a model many times before it is ready for production.

Sometimes, we want to save specific model versions to use later. For a model to be reproducible, we need to have version control of all the assets and parameters involved, including the data used to train and evaluate the model.

Here are some tests for model reproducibility:

* Is the design environment well documented?

* Can the same model results be reproduced in production?

* Is there version control of all the assets and parameters involved?

## Responsible AI[¶](https://knowledge.dataiku.com/latest/courses/mlops/prod-concepts/model-dev-components.html#responsible-ai "Permalink to this headline")

When building out AI pipelines, it is critical to embed Responsible AI in every stage, asking questions and looking for key checkpoints along the way.

We not only want our models to be reproducible but we also want them to be accountable, sustainable, and governable.

Whether or not responsible AI is a legal requirement; it makes good business sense because it lowers risk.

* How can we ensure that our model is behaves in ways aligned with vetted business objectives?

* What protected characteristics can we omit from the model training process (such as ethnicity, gender, age, religion, etc.) to protect the data privacy of our customers, employees, users, and citizens?

* How do we account for and mitigate model bias and unfairness against certain groups?

* How long can we legitimately retain data beyond its original intended use?

* Are the means by which we collect and store data in line with regulatory standards such as the GDPR and our own company’s standards?

* How can we ensure responsible AI over time?

## Training, Evaluation, and Drift[¶](https://knowledge.dataiku.com/latest/courses/mlops/prod-concepts/model-dev-components.html#training-evaluation-and-drift "Permalink to this headline")

Through an intensive and iterative process of training and optimization, new ML models are built. We will want to keep track of each experimental model and perform side-by-side comparisons. We will have to decide the criteria used in model evaluation. Some examples of these criteria are:

* What performance metrics are measured when developing and selecting models?

* How explainable is the model?

* How easy is it to deploy the model?

* How does the model treat members of different groups (i.e., is the model fair?)?

On top of model evaluation that ensures we choose the best algorithm, we also need to set up validation tools to help answer:

* Will the machine learning model still be aligned with the business objective in a day, a month, a year?

* Can I track data drift to be able to update the model?

### Resources for Exploration[¶](https://knowledge.dataiku.com/latest/courses/mlops/prod-concepts/model-dev-components.html#resources-for-exploration "Permalink to this headline")

* Hands-On: Monitoring Models in Production

* MLOps

* Automatic Feature Engineering: An Event-Driven Approach

* Dataiku MLOps: How to Operator and Monitor Projects

* Why You Should Care About Data Drift

* Towards Reliable MLOps with Drift Detectors

* A Primer on Data Drift and Drift Detection Techniques

* Explainable AI in Practice

* Explaining Bias in Your Data

* 3 Steps Toward More Ethical AI

* Who’s Responsible for Responsible AI?

* Responsible AI for Empowered Teams

* What’s the Link Between AI Governance, MLOps, and Responsible AI? Scaling AI
