# Wrap Up: Time Series Basics[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/course-complete.html#wrap-up-time-series-basics "Permalink to this headline")

## Congratulations![¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/course-complete.html#congratulations "Permalink to this headline")

You’ve just completed the **Time Series Basics** course. To recap, here are a few of the main takeaways from this course:

* Time series data sets consist of repeated numerical measurements (of one or more variables or entities) that depend on time and are ordered sequentially with time.

* Entries in time series data occur in equally spaced time intervals. In addition to this, raw time series data can sometimes contain irregularly-spaced entries and require some processing to space the data equally.

* A time series data set can be univariate — consisting of sequential measurements of a single variable over time; multivariate — consisting of sequential measurements of multiple related variables over time; or it can consist of multiple time series, that is, it contains measurements of multiple entities that are independent.

* Dataiku DSS works with time series that come in wide format or long format. Data in the wide format can be easy to understand and more natural to use for plotting, while data in the long format can provide a compact way of representing time series. The decision on which format to use is often based on the kinds of models to use with the data.

* A time series can be decomposed into the trend, seasonality, cycle, and random variation components. Identifying these components helps to understand the underlying patterns in the data. We can also use each of these components to build a model so that the models can then be combined and applied to the time series.

* Finally, the objectives of time series analysis can be descriptive, explanatory, forecasting, or control.

## Learn More[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/course-complete.html#learn-more "Permalink to this headline")

To learn more, be sure to check out the Time Series Preparation and Time Series Modeling & Forecasting courses.
