# Concept: Objectives of Time Series Analysis[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/objectives/objectives-concept-summary.html#concept-objectives-of-time-series-analysis "Permalink to this headline")

Knowing the objectives of a time series analysis is essential for choosing the right kinds of strategies to implement. Objectives can be

* Descriptive

* Explanatory

* Forecasting

* Control

## Descriptive[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/objectives/objectives-concept-summary.html#descriptive "Permalink to this headline")

A descriptive analysis is best served by plotting the time series data. Plotting provides a “high level“ overview of the time series and its main components: the trend, seasonality, cycle, and random variations.

For example, by plotting the U.S. International Air Passenger and Freight Statistics Report, data on the number of domestic airline passengers in the United States, we observe a seasonal pattern and an upward trend in the number of passengers over the years.

Plotting can also reveal any points in the data that appear inconsistent with the data pattern, that is, outliers.

Additionally, plotting can reveal turning points in the data, which can be useful when deciding on forecasting strategies. For instance, we may have to fit different models to portions of the data that occur before and after turning points.

## Explanatory[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/objectives/objectives-concept-summary.html#explanatory "Permalink to this headline")

Suppose we want to explain the behavior of a multivariate time series data. We can use the changes in one variable to explain another variable, and thereby understand how the two variables are related.

Additionally, we can explain the behavior of a time series by training models on its components.

## Forecasting[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/objectives/objectives-concept-summary.html#forecasting "Permalink to this headline")

Forecasting uses the observed values of a time series with a model to predict future time series values.

Several forecasting techniques are available for use with time series data. One example is the ARIMA model, which we’ve used with the airline dataset here to forecast the number of passengers for the upcoming years.

## Control[¶](https://knowledge.dataiku.com/latest/courses/timeseries-basics/objectives/objectives-concept-summary.html#control "Permalink to this headline")

The goal of an analysis can also be to control a physical system or business outcome. For example, an airline company may want to increase its profit by increasing the number of passengers who travel in a given period. Suppose a forecast of passengers shows a decline in travel for the said period. The airline may attempt to control this outcome by offering lower ticket prices or airline rewards, which could lead to an increase in its profit.
