# How to use spaCy models in Dataiku[¶](https://knowledge.dataiku.com/latest/kb/analytics-ml/nlp-code/How-to-use-spaCy-models-in-DSS.html#how-to-use-spacy-models-in-dataiku "Permalink to this headline")

Greetings fellow Linguists,

To use spaCy models in Dataiku, you can start by installing it like any other Python package in Dataiku:

* by creating a code environment and adding “spacy” to your package requirements.

To do so, follow the documentation on managing Python packages.

However, some functionalities of spaCy, such as language-specific tokenizers, rely on models that are not bundled in the library itself. To use these models, you need an additional download step. Typically, this can create issues on shared DSS nodes where users do not have write access to shared locations on the server (see User Isolation Framework).

To overcome this challenge, you can use spaCy dedicated pip delivery mechanism. For instance, in your code-env requirement setting, add `https://github.com/explosion/spacy-models/releases/download/en\_core\_web\_sm-2.2.5/en\_core\_web\_sm-2.2.5.tar.gz`

After adding this link, rebuild your code environment. To test that it works correctly, run the following code in a notebook using this code environment.

§ import spacy

§ nlp = spacy.load("en\_core\_web\_sm")

Voila! You can now use spaCy along with its dedicated English language model.

Happy natural language processing!
