# Managing Plugin Versions with Git[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/plugin-push.html#managing-plugin-versions-with-git "Permalink to this headline")

After developing a Dataiku plugin on your instance, you can manage versions of the plugin on a remote Git repository (e.g., GitHub). This makes it possible to share the plugin across multiple Dataiku DSS instances, and to allow users on those other instances to contribute updates to the plugin.

In this tutorial, you will learn how to:

* Version your plugins with development branches

* Track the history of development

* Connect to a remote Git repository

## Prerequisites[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/plugin-push.html#prerequisites "Permalink to this headline")

* You should work through the Plugins course in order to have a locally developed plugin.

* Familiarity with the basics of Git

## Technical Requirements[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/plugin-push.html#technical-requirements "Permalink to this headline")

* Access to a remote Git repository where you can push changes. Ideally it should be an empty repository.

* Access to a Dataiku DSS instance that has been set up to work with that remote Git repository.

## Connect to a Remote Git Repository[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/plugin-push.html#connect-to-a-remote-git-repository "Permalink to this headline")

Open the plugin you created in the Plugins course.

In order to share development of this plugin with other coders, we need to connect to a remote Git repository (repo).

* Click on the change tracking indicator and select **Add a remote**.

* Enter the URL of the remote and click **OK**

* If the master branch on the remote Git repo has any commits ahead of the local master branch, **Pull** those changes. This will be necessary if the repo you’re connecting to is not empty.

* Now, from the change tracking indicator, select **Push**.

In your remote Git repo, you can see that the master branch has been successfully pushed.

Note

We recommend using a separate repository for each plugin.

## Git Versioning[¶](https://knowledge.dataiku.com/latest/kb/customization/plugin-management/plugin-push.html#git-versioning "Permalink to this headline")

Now we’d like to work on changes to the plugin, using a development branch so that other people can continue using the original plugin.

* From the branch indicator, click **Create new branch**.

* Name the new branch `library` and click **Create**.

This creates a new development branch of the plugin off of the master branch. Now let’s make some changes:

* Under the `first-plugin` folder, create a new folder called `python-lib`

* Under the `python-lib` folder, create a new file called `compute\_corr.py`

* Cut the definitions of the functions `compute\_pairs()` and `compute\_corr()` from `recipe.py` and paste them into `compute\_corr.py`.

* Add the line `import pandas as pd, numpy as np` to the top of `compute\_corr.py`

* Add the line `from compute\_corr import \*` to the top of `recipe.py`.

Click on the **History** tab to see the changes you’ve made on this branch. If you switch to the master branch, you’ll see that the history only has the original development to the plugin, and none of the changes we’ve made to the branch.

* Switch back to the `library` branch.

* From the change tracking indicator, select **Push**.

You can see the `library` branch has been pushed to your remote Git repo. In order to merge the changes with the master branch, do that in the normal way outside of Dataiku DSS.

Finally, to see the merges reflected in Dataiku DSS, first **Fetch** the changes from the remote Git repo and then **Pull** the changes to your local Git.
