# Plugin Naming Policies and Conventions[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#plugin-naming-policies-and-conventions "Permalink to this headline")

Plugins are a great way to extend Dataiku but sometimes it is difficult to tell which of your installed plugins are locally developed. Your installation of Dataiku comes with built-in plugins, but you can also add new plugins from the Plugin Store (here are the 2 ways to access), develop your own, or upload plugins from other developers. One way to keep all your ducks in a row is to apply a plugin naming convention. In fact, locally-developed plugins must follow the requirements described in this article.

Another benefit of following a naming convention is being able to identify the locally-developed plugins in your list of installed plugins. In addition, when you share your plugins, your colleagues will be able to understand the purpose of the plugin.

Note

Dataiku does not provide support for your locally-developed plugins. You are responsible for owning and maintaining the plugins you create.

## What does this article contain?[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#what-does-this-article-contain "Permalink to this headline")

This article describes plugin naming policies and recommendations. Naming is an important area of plugin development that is often overlooked. Dataiku DSS requires that plugin names and identifiers meet certain policies.

## What are plugins?[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#what-are-plugins "Permalink to this headline")

A plugin is a package of reusable components that extends the functionality of Dataiku DSS. When you make your own plugin, you are extending DSS. A plugin is made up of one or more components. A component is a GUI wrapper around custom code that exposes a Dataiku element such as a recipe, dataset, or web app.

## What are some examples of plugins?[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#what-are-some-examples-of-plugins "Permalink to this headline")

Plugins range from the very simple to the very complex. For example, plugins can be used to create a connector to read or write data to databases or connect to external APIs. Some examples are connecting with Salesforce data, or get weather forecast by location. You can find more plugins in the plugin store. The possibilities are limitless!

## Why should I create plugins?[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#why-should-i-create-plugins "Permalink to this headline")

Plugins turn custom logic into components that can be used by anyone, giving less technical users the ability to collaborate and technical users the ability to standardize the way data is processed. Plugins can easily be shared by the community of users in an organization and even shared across organizations. Since most plugins are open source, anyone can view the underlying code and make contributions to it or adapt it.

## Where can I find the code for the public plugins?[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#where-can-i-find-the-code-for-the-public-plugins "Permalink to this headline")

You can find the code for some but not all of the public plugins in GitHub (link).

## Plugin naming[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#plugin-naming "Permalink to this headline")

The plugin summary displays information about the plugin and its components. You can edit the display name and identifier for the plugin in the Edit tab.

You can also edit the component display name and component identifier in the Edit tab. Adding a description is a good idea because it documents the reason why you created the component and lets others understand its usefulness and purpose.

## Plugin Naming Policies[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#plugin-naming-policies "Permalink to this headline")

A naming error happens when the name of the plugin, or any of its components, labels, or tags, does not meet plugin naming policies. Luckily, you can avoid these errors by following the plugin naming policies below. Most of the policies are required while a few are recommended. (Future: These rules are automatically checked by the plugin dev kit.)

## Plugin.json description[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#plugin-json-description "Permalink to this headline")

## How can I get started if I am new to plugins?[¶](https://knowledge.dataiku.com/latest/kb/customization/plugins/Plugin-Naming-Policies-and-Conventions.html#how-can-i-get-started-if-i-am-new-to-plugins "Permalink to this headline")

If you are new to plugins, you can get started by reading the latest documentation, completing step-by-step tutorials, and by visiting the Plugin store. From Dataiku DSS, you can find the plugins by selecting Plugins from the administration menu:

Tip

One of the golden rules of plugins is to **never use “import dataiku”** in a library. With few exceptions, plugins do not depend on Dataiku unless it is an administrative plugin.
