# In a Formula, how to check if a variable belongs to a set of values?[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/In-a-formula-how-to-check-if-a-variable-belongs-to-a-set-of.html#in-a-formula-how-to-check-if-a-variable-belongs-to-a-set-of-values "Permalink to this headline")

A common need when using Formulas is to check whether a variable (generally, a column) belongs to a set of values.

For example, you may want to check if *mycolumn* has value 1, 2 or 3. To do that in a formula, use the `arrayContains` function:

§ arrayContains([1,2,3], mycolumn)

In other words, instead of checking if “*mycolumn* is in [1,2,3]”, you check if “[1,2,3] contains *mycolumn*”.

It may be useful to recall the product documentation on reading column values.

For example, to do the same in a column named *my column* (note the space), you would use:

§ arrayContains(["a", "b", "c"], strval("my column"))

If you wanted to replace specific values with a variable, normal variable syntax rules apply.

§ arrayContains([${my_var1}, ${my_var2}, 3], mycolumn)
