# Dealing with Accounting-style negative numbers[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/dealing_with_accounting_style_negative_numbers.html#dealing-with-accounting-style-negative-numbers "Permalink to this headline")

In Accounting, it is common to represent negative numbers with leading and trailing parentheses. For example, `(200)` equals `-200`.

A “Find and replace” step in the **Prepare** recipe can transform a string column with values like `(200)` into a numeric column with values like `-200`.

## Find and Replace Step[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/dealing_with_accounting_style_negative_numbers.html#find-and-replace-step "Permalink to this headline")

In a “Find a replace” step,

* Choose the column with the accounting-style values.

* Replace the open parenthesis with a hyphen (minus sign).

* Replace the closed parenthesis with no value.

Note

The storage type of the original column is a string, but the newly-created column is a double.

In this example, only one column is being converted. Changing the Column setting from “single” to “multiple” would allow you to convert multiple columns in the same step.

## What’s next?[¶](https://knowledge.dataiku.com/latest/kb/data-prep/prepare-recipe/dealing_with_accounting_style_negative_numbers.html#whats-next "Permalink to this headline")

There are a number of places you can learn more about data preparation in Dataiku DSS.

* For a structured approach, visit the Academy to find courses on topics like Basics 101 and Visual Recipes 101.

* You can also see the reference documentation.
